/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral.ender;

import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.common.entities.projectiles.EnderGoo;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AbstractBlastling
extends AbstractEnderling
implements RangedAttackMob {
    public static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(AbstractBlastling.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int fleeCool;
    public int fleeTime;
    public int postAttackTick;
    public int attackCoolTick;
    public boolean isFleeing;
    public static String IDLE = "idle";
    public static String PRE_ATTACK = "pre_attack";
    public static String ATTACK = "attack";
    public static String POST_ATTACK = "post_attack";
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState preAttackAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState postAttackAnimationState = new AnimationState();

    public AbstractBlastling(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new BlastlingRangedGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WanderGoal<AbstractBlastling>(this, 1.0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !AbstractBlastling.this.isFleeing;
            }

            public boolean m_8045_() {
                return super.m_8045_() && !AbstractBlastling.this.isFleeing;
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.BlastlingHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.BlastlingArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.BlastlingDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.BlastlingHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.BlastlingArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.BlastlingDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("FleeCool")) {
            this.fleeCool = compound.m_128451_("FleeCool");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FleeCool", this.fleeCool);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (ANIM_STATE.equals(p_33609_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimations();
                    break;
                }
                case 1: {
                    this.preAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.preAttackAnimationState);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 3: {
                    this.postAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.postAttackAnimationState);
                }
            }
        }
        super.m_7350_(p_33609_);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, PRE_ATTACK)) {
            return 1;
        }
        if (Objects.equals(animation, ATTACK)) {
            return 2;
        }
        if (Objects.equals(animation, POST_ATTACK)) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.preAttackAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.postAttackAnimationState);
        return animationStates;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractBlastling;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.BlastlingLimit.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.BLASTLING_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.BLASTLING_HURT.get();
    }

    @Override
    public void stepSound() {
        this.m_5496_((SoundEvent)ModSounds.BLASTLING_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.BLASTLING_DEATH.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (!this.isHiding()) {
                ColorUtil colorUtil = new ColorUtil(15821289);
                Vec3 vec3 = this.getHorizontalLookAngle();
                if (this.f_19797_ % 2 == 0) {
                    this.f_19853_.m_7106_((ParticleOptions)new MagicSmokeParticle.Option(16043510, 11403452, 10 + this.f_19853_.m_213780_().m_188503_(10), 0.35f), this.m_20185_() + vec3.f_82479_ / 2.0, this.m_20188_() + (double)0.35f, this.m_20189_() + vec3.f_82481_ / 2.0, 0.0, 0.01, 0.0);
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.SMALL_STATION_CULT_SPELL.get(), this.m_20185_() + vec3.f_82479_ / 2.0, this.m_20188_() + (double)0.35f, this.m_20189_() + vec3.f_82481_ / 2.0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue());
                }
            }
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.getCurrentAnimation() == 0, this.f_19797_);
        } else {
            if (this.fleeCool > 0) {
                --this.fleeCool;
            }
            if (this.fleeCool <= 0 && this.m_5448_() != null) {
                if ((double)this.m_5448_().m_20270_((Entity)this) <= 3.0) {
                    this.isFleeing = true;
                    Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this, (int)16, (int)7, (Vec3)this.m_5448_().m_20182_());
                    if (vec3 != null) {
                        this.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)1.2f);
                    }
                }
                if (this.isFleeing) {
                    ++this.fleeTime;
                    if (this.fleeTime >= MathHelper.secondsToTicks(5) || (double)this.m_5448_().m_20270_((Entity)this) > 3.0 && this.m_21573_().m_26571_()) {
                        this.isFleeing = false;
                        this.fleeTime = 0;
                        this.fleeCool = MathHelper.secondsToTicks(5);
                    }
                }
            }
            if (this.getCurrentAnimation() == this.getAnimationState(POST_ATTACK)) {
                ++this.postAttackTick;
                if (this.postAttackTick >= MathHelper.secondsToTicks(0.5f)) {
                    this.setAnimationState(IDLE);
                    this.postAttackTick = 0;
                }
            } else if (this.attackCoolTick > 0) {
                --this.attackCoolTick;
            }
            if (this.teleportCool <= 0 && !this.isStaying() && !this.isHiding() && this.m_5448_() != null && this.postAttackTick <= 0 && this.m_5448_().m_20270_((Entity)this) <= 10.0f) {
                this.startHide();
            }
        }
    }

    @Override
    public int getHidingDuration() {
        return MathHelper.secondsToTicks(3);
    }

    @Override
    public void teleportAfterHiding() {
        if (this.m_5448_() != null) {
            this.teleportAway((Entity)this.m_5448_(), 28.0);
        } else {
            this.teleport(28.0);
        }
        this.teleportCool = MathHelper.secondsToTicks(20);
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
    }

    private void shoot(boolean leftArm, LivingEntity target) {
        this.shoot(leftArm, target.m_20185_(), target.m_20227_(0.3333333333333333), target.m_20189_());
        this.m_5496_((SoundEvent)ModSounds.BLASTLING_SHOOT.get(), 1.0f, this.m_6100_());
    }

    private void shoot(boolean leftArm, double targetX, double targetY, double targetZ) {
        double d0 = this.getHeadX(leftArm);
        double d2 = this.getHeadZ(leftArm);
        double d3 = targetX - d0;
        double d4 = targetY - this.m_20188_();
        double d5 = targetZ - d2;
        EnderGoo enderGoo = new EnderGoo((LivingEntity)this, d3, d4, d5, this.f_19853_);
        enderGoo.m_6034_(d0, this.m_20227_(0.75), d2);
        enderGoo.m_146922_(this.m_146908_());
        enderGoo.m_146926_(this.m_146909_());
        this.f_19853_.m_7967_((Entity)enderGoo);
    }

    private double getHeadX(boolean leftArm) {
        float f = (this.f_20883_ + 180.0f * (leftArm ? 0.0f : 0.75f)) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return this.m_20185_() + (double)f1;
    }

    private double getHeadZ(boolean leftArm) {
        float f = (this.f_20883_ + 180.0f * (leftArm ? 0.0f : 0.75f)) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return this.m_20189_() + (double)f1;
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    public static class BlastlingRangedGoal
    extends Goal {
        private final AbstractBlastling mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = 0;
        private int totalShots = 0;
        private int shots = 0;

        public BlastlingRangedGoal(AbstractBlastling mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (this.mob.isFleeing || this.mob.mobHurtTime > 0 || this.mob.attackCoolTick > 0 || this.mob.isHiding()) {
                return false;
            }
            if (livingentity != null && livingentity.m_6084_() && (double)livingentity.m_20270_((Entity)this.mob) > 3.0 && this.mob.m_142582_((Entity)livingentity)) {
                this.totalShots = this.mob.m_217043_().m_216332_(1, 4) * 2;
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && (double)this.target.m_20270_((Entity)this.mob) > 3.0 && this.mob.m_142582_((Entity)this.target) && !this.mob.isFleeing && !this.mob.isHiding() && this.shots < this.totalShots && this.mob.mobHurtTime <= 0;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.setAnimationState(PRE_ATTACK);
            this.mob.m_216990_((SoundEvent)ModSounds.BLASTLING_PRE_ATTACK.get());
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.mob.getCurrentAnimation() == this.mob.getAnimationState(PRE_ATTACK) || this.mob.getCurrentAnimation() == this.mob.getAnimationState(ATTACK)) {
                this.mob.setAnimationState(POST_ATTACK);
            }
            if (this.shots >= this.totalShots) {
                this.mob.attackCoolTick = 20;
            }
            this.target = null;
            this.attackTime = 0;
            this.shots = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null) {
                ++this.attackTime;
                if ((double)this.target.m_20270_((Entity)this.mob) > 10.0) {
                    this.mob.m_21573_().m_5624_((Entity)this.target, 1.0);
                } else {
                    this.mob.m_21573_().m_26573_();
                }
                MobUtil.instaLook((Mob)this.mob, (Entity)this.target);
                if (this.attackTime > 20) {
                    if (this.mob.getCurrentAnimation() == this.mob.getAnimationState(PRE_ATTACK)) {
                        this.mob.setAnimationState(ATTACK);
                    }
                    if (this.attackTime % 5 == 0) {
                        ++this.shots;
                        this.mob.shoot(this.shots % 2 != 0, this.target);
                    }
                } else if (this.mob.getCurrentAnimation() != this.mob.getAnimationState(PRE_ATTACK)) {
                    this.mob.setAnimationState(PRE_ATTACK);
                }
            }
        }
    }
}

