/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.FoggyCloudParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.common.entities.util.AbstractTrap;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class AcidPool
extends AbstractTrap {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(AcidPool.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(AcidPool.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(AcidPool.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_WARMUP_COLOR = SynchedEntityData.m_135353_(AcidPool.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_SOUND_EVENT = SynchedEntityData.m_135353_(AcidPool.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int warmupDelayTicks = 0;
    private int lifeTick;
    private boolean sentSpikeEvent;

    public AcidPool(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setParticle((ParticleOptions)ModParticleTypes.NONE.get());
        this.setDuration(50);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_COLOR, (Object)4502825);
        this.m_20088_().m_135372_(DATA_WARMUP_COLOR, (Object)4502825);
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(2.0f));
        this.m_20088_().m_135372_(DATA_DAMAGE, (Object)Float.valueOf(2.0f));
        this.m_20088_().m_135372_(DATA_SOUND_EVENT, (Object)"");
    }

    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)(this.radius() * 2.0f), (float)0.5f);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", this.sentSpikeEvent);
        compound.m_128350_("Radius", this.radius());
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128405_("Color", this.getColor());
        compound.m_128405_("WarmupColor", this.getWarmupColor());
        compound.m_128405_("Warmup", this.getWarmupDelayTicks());
        compound.m_128405_("LifeTick", this.lifeTick);
        compound.m_128359_("Sound", this.getSoundEvent());
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Active")) {
            this.sentSpikeEvent = compound.m_128471_("Active");
        }
        if (compound.m_128441_("Radius")) {
            this.setRadius(compound.m_128457_("Radius"));
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
        if (compound.m_128441_("Color")) {
            this.setColor(compound.m_128451_("Color"));
        }
        if (compound.m_128441_("WarmupColor")) {
            this.setWarmupColor(compound.m_128451_("WarmupColor"));
        }
        if (compound.m_128441_("Warmup")) {
            this.setWarmupDelayTicks(compound.m_128451_("Warmup"));
        }
        if (compound.m_128441_("LifeTick")) {
            this.lifeTick = compound.m_128451_("LifeTick");
        }
        if (compound.m_128441_("Sound")) {
            this.setSoundEvent(compound.m_128461_("Sound"));
        }
    }

    public void setRadius(float p_19713_) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)p_19713_, (float)0.0f, (float)32.0f)));
        }
    }

    public void setDamage(float damage) {
        this.m_20088_().m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DATA_DAMAGE)).floatValue();
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR);
    }

    public void setColor(int p_19715_) {
        this.m_20088_().m_135381_(DATA_COLOR, (Object)p_19715_);
    }

    public int getWarmupColor() {
        return (Integer)this.m_20088_().m_135370_(DATA_WARMUP_COLOR);
    }

    public void setWarmupColor(int p_19715_) {
        this.m_20088_().m_135381_(DATA_WARMUP_COLOR, (Object)p_19715_);
    }

    public int getWarmupDelayTicks() {
        return this.warmupDelayTicks;
    }

    public void setWarmupDelayTicks(int p_19715_) {
        this.warmupDelayTicks = p_19715_;
    }

    public String getSoundEvent() {
        return (String)this.m_20088_().m_135370_(DATA_SOUND_EVENT);
    }

    public void setSoundEvent(String p_19715_) {
        this.m_20088_().m_135381_(DATA_SOUND_EVENT, (Object)p_19715_);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    @Override
    public float radius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getWarmupDelayTicks() <= 0) {
                if (!this.sentSpikeEvent) {
                    this.sentSpikeEvent = true;
                    SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(this.getSoundEvent()));
                    this.m_5496_(soundEvent, 1.0f, 1.0f);
                    ColorUtil colorUtil = new ColorUtil(this.getColor());
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), colorUtil.red(), colorUtil.green(), colorUtil.blue(), this.radius());
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.ROLLING_SPIRAL.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), colorUtil.red(), colorUtil.green(), colorUtil.blue(), this.radius());
                    serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), this.radius(), 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), this.radius(), 1), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            } else {
                --this.warmupDelayTicks;
                if (this.f_19853_.m_213780_().m_188499_()) {
                    ColorUtil colorUtil = new ColorUtil(this.getWarmupColor());
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.BIG_CULT_SPELL.get(), this.m_20185_(), this.m_20186_() - 0.5, this.m_20189_(), colorUtil.red(), colorUtil.green(), colorUtil.blue(), this.radius() / 2.0f);
                }
            }
            if (this.sentSpikeEvent) {
                ++this.lifeTick;
                if ((this.getParticle() == null || this.getParticle() == ModParticleTypes.NONE.get()) && this.f_19797_ % 5 == 0) {
                    serverLevel.m_8767_((ParticleOptions)new FoggyCloudParticleOption(new ColorUtil(this.getColor()), this.radius() / 2.0f, 1), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
                for (LivingEntity livingEntity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())) {
                    if (this.owner != null) {
                        if (livingEntity == this.owner || MobUtil.areAllies((Entity)this.owner, (Entity)livingEntity)) continue;
                        targets.add(livingEntity);
                        continue;
                    }
                    targets.add(livingEntity);
                }
                if (!targets.isEmpty()) {
                    for (LivingEntity livingEntity : targets) {
                        if (!EntitySelector.f_20406_.test(livingEntity)) continue;
                        if (this.owner != null) {
                            livingEntity.m_6469_(ModDamageSource.acid(this, (Entity)this.owner), this.getDamage());
                            continue;
                        }
                        livingEntity.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
                    }
                }
                if (this.lifeTick >= this.getDuration()) {
                    this.m_146870_();
                }
            }
        }
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

