/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.IceSpike;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class IceSpear
extends IceSpike {
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;

    public IceSpear(EntityType<? extends AbstractArrow> p_36721_, Level p_36722_) {
        super(p_36721_, p_36722_);
    }

    public IceSpear(double p_36712_, double p_36713_, double p_36714_, Level p_36715_) {
        super(p_36712_, p_36713_, p_36714_, p_36715_);
    }

    public IceSpear(LivingEntity p_36718_, Level p_36719_) {
        super(p_36718_, p_36719_);
    }

    @NotNull
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntityType.ICE_SPEAR.get();
    }

    public byte m_36796_() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return (byte)(WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), livingEntity) + 1);
        }
        return super.m_36796_();
    }

    private void m_36723_() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void m_5790_(EntityHitResult p_37626_) {
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            float baseDamage = ((Double)SpellConfig.IceSpikeDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            Entity entity = p_37626_.m_82443_();
            if (this.m_36796_() > 0) {
                if (this.piercingIgnoreEntityIds == null) {
                    this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
                }
                if (this.piercedAndKilledEntities == null) {
                    this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
                }
                if (this.piercingIgnoreEntityIds.size() >= this.m_36796_() + 1) {
                    this.m_146870_();
                    return;
                }
                this.piercingIgnoreEntityIds.add(entity.m_19879_());
            }
            Entity entity1 = this.m_19749_();
            baseDamage += this.getExtraDamage();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                if (!entity.m_6084_() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingentity);
                }
                if ((flag = entity.m_6469_(ModDamageSource.iceSpike((Entity)this, (Entity)livingentity), baseDamage)) && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                flag = entity.m_6469_(ModDamageSource.iceSpike((Entity)this, (Entity)this), baseDamage);
            }
            if (flag && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(3 + livingEntity.m_217043_().m_188503_(2))));
                this.m_5496_((SoundEvent)ModSounds.ICE_SPIKE_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                Level level = livingEntity.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50354_.m_49966_()), (Entity)livingEntity);
                }
                if (this.m_36796_() <= 0) {
                    this.m_146870_();
                }
            }
        }
    }

    @Override
    protected void m_8060_(BlockHitResult p_36755_) {
        super.m_8060_(p_36755_);
        this.m_36723_();
    }

    @Override
    protected boolean m_5603_(Entity p_36743_) {
        return super.m_5603_(p_36743_) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(p_36743_.m_19879_()));
    }
}

