/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ExplosionUtil;
import com.Polarice3.Goety.utils.LootingExplosion;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class Lavaball
extends LargeFireball {
    private static final EntityDataAccessor<Boolean> DATA_UPGRADED = SynchedEntityData.m_135353_(Lavaball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.m_135353_(Lavaball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_EXPLOSION = SynchedEntityData.m_135353_(Lavaball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(Lavaball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_EXTRA_DAMAGE = SynchedEntityData.m_135353_(Lavaball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> DATA_FIERY = SynchedEntityData.m_135353_(Lavaball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Lavaball(EntityType<? extends Lavaball> p_i50163_1_, Level p_i50163_2_) {
        super(p_i50163_1_, p_i50163_2_);
    }

    public Lavaball(Level pWorld, double pX, double pY, double pZ, double pAccelX, double pAccelY, double pAccelZ) {
        this((EntityType<? extends Lavaball>)((EntityType)ModEntityType.LAVABALL.get()), pWorld);
        this.m_7678_(pX, pY, pZ, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(pAccelX * pAccelX + pAccelY * pAccelY + pAccelZ * pAccelZ);
        if (d0 != 0.0) {
            this.f_36813_ = pAccelX / d0 * 0.1;
            this.f_36814_ = pAccelY / d0 * 0.1;
            this.f_36815_ = pAccelZ / d0 * 0.1;
        }
    }

    public Lavaball(Level p_i1769_1_, LivingEntity p_i1769_2_, double p_i1769_3_, double p_i1769_5_, double p_i1769_7_) {
        super(p_i1769_1_, p_i1769_2_, p_i1769_3_, p_i1769_5_, p_i1769_7_, 0);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntityType.LAVABALL.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_UPGRADED, (Object)false);
        this.f_19804_.m_135372_(DATA_DANGEROUS, (Object)true);
        this.f_19804_.m_135372_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIERY, (Object)0);
        this.f_19804_.m_135372_(DATA_EXPLOSION, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(6.0f));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ModExplosionPower", this.getExplosionPower());
        pCompound.m_128350_("Damage", this.getDamage());
        pCompound.m_128350_("ExtraDamage", this.getExtraDamage());
        pCompound.m_128405_("Fiery", this.getFiery());
        pCompound.m_128379_("Dangerous", this.isDangerous());
        pCompound.m_128379_("Upgraded", this.isUpgraded());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ModExplosionPower", 99)) {
            this.setExplosionPower(pCompound.m_128457_("ModExplosionPower"));
        }
        if (pCompound.m_128425_("Damage", 99)) {
            this.setDamage(pCompound.m_128457_("Damage"));
        }
        if (pCompound.m_128425_("ExtraDamage", 99)) {
            this.setExtraDamage(pCompound.m_128457_("ExtraDamage"));
        }
        if (pCompound.m_128441_("Fiery")) {
            this.setFiery(pCompound.m_128451_("Fiery"));
        }
        if (pCompound.m_128441_("Dangerous")) {
            this.setDangerous(pCompound.m_128471_("Dangerous"));
        }
        if (pCompound.m_128441_("Upgraded")) {
            this.setUpgraded(pCompound.m_128471_("Upgraded"));
        }
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANGEROUS);
    }

    public void setDangerous(boolean pDangerous) {
        this.f_19804_.m_135381_(DATA_DANGEROUS, (Object)pDangerous);
    }

    public float getExplosionPower() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXPLOSION)).floatValue();
    }

    public void setExplosionPower(float pExplosionPower) {
        this.f_19804_.m_135381_(DATA_EXPLOSION, (Object)Float.valueOf(pExplosionPower));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float extra) {
        this.f_19804_.m_135381_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(extra));
    }

    public int getFiery() {
        return (Integer)this.f_19804_.m_135370_(DATA_FIERY);
    }

    public void setFiery(int fiery) {
        this.f_19804_.m_135381_(DATA_FIERY, (Object)fiery);
    }

    public boolean isUpgraded() {
        return (Boolean)this.f_19804_.m_135370_(DATA_UPGRADED);
    }

    public void setUpgraded(boolean upgraded) {
        this.f_19804_.m_135381_(DATA_UPGRADED, (Object)upgraded);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= MathHelper.secondsToTicks(10)) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult pResult) {
        HitResult.Type hitresult$type = pResult.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)pResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, pResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)pResult;
            this.m_8060_(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
        if (!this.f_19853_.f_46443_) {
            IOwned owned;
            Entity owner = this.m_19749_();
            boolean flag = this.isDangerous();
            if ((owner instanceof Player || owner instanceof IOwned && (owned = (IOwned)owner).getTrueOwner() instanceof Player) && !((Boolean)SpellConfig.LavaballGriefing.get()).booleanValue()) {
                flag = false;
            }
            LootingExplosion.Mode lootMode = CuriosFinder.hasWanting(owner) ? LootingExplosion.Mode.LOOT : LootingExplosion.Mode.REGULAR;
            ExplosionUtil.lootExplode(this.f_19853_, owner, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionPower(), flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, lootMode);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            Entity entity = pResult.m_82443_();
            Entity entity1 = this.m_19749_();
            float damage = 6.0f;
            float enchantment = this.getExtraDamage();
            int flaming = this.getFiery();
            if (entity1 instanceof Player) {
                damage = ((Double)SpellConfig.LavaballDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            } else if (entity1 instanceof LivingEntity) {
                damage = this.getDamage();
            }
            DamageSource damageSource = this.m_269291_().m_269453_((Fireball)this, this.m_19749_());
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                if (CuriosFinder.hasNetherRobe(livingEntity)) {
                    damageSource = ModDamageSource.magicFireball((Fireball)this, this.m_19749_(), this.f_19853_);
                }
                if (MobUtil.getOwner((Entity)livingEntity) != null && CuriosFinder.hasNetherRobe(MobUtil.getOwner((Entity)livingEntity))) {
                    damageSource = ModDamageSource.magicFireball((Fireball)this, this.m_19749_(), this.f_19853_);
                }
            }
            entity.m_6469_(damageSource, damage + enchantment);
            if (flaming != 0) {
                entity.m_20254_(5 * flaming);
            }
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        Entity entity = this.m_19749_();
        if (entity instanceof IOwned) {
            IOwned owned = (IOwned)entity;
            if (pEntity instanceof IOwned) {
                IOwned owned1 = (IOwned)pEntity;
                if (owned.getTrueOwner() == owned1.getTrueOwner()) {
                    return false;
                }
            }
            if (owned.getTrueOwner() == pEntity) {
                return false;
            }
        }
        if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
            return false;
        }
        if (this.isUpgraded() && pEntity instanceof AbstractHurtingProjectile) {
            return false;
        }
        return super.m_5603_(pEntity);
    }

    public boolean m_6128_() {
        return this.isUpgraded();
    }

    public boolean m_6469_(DamageSource p_36839_, float p_36840_) {
        if (this.isUpgraded()) {
            return false;
        }
        if (!((Boolean)SpellConfig.LavaballGriefing.get()).booleanValue()) {
            this.setDangerous(false);
        }
        return super.m_6469_(p_36839_, p_36840_);
    }
}

