/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SwordProjectile
extends AbstractArrow
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(SwordProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public SwordProjectile(EntityType<? extends AbstractArrow> p_i48546_1_, Level p_i48546_2_) {
        super(p_i48546_1_, p_i48546_2_);
    }

    public SwordProjectile(double p_i48547_2_, double p_i48547_4_, double p_i48547_6_, Level p_i48547_8_) {
        super((EntityType)ModEntityType.SWORD.get(), p_i48547_2_, p_i48547_4_, p_i48547_6_, p_i48547_8_);
    }

    public SwordProjectile(LivingEntity p_i48548_2_, Level p_i48548_3_, ItemStack p_i48790_3_) {
        super((EntityType)ModEntityType.SWORD.get(), p_i48548_2_.m_20185_(), p_i48548_2_.m_20227_(0.5), p_i48548_2_.m_20189_(), p_i48548_3_);
        this.m_5602_((Entity)p_i48548_2_);
        this.setItem(p_i48790_3_.m_41777_());
    }

    public void setItem(ItemStack pStack) {
        if (pStack.m_41720_() != this.getDefaultItem() || pStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)pStack.m_41777_(), p_213883_0_ -> p_213883_0_.m_41764_(1))));
        }
    }

    protected Item getDefaultItem() {
        return Items.f_42383_;
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            pCompound.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item"));
        this.setItem(itemstack);
    }

    protected ItemStack m_7941_() {
        return this.m_7846_().m_41777_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_36703_) {
            Vec3 vector3d = this.m_20184_();
            double d3 = vector3d.f_82479_;
            double d4 = vector3d.f_82480_;
            double d0 = vector3d.f_82481_;
            double d5 = this.m_20185_() + d3;
            double d1 = this.m_20186_() + d4;
            double d2 = this.m_20189_() + d0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        float f = 6.0f;
        float f1 = 0.0f;
        int i = 0;
        Entity owner = this.m_19749_();
        Item item = this.m_7846_().m_41720_();
        if (item instanceof SwordItem) {
            SwordItem swordItem = (SwordItem)item;
            f = swordItem.m_43299_();
            f1 += (float)swordItem.getEnchantmentLevel(this.m_7846_(), Enchantments.f_44980_);
            i = swordItem.getEnchantmentLevel(this.m_7846_(), Enchantments.f_44981_);
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = ModDamageSource.sword((Entity)this, (Entity)(owner == null ? this : owner));
        if (owner instanceof Player) {
            Player player = (Player)owner;
            damagesource = this.m_269291_().m_269075_(player);
        } else if (owner instanceof Mob) {
            Mob mob = (Mob)owner;
            damagesource = this.m_269291_().m_269333_((LivingEntity)mob);
        }
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (target.m_6469_(damagesource, f) && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (owner instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)owner);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingTarget);
                ItemHelper.setItemEffect(this.m_7846_(), livingTarget);
            }
            if (f1 > 0.0f) {
                double d0 = this.m_20185_() - livingTarget.m_20185_();
                double d1 = this.m_20189_() - livingTarget.m_20189_();
                livingTarget.m_147240_((double)(f1 * 0.5f), d0, d1);
            }
            if (i > 0) {
                livingTarget.m_20254_(i * 4);
            }
            this.m_7761_(livingTarget);
        }
        float f2 = 1.0f;
        this.m_5496_(soundevent, f2, 1.0f);
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Projectile projectile;
            Mob mob;
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
                return false;
            }
            if (this.m_19749_() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof Projectile && (projectile = (Projectile)pEntity).m_19749_() == this.m_19749_()) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    protected boolean m_142470_(Player p_150196_) {
        return p_150196_.m_150110_().f_35937_;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

