/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.util.BrewEffectCloud;
import com.Polarice3.Goety.common.entities.util.BrewGas;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SAddBrewParticlesPacket;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BrewUtils;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class ThrownBrew
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::m_6126_;

    public ThrownBrew(EntityType<? extends ThrownBrew> p_37527_, Level p_37528_) {
        super(p_37527_, p_37528_);
    }

    public ThrownBrew(Level p_37535_, LivingEntity p_37536_) {
        super((EntityType)ModEntityType.BREW.get(), p_37536_, p_37535_);
    }

    public ThrownBrew(Level p_37530_, double p_37531_, double p_37532_, double p_37533_) {
        super((EntityType)ModEntityType.BREW.get(), p_37531_, p_37532_, p_37533_, p_37530_);
    }

    protected Item m_7881_() {
        return (Item)ModItems.SPLASH_BREW.get();
    }

    protected float m_7139_() {
        return 0.05f;
    }

    public boolean m_20069_() {
        if (BrewUtils.getAquatic(this.m_7846_())) {
            return false;
        }
        return super.m_20069_();
    }

    public boolean m_5825_() {
        if (BrewUtils.getFireProof(this.m_7846_())) {
            return true;
        }
        return super.m_5825_();
    }

    public boolean isPushedByFluid(FluidType type) {
        if (BrewUtils.getAquatic(this.m_7846_()) && type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        if (BrewUtils.getFireProof(this.m_7846_()) && type == ForgeMod.LAVA_TYPE.get()) {
            return false;
        }
        return super.isPushedByFluid(type);
    }

    protected void m_8060_(BlockHitResult p_37541_) {
        super.m_8060_(p_37541_);
        if (!this.f_19853_.f_46443_ && !this.isGas()) {
            ItemStack itemstack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List<BrewEffectInstance> list = BrewUtils.getBrewEffects(itemstack);
            boolean flag = potion == Potions.f_43599_ && list.isEmpty();
            Direction direction = p_37541_.m_82434_();
            BlockPos blockpos = p_37541_.m_82425_();
            BlockPos blockpos1 = blockpos.m_121945_(direction);
            if (flag) {
                this.dowseFire(blockpos1);
                this.dowseFire(blockpos1.m_121945_(direction.m_122424_()));
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.dowseFire(blockpos1.m_121945_(direction1));
                }
            }
            for (BrewEffectInstance brewEffectInstance : list) {
                LivingEntity living;
                Entity entity = this.m_19749_();
                LivingEntity livingEntity = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
                brewEffectInstance.getEffect().applyDirectionalBlockEffect(this.f_19853_, p_37541_.m_82425_(), p_37541_.m_82434_(), livingEntity, brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemstack));
                brewEffectInstance.getEffect().applyBlockEffect(this.f_19853_, p_37541_.m_82425_(), livingEntity, brewEffectInstance.getDuration(), brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemstack));
            }
        }
    }

    protected void m_5790_(EntityHitResult p_37259_) {
        super.m_5790_(p_37259_);
        if (!this.f_19853_.f_46443_ && !this.isGas()) {
            ItemStack itemstack = this.m_7846_();
            List<BrewEffectInstance> list = BrewUtils.getBrewEffects(itemstack);
            for (BrewEffectInstance brewEffectInstance : list) {
                LivingEntity living;
                Entity entity = this.m_19749_();
                LivingEntity livingEntity = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
                brewEffectInstance.getEffect().applyBlockEffect(this.f_19853_, p_37259_.m_82443_().m_20183_(), livingEntity, brewEffectInstance.getDuration(), brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemstack));
            }
        }
    }

    protected void m_6532_(HitResult p_37543_) {
        super.m_6532_(p_37543_);
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            ItemStack itemstack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List list = PotionUtils.m_43547_((ItemStack)itemstack);
            List<BrewEffectInstance> list1 = BrewUtils.getBrewEffects(itemstack);
            boolean bl = flag = potion == Potions.f_43599_ && list.isEmpty();
            if (flag) {
                this.applyWater();
            } else if (!list.isEmpty() || !list1.isEmpty()) {
                if (this.isGas()) {
                    this.makeBrewGas(itemstack, p_37543_);
                } else if (this.isLingering()) {
                    this.makeAreaOfEffectCloud(itemstack);
                } else {
                    this.applySplash(list, list1, p_37543_.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)p_37543_).m_82443_() : null);
                }
            }
            ModNetwork.sendToALL(new SAddBrewParticlesPacket(itemstack, this.m_20183_(), potion.m_43491_(), BrewUtils.getColor(itemstack)));
            this.m_146870_();
        }
    }

    private void applyWater() {
        ItemStack itemstack = this.m_7846_();
        int area = BrewUtils.getAreaOfEffect(itemstack) + 4;
        int areaSqr = Mth.m_144944_((int)area);
        AABB aabb = this.m_20191_().m_82377_((double)area, (double)area / 2.0, (double)area);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, WATER_SENSITIVE);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = this.m_20280_((Entity)livingentity);
                if (!(d0 < (double)areaSqr) || !livingentity.m_6126_()) continue;
                livingentity.m_6469_(this.m_269291_().m_269104_((Entity)this, this.m_19749_()), 1.0f);
            }
        }
        for (Axolotl axolotl : this.f_19853_.m_45976_(Axolotl.class, aabb)) {
            axolotl.m_149177_();
        }
    }

    private void applySplash(List<MobEffectInstance> mobEffectInstances, List<BrewEffectInstance> brewEffectInstances, @Nullable Entity hitEntity) {
        ItemStack itemstack = this.m_7846_();
        int area = BrewUtils.getAreaOfEffect(itemstack) + 4;
        int areaSqr = Mth.m_144944_((int)area);
        AABB aabb = this.m_20191_().m_82377_((double)area, (double)area / 2.0, (double)area);
        List list = this.f_19853_.m_45976_(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            Entity entity = this.m_150173_();
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.m_5801_() || !((d0 = this.m_20280_((Entity)livingentity)) < (double)areaSqr)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / (double)areaSqr;
                if (livingentity == hitEntity) {
                    d1 = 1.0;
                }
                if (!mobEffectInstances.isEmpty()) {
                    for (MobEffectInstance mobeffectinstance : mobEffectInstances) {
                        MobEffect mobeffect = mobeffectinstance.m_19544_();
                        if (mobeffect.m_8093_()) {
                            mobeffect.m_19461_((Entity)this, this.m_19749_(), livingentity, mobeffectinstance.m_19564_(), d1);
                            continue;
                        }
                        int i = (int)(d1 * (double)mobeffectinstance.m_19557_() + 0.5);
                        if (i <= 20) continue;
                        livingentity.m_147207_(new MobEffectInstance(mobeffect, i, mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
                    }
                }
                if (brewEffectInstances.isEmpty()) continue;
                for (BrewEffectInstance brewEffectInstance : brewEffectInstances) {
                    BrewEffect brewEffect = brewEffectInstance.getEffect();
                    if (!brewEffect.isInstantenous()) continue;
                    brewEffect.applyInstantenousEffect((Entity)this, this.m_19749_(), livingentity, brewEffectInstance.getAmplifier(), d1);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(ItemStack p_37538_) {
        ItemStack itemstack = this.m_7846_();
        int h = BrewUtils.getAreaOfEffect(itemstack);
        float i = BrewUtils.getLingering(itemstack);
        BrewEffectCloud brewEffectCloud = new BrewEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            brewEffectCloud.setOwner((LivingEntity)entity);
        }
        brewEffectCloud.setRadius(3.0f + (float)h);
        if ((double)i < 0.3) {
            brewEffectCloud.setRadiusOnUse(-(0.5f - Mth.m_14207_((float)i)));
        }
        brewEffectCloud.setWaitTime(10);
        brewEffectCloud.setRadiusPerTick(-brewEffectCloud.getRadius() / (float)brewEffectCloud.getDuration());
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43571_((ItemStack)p_37538_)) {
            brewEffectCloud.addEffect(new MobEffectInstance(mobeffectinstance));
        }
        for (BrewEffectInstance brewEffectInstance : BrewUtils.getCustomEffects(p_37538_)) {
            if (!brewEffectInstance.getEffect().canLinger()) continue;
            brewEffectCloud.addBrewEffect(new BrewEffectInstance(brewEffectInstance));
        }
        CompoundTag compoundtag = p_37538_.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
            brewEffectCloud.setFixedColor(compoundtag.m_128451_("CustomPotionColor"));
        }
        this.f_19853_.m_7967_((Entity)brewEffectCloud);
    }

    private void makeBrewGas(ItemStack itemStack, HitResult hitResult) {
        ItemStack itemstack = this.m_7846_();
        int h = BrewUtils.getAreaOfEffect(itemstack);
        int i = (int)BrewUtils.getLingering(itemstack);
        BlockPos blockPos = BlockPos.m_274446_((Position)hitResult.m_82450_());
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            blockPos = entityHitResult.m_82443_().m_20183_();
        }
        BrewGas brewGas = new BrewGas(this.f_19853_, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        LivingEntity livingEntity = null;
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity1;
            livingEntity = livingEntity1 = (LivingEntity)entity;
        }
        brewGas.setGas(PotionUtils.m_43571_((ItemStack)itemStack), BrewUtils.getCustomEffects(itemStack), 120 * (i + 1), 3 * (h + 1), livingEntity);
        this.f_19853_.m_7967_((Entity)brewGas);
        if (!this.f_19853_.f_46443_) {
            ModNetwork.sendToALL(new SPlayWorldSoundPacket(blockPos, (SoundEvent)ModSounds.BREW_GAS.get(), 1.0f, this.f_19853_.f_46441_.m_188501_() * 0.1f + 0.9f));
        }
    }

    private boolean isLingering() {
        return this.m_7846_().m_150930_((Item)ModItems.LINGERING_BREW.get());
    }

    private boolean isGas() {
        return this.m_7846_().m_150930_((Item)ModItems.GAS_BREW.get());
    }

    private void dowseFire(BlockPos p_150193_) {
        BlockState blockstate = this.f_19853_.m_8055_(p_150193_);
        if (blockstate.m_204336_(BlockTags.f_13076_)) {
            this.f_19853_.m_7471_(p_150193_, false);
        } else if (AbstractCandleBlock.m_151933_((BlockState)blockstate)) {
            AbstractCandleBlock.m_151899_((Player)null, (BlockState)blockstate, (LevelAccessor)this.f_19853_, (BlockPos)p_150193_);
        } else if (CampfireBlock.m_51319_((BlockState)blockstate)) {
            this.f_19853_.m_5898_((Player)null, 1009, p_150193_, 0);
            CampfireBlock.m_152749_((Entity)this.m_19749_(), (LevelAccessor)this.f_19853_, (BlockPos)p_150193_, (BlockState)blockstate);
            this.f_19853_.m_46597_(p_150193_, (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }
}

