/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SlashProjectile;
import com.Polarice3.Goety.utils.MathHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class VoidSlash
extends SlashProjectile {
    public VoidSlash(EntityType<? extends SlashProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public VoidSlash(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends SlashProjectile>)((EntityType)ModEntityType.VOID_SLASH.get()), levelIn, shooter);
    }

    @Override
    public void spawnParticles() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float width = (float)this.m_20191_().m_82362_();
            float step = 0.25f;
            float radians = (float)Math.PI / 180 * this.m_146908_();
            float speed = 0.1f;
            int i = 0;
            while ((float)i < width / step) {
                double x = this.m_20185_();
                double y = this.m_20186_();
                double z = this.m_20189_();
                double offset = step * ((float)i - width / step / 2.0f);
                double rotX = offset * Math.cos(radians);
                double rotZ = -offset * Math.sin(radians);
                double dx = Math.random() * (double)speed * 2.0 - (double)speed;
                double dy = Math.random() * (double)speed * 2.0 - (double)speed;
                double dz = Math.random() * (double)speed * 2.0 - (double)speed;
                serverLevel.m_8767_((ParticleOptions)new MagicSmokeParticle.Option(0xFF55FF, 0xAA00AA, 10, 0.35f), x + rotX + dx, y + dy, z + rotZ + dz, 0, dx, dy, dz, 1.0);
                ++i;
            }
        }
    }

    @Override
    public void damageEntity(Entity entity) {
        LivingEntity livingEntity;
        DamageSource damageSource = entity.m_269291_().m_269425_();
        Entity entity2 = this.m_19749_();
        if (entity2 instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity2;
            damageSource = entity.m_269291_().m_269333_(livingEntity);
        }
        if (entity.m_6469_(damageSource, this.getDamage()) && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get())) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), 2, false, true));
        }
    }
}

