/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ally.AnimalSummon;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ServantSpawnEggItem
extends ForgeSpawnEggItem {
    public ServantSpawnEggItem(RegistryObject<? extends EntityType<? extends Mob>> entityTypeSupplier, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super((Supplier)Lazy.of(entityTypeSupplier), primaryColorIn, secondaryColorIn, builder);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext p_43223_) {
        BlockEntity blockentity;
        Level level = p_43223_.m_43725_();
        Player player = p_43223_.m_43723_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack itemstack = p_43223_.m_43722_();
        BlockPos blockpos = p_43223_.m_8083_();
        Direction direction = p_43223_.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50085_) && (blockentity = level.m_7702_(blockpos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerblockentity = (SpawnerBlockEntity)blockentity;
            EntityType entitytype1 = this.m_43228_(itemstack.m_41783_());
            spawnerblockentity.m_252803_(entitytype1, level.m_213780_());
            blockentity.m_6596_();
            level.m_7260_(blockpos, blockstate, blockstate, 3);
            level.m_142346_((Entity)p_43223_.m_43723_(), GameEvent.f_157792_, blockpos);
            itemstack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType entitytype = this.m_43228_(itemstack.m_41783_());
        Entity entity = entitytype.m_20592_(serverLevel, itemstack, p_43223_.m_43723_(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (entity != null) {
            IOwned owned;
            if (player != null && entity instanceof IOwned && !(owned = (IOwned)entity).isHostile() && player.m_6047_()) {
                owned.setTrueOwner((LivingEntity)player);
                if (owned instanceof Mob) {
                    Mob mob = (Mob)owned;
                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(mob.m_20183_()), (MobSpawnType)MobSpawnType.SPAWN_EGG, null, (CompoundTag)itemstack.m_41783_());
                }
            }
            itemstack.m_41774_(1);
            level.m_142346_((Entity)p_43223_.m_43723_(), GameEvent.f_157810_, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level p_43225_, Player p_43226_, @NotNull InteractionHand p_43227_) {
        ItemStack itemstack = p_43226_.m_21120_(p_43227_);
        BlockHitResult blockhitresult = ServantSpawnEggItem.m_41435_((Level)p_43225_, (Player)p_43226_, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(p_43225_ instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        ServerLevel serverLevel = (ServerLevel)p_43225_;
        BlockPos blockpos = blockhitresult.m_82425_();
        if (!(p_43225_.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (p_43225_.m_7966_(p_43226_, blockpos) && p_43226_.m_36204_(blockpos, blockhitresult.m_82434_(), itemstack)) {
            IOwned owned;
            EntityType entitytype = this.m_43228_(itemstack.m_41783_());
            Entity entity = entitytype.m_20592_(serverLevel, itemstack, p_43226_, blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            if (entity instanceof IOwned && !(owned = (IOwned)entity).isHostile() && p_43226_.m_6047_()) {
                owned.setTrueOwner((LivingEntity)p_43226_);
                if (owned instanceof Mob) {
                    Mob mob = (Mob)owned;
                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.m_6436_(mob.m_20183_()), (MobSpawnType)MobSpawnType.SPAWN_EGG, null, (CompoundTag)itemstack.m_41783_());
                }
            }
            if (!p_43226_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            p_43226_.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            p_43225_.m_220400_((Entity)p_43226_, GameEvent.f_157810_, entity.m_20182_());
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    @NotNull
    public Optional<Mob> m_43215_(@NotNull Player player, @NotNull Mob targetMob, @NotNull EntityType<? extends Mob> entityType, @NotNull ServerLevel serverLevel, @NotNull Vec3 vec3, ItemStack itemStack) {
        IOwned owned1;
        IOwned owned;
        Object mob;
        if (!this.m_43230_(itemStack.m_41783_(), entityType)) {
            return Optional.empty();
        }
        if (targetMob instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)targetMob;
            mob = ageableMob.m_142606_(serverLevel, ageableMob);
        } else if (targetMob instanceof AnimalSummon) {
            AnimalSummon animalSummon = (AnimalSummon)targetMob;
            mob = animalSummon.getBreedOffspring(serverLevel, animalSummon);
        } else if (targetMob instanceof AbstractIllagerServant) {
            AbstractIllagerServant illager = (AbstractIllagerServant)targetMob;
            mob = illager.getBreedOffspring(serverLevel, illager);
        } else {
            mob = (Mob)entityType.m_20615_((Level)serverLevel);
        }
        if (mob == null) {
            return Optional.empty();
        }
        mob.m_6863_(true);
        if (!mob.m_6162_()) {
            return Optional.empty();
        }
        if (mob instanceof IOwned && !(owned = (IOwned)mob).isHostile() && targetMob instanceof IOwned && !(owned1 = (IOwned)targetMob).isHostile() && owned1.getTrueOwner() != null) {
            owned.setTrueOwner(owned1.getTrueOwner());
        }
        mob.m_7678_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0.0f, 0.0f);
        serverLevel.m_47205_((Entity)mob);
        if (itemStack.m_41788_()) {
            mob.m_6593_(itemStack.m_41786_());
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return Optional.of(mob);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        MutableComponent textComponent = Component.m_237115_((String)"tooltip.goety.servant.spawn_egg").m_130940_(ChatFormatting.GOLD);
        tooltip.add((Component)textComponent);
    }
}

