/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.utils.EntityFinder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TaglockKit
extends Item {
    public static final String TAG_ENTITY = "Tagged";
    public static final String TAG_PLAYER_NAME = "TaggedPlayerName";

    public TaglockKit() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).setNoRepair());
    }

    public void m_6883_(@NotNull ItemStack stack, Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.f_46443_ && stack.m_41783_() != null) {
            LivingEntity livingEntity = TaglockKit.getEntity(stack.m_41783_());
            if (livingEntity != null && livingEntity.m_21224_()) {
                stack.m_41783_().m_128473_(TAG_ENTITY);
                stack.m_41783_().m_128473_(TAG_PLAYER_NAME);
            } else if (livingEntity == null && !stack.m_41783_().m_128441_(TAG_PLAYER_NAME)) {
                stack.m_41783_().m_128473_(TAG_ENTITY);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean m_5812_(@NotNull ItemStack p_41453_) {
        return TaglockKit.hasEntity(p_41453_);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (stack.m_41720_() instanceof TaglockKit && !TaglockKit.hasEntity(stack)) {
                Player player1;
                if (entity instanceof Player && !this.sneakATag(player, (LivingEntity)(player1 = (Player)entity))) {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.taglock.failed").m_130940_(ChatFormatting.RED), true);
                    player1.m_5661_((Component)Component.m_237115_((String)"info.goety.taglock.discover").m_130940_(ChatFormatting.GOLD), true);
                    player.f_19853_.m_6269_(player, (Entity)player, (SoundEvent)SoundEvents.f_12217_.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    CompoundTag compoundTag = new CompoundTag();
                    if (stack.m_41782_()) {
                        compoundTag = stack.m_41783_();
                    }
                    TaglockKit.setEntity(compoundTag, target);
                    stack.m_41751_(compoundTag);
                    ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                }
                return true;
            }
        }
        return !TaglockKit.hasEntity(stack);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        ItemStack stack = pContext.m_43722_();
        BlockState blockState = level.m_8055_(blockpos);
        if (player != null && !blockState.m_60795_()) {
            this.taglockFromBed(player, stack, level, blockpos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(pContext);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() || player.m_6047_()) {
            if (itemstack.m_41720_() instanceof TaglockKit && itemstack.m_41783_() != null) {
                if (TaglockKit.hasEntity(itemstack)) {
                    itemstack.m_41783_().m_128473_(TAG_ENTITY);
                }
                if (TaglockKit.hasPlayerName(itemstack)) {
                    itemstack.m_41783_().m_128473_(TAG_PLAYER_NAME);
                }
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private void taglockFromBed(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            String boundName = "";
            LivingEntity boundEntity = TaglockKit.getEntity(stack);
            if (boundEntity instanceof Player) {
                Player player1 = (Player)boundEntity;
                boundName = player1.m_6302_();
            }
            ArrayList<Player> players = new ArrayList<Player>();
            for (Player found : level.m_6907_()) {
                ServerPlayer serverPlayer;
                BlockPos respawn;
                if (!(found instanceof ServerPlayer) || (respawn = (serverPlayer = (ServerPlayer)found).m_8961_()) == null || !respawn.equals((Object)blockPos)) continue;
                players.add(found);
            }
            Comparator<Player> comparator = Comparator.comparing(Player::m_6302_);
            players.sort(comparator);
            if (players.size() > 0) {
                if (boundName.isEmpty()) {
                    TaglockKit.setNewTaglock(player, stack, (LivingEntity)players.get(0));
                } else {
                    boolean bind = false;
                    for (int i = 0; i < players.size() && !bind; ++i) {
                        if (!((Player)players.get(i)).m_6302_().equals(boundName)) continue;
                        if (i == players.size() - 1) {
                            TaglockKit.setNewTaglock(player, stack, (LivingEntity)players.get(0));
                        } else {
                            TaglockKit.setNewTaglock(player, stack, (LivingEntity)players.get(i + 1));
                        }
                        bind = true;
                    }
                    if (!bind) {
                        TaglockKit.setNewTaglock(player, stack, (LivingEntity)players.get(0));
                    }
                }
            }
        }
    }

    public static boolean hasEntity(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && stack.m_41783_().m_128441_(TAG_ENTITY);
    }

    public static boolean hasPlayerName(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && stack.m_41783_().m_128441_(TAG_PLAYER_NAME);
    }

    public static void removeEntity(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (TaglockKit.hasEntity(stack) && compoundtag != null) {
            compoundtag.m_128473_(TAG_ENTITY);
        }
    }

    public static void setNewTaglock(Player player, ItemStack itemStack, LivingEntity livingEntity) {
        if (livingEntity != null) {
            CompoundTag compoundTag = new CompoundTag();
            if (itemStack.m_41782_()) {
                compoundTag = itemStack.m_41783_();
            }
            TaglockKit.setEntity(compoundTag, livingEntity);
            itemStack.m_41751_(compoundTag);
            player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
            ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
        }
    }

    public static void setEntity(CompoundTag compoundTag, LivingEntity livingEntity) {
        if (compoundTag != null && livingEntity != null) {
            compoundTag.m_128362_(TAG_ENTITY, livingEntity.m_20148_());
            if (livingEntity instanceof Player) {
                Player player1 = (Player)livingEntity;
                compoundTag.m_128359_(TAG_PLAYER_NAME, player1.m_5446_().getString());
            }
        }
    }

    public static void setEntity(ItemStack itemStack, LivingEntity livingEntity) {
        if (livingEntity != null) {
            CompoundTag compoundTag = new CompoundTag();
            if (itemStack.m_41782_()) {
                compoundTag = itemStack.m_41783_();
            }
            TaglockKit.setEntity(compoundTag, livingEntity);
            itemStack.m_41751_(compoundTag);
        }
    }

    public static boolean isSameDimension(LivingEntity livingEntity, ItemStack stack) {
        LivingEntity tagged = TaglockKit.getEntity(stack);
        return tagged != null && tagged.f_19853_.m_46472_() == livingEntity.f_19853_.m_46472_();
    }

    public static boolean isInRange(Vec3 origin, ItemStack stack, int increase) {
        LivingEntity tagged = TaglockKit.getEntity(stack);
        if (tagged != null) {
            double scale = 6.0 * (double)((float)increase + 1.0f);
            double trueRange = Mth.m_144952_((double)scale) * 2.0;
            return tagged.m_20238_(origin) <= Mth.m_144952_((double)trueRange);
        }
        return false;
    }

    public static boolean canAffect(LivingEntity livingEntity, ItemStack stack, Vec3 origin, int increase) {
        return stack.m_41720_() instanceof TaglockKit && TaglockKit.hasEntity(stack) && TaglockKit.isSameDimension(livingEntity, stack) && TaglockKit.isInRange(origin, stack, increase);
    }

    public static LivingEntity getEntity(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            return TaglockKit.getEntity(compoundtag);
        }
        return null;
    }

    public static LivingEntity getEntity(CompoundTag compoundTag) {
        boolean flag = compoundTag.m_128441_(TAG_ENTITY);
        if (flag) {
            UUID uuid = compoundTag.m_128342_(TAG_ENTITY);
            return EntityFinder.getLivingEntityByUuiD(uuid);
        }
        return null;
    }

    private boolean sneakATag(Player source, LivingEntity target) {
        double chance;
        double targetFacing;
        if (TaglockKit.isNotAllowed(source, target)) {
            return false;
        }
        double sourceFacing = (source.m_6080_() + 90.0f) % 360.0f;
        if (sourceFacing < 0.0) {
            sourceFacing += 360.0;
        }
        if ((targetFacing = (double)((target.m_6080_() + 90.0f) % 360.0f)) < 0.0) {
            targetFacing += 360.0;
        }
        double arc = 45.0;
        double diff = Math.abs(targetFacing - sourceFacing);
        if ((360.0 - diff) % 360.0 >= arc && diff % 360.0 >= arc) {
            chance = source.m_6047_() ? 0.1 : 0.01;
        } else {
            double d = chance = source.m_6047_() ? 0.6 : 0.3;
        }
        if (source.m_20145_()) {
            chance += 0.1;
        }
        return source.m_217043_().m_188500_() < chance;
    }

    public static boolean isNotAllowed(Player collector, LivingEntity target) {
        if (target instanceof Player && collector != target && collector.f_19853_.m_7654_() != null) {
            if (!collector.f_19853_.m_7654_().m_129799_()) {
                return true;
            }
            Player targetPlayer = (Player)target;
            return targetPlayer.m_36337_();
        }
        return false;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        TaglockKit.addTaggedText(stack, tooltip);
    }

    public static void addTaggedText(ItemStack stack, List<Component> tooltip) {
        if (stack.m_41783_() != null) {
            if (TaglockKit.hasEntity(stack)) {
                LivingEntity livingEntity = TaglockKit.getEntity(stack.m_41783_());
                if (livingEntity != null) {
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.taglock.tagged").m_130946_(" ").m_7220_(livingEntity.m_7770_() != null ? livingEntity.m_7770_() : livingEntity.m_5446_()).m_130940_(ChatFormatting.GRAY));
                } else if (TaglockKit.hasPlayerName(stack)) {
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.taglock.tagged").m_130946_(" ").m_130946_(stack.m_41783_().m_128461_(TAG_PLAYER_NAME)).m_130940_(ChatFormatting.GRAY));
                }
            } else if (TaglockKit.hasPlayerName(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"info.goety.taglock.tagged").m_130946_(" ").m_130946_(stack.m_41783_().m_128461_(TAG_PLAYER_NAME)).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

