/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.events.ArcaTeleporter;
import com.Polarice3.Goety.common.items.magic.MagicFocus;
import com.Polarice3.Goety.common.magic.spells.void_spells.TroopSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class TroopFocus
extends MagicFocus {
    public static final String TAG_ENTITY_TYPE = "Summon Type";

    public TroopFocus() {
        super(new TroopSpell());
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity) {
            IOwned owned;
            LivingEntity target = (LivingEntity)entity;
            if (stack.m_41720_() instanceof TroopFocus && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == player) {
                CompoundTag compoundTag = new CompoundTag();
                if (stack.m_41782_()) {
                    compoundTag = stack.m_41783_();
                }
                if (!TroopFocus.hasSummonType(stack)) {
                    TroopFocus.setSummonType(compoundTag, target.m_6095_());
                    stack.m_41751_(compoundTag);
                    player.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
                    ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_11686_, 1.0f, 0.45f));
                }
            }
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() || player.m_6047_()) {
            if (itemstack.m_41720_() instanceof TroopFocus && itemstack.m_41783_() != null && TroopFocus.hasSummonType(itemstack)) {
                itemstack.m_41783_().m_128473_(TAG_ENTITY_TYPE);
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static void call(ServerPlayer player, ItemStack stack) {
        if (stack.m_41783_() != null) {
            CompoundTag compoundTag = stack.m_41783_();
            Level level = player.f_19853_;
            if (level instanceof ServerLevel) {
                EntityType<?> entityType;
                ServerLevel serverLevel = (ServerLevel)level;
                ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
                if (TroopFocus.hasSummonType(stack) && (entityType = TroopFocus.getSummonType(compoundTag)) != null) {
                    for (Entity entity : serverLevel.m_8583_()) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity1 = (LivingEntity)entity;
                        if (entity.m_6095_() != entityType || MobUtil.getOwner((Entity)livingEntity1) == null || MobUtil.getOwner((Entity)livingEntity1) != player || SEHelper.getGroundedEntities((Player)player).contains(livingEntity1)) continue;
                        list.add(livingEntity1);
                    }
                }
                if (!list.isEmpty()) {
                    for (LivingEntity livingEntity1 : list) {
                        IServant servant;
                        ServerLevel serverWorld;
                        Entity entity;
                        LivingEntity original = null;
                        if (livingEntity1.m_20159_() && (entity = livingEntity1.m_20202_()) instanceof LivingEntity) {
                            LivingEntity vehicle = (LivingEntity)entity;
                            original = livingEntity1;
                            livingEntity1 = vehicle;
                        }
                        if (livingEntity1.m_21224_()) continue;
                        BlockPos blockPos = BlockFinder.SummonRadius(player.m_20183_(), (Entity)livingEntity1, (Level)serverLevel);
                        if ((player.m_6144_() || player.m_6047_()) && list.size() == 1) {
                            blockPos = player.m_20183_();
                        }
                        if (livingEntity1.f_19853_.m_46472_() == player.f_19853_.m_46472_()) {
                            IServant servant2;
                            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)livingEntity1, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                            if (event.isCanceled()) break;
                            livingEntity1.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                            MobUtil.moveDownToGround((Entity)livingEntity1);
                            ModNetwork.sendToALL(new SPlayWorldSoundPacket(player.m_20183_(), SoundEvents.f_11852_, 1.0f, 1.0f));
                            ModNetwork.sendToALL(new SPlayWorldSoundPacket(blockPos, SoundEvents.f_11852_, 1.0f, 1.0f));
                            if (original instanceof IServant) {
                                servant2 = (IServant)original;
                                servant2.setFollowing();
                            }
                            if (!(livingEntity1 instanceof IServant)) continue;
                            servant2 = (IServant)livingEntity1;
                            servant2.setFollowing();
                            continue;
                        }
                        if (player.m_20194_() == null || (serverWorld = player.m_20194_().m_129880_(player.f_19853_.m_46472_())) == null) continue;
                        Vec3 vec3 = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)livingEntity1, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                        if (event.isCanceled()) break;
                        livingEntity1.changeDimension(serverWorld, (ITeleporter)new ArcaTeleporter(vec3));
                        livingEntity1.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                        MobUtil.moveDownToGround((Entity)livingEntity1);
                        ModNetwork.sendToALL(new SPlayWorldSoundPacket(player.m_20183_(), SoundEvents.f_11852_, 1.0f, 1.0f));
                        if (original instanceof IServant) {
                            servant = (IServant)original;
                            servant.setFollowing();
                        }
                        if (!(livingEntity1 instanceof IServant)) continue;
                        servant = (IServant)livingEntity1;
                        servant.setFollowing();
                    }
                }
            }
        }
    }

    public static boolean hasSummonType(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && stack.m_41783_().m_128441_(TAG_ENTITY_TYPE);
    }

    public static void setSummonType(CompoundTag compoundTag, EntityType<?> entityType) {
        ResourceLocation name;
        if (compoundTag != null && entityType != null && (name = ForgeRegistries.ENTITY_TYPES.getKey(entityType)) != null) {
            compoundTag.m_128359_(TAG_ENTITY_TYPE, name.toString());
        }
    }

    public static EntityType<?> getSummonType(ItemStack stack) {
        boolean flag;
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null && (flag = compoundTag.m_128441_(TAG_ENTITY_TYPE))) {
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(compoundTag.m_128461_(TAG_ENTITY_TYPE)));
        }
        return null;
    }

    public static EntityType<?> getSummonType(CompoundTag compoundTag) {
        boolean flag = compoundTag.m_128441_(TAG_ENTITY_TYPE);
        if (flag) {
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(compoundTag.m_128461_(TAG_ENTITY_TYPE)));
        }
        return null;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        TroopFocus.addCallText(stack, tooltip);
    }

    public static void addCallText(ItemStack stack, List<Component> tooltip) {
        if (stack.m_41783_() != null) {
            if (!TroopFocus.hasSummonType(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.noSummonType"));
            } else {
                EntityType<?> entityType = TroopFocus.getSummonType(stack.m_41783_());
                if (entityType != null) {
                    tooltip.add((Component)Component.m_237115_((String)"info.goety.focus.summonType").m_130946_(" ").m_7220_(entityType.m_20676_()).m_130940_(ChatFormatting.DARK_GREEN));
                }
            }
        }
    }
}

