/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.listeners;

import com.Polarice3.Goety.Goety;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class SoulTakenListener
extends SimpleJsonResourceReloadListener {
    public static Map<ResourceLocation, SoulTakenDataType> ENTITY_LIST = new HashMap<ResourceLocation, SoulTakenDataType>();
    private static final Gson GSON = new GsonBuilder().create();
    private final ICondition.IContext context;

    public SoulTakenListener(ICondition.IContext context) {
        super(GSON, "soul_taken");
        this.context = context;
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ENTITY_LIST.clear();
        for (int i = 0; i < objectIn.size(); ++i) {
            ResourceLocation location = (ResourceLocation)objectIn.keySet().toArray()[i];
            JsonObject object = objectIn.get(location).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)object, (String)"conditions", (ICondition.IContext)this.context)) {
                Goety.LOGGER.debug("Skipping loading soul taken entry {} as it's conditions were not met", (Object)location);
                continue;
            }
            ResourceLocation entityType = null;
            ResourceLocation entityTag = null;
            if (object.has("entity_type")) {
                entityType = new ResourceLocation(object.getAsJsonPrimitive("entity_type").getAsString());
            } else if (object.has("tag")) {
                entityTag = new ResourceLocation(object.getAsJsonPrimitive("tag").getAsString());
            }
            int soulAmount = object.getAsJsonPrimitive("soul_amount").getAsInt();
            ENTITY_LIST.put(location, new SoulTakenDataType(entityType, entityTag, soulAmount));
        }
    }

    public static int getSoulAmount(LivingEntity victim) {
        if (victim != null && !ENTITY_LIST.isEmpty()) {
            for (SoulTakenDataType dataType : ENTITY_LIST.values()) {
                boolean flag = false;
                if (dataType.entityType != null) {
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(dataType.entityType);
                    if (entityType != null && entityType != EntityType.f_20510_) {
                        flag = victim.m_6095_() == entityType;
                    }
                } else if (dataType.entityTag != null) {
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)dataType.entityTag);
                    flag = victim.m_6095_().m_204039_(tagKey);
                }
                if (!flag) continue;
                return dataType.soulAmount;
            }
        }
        return 0;
    }

    public static class SoulTakenDataType {
        @Nullable
        public ResourceLocation entityType;
        @Nullable
        public ResourceLocation entityTag;
        public int soulAmount;

        public SoulTakenDataType(@Nullable ResourceLocation entityType, @Nullable ResourceLocation entityTag, int soulAmount) {
            this.entityType = entityType;
            this.entityTag = entityTag;
            this.soulAmount = soulAmount;
        }
    }
}

