/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic;

import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.api.magic.ISpell;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.FoggyCloudParticleOption;
import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class Spell
implements ISpell {
    @Override
    public abstract int defaultSoulCost();

    @Override
    public abstract int defaultCastDuration();

    @Override
    public abstract int defaultSpellCooldown();

    public void mobSpellResult(LivingEntity caster, ItemStack staff) {
        this.mobSpellResult(caster, staff, WandUtil.getStats(caster, this));
    }

    public void mobSpellResult(LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.serverCheckSpellResult(caster.f_19853_, caster, staff, spellStat);
    }

    public void serverCheckSpellResult(Level level, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.SpellResult(serverLevel, caster, staff, spellStat);
        }
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NONE;
    }

    public boolean GeoPower(LivingEntity caster) {
        return CuriosFinder.hasCurio(caster, (Item)ModItems.AMETHYST_NECKLACE.get());
    }

    public boolean isShifting(LivingEntity caster) {
        return (caster.m_6047_() || caster.m_6144_()) && !WandUtil.findWand(caster).m_41619_();
    }

    public boolean conditionsMet(Level worldIn, LivingEntity caster) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            return this.conditionsMet(serverLevel, caster);
        }
        return false;
    }

    @Override
    @Nullable
    public LivingEntity getTarget(LivingEntity caster) {
        int range = this.defaultStats().getRange();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        return this.getTarget(caster, range);
    }

    @Nullable
    public LivingEntity getTarget(LivingEntity caster, int range) {
        if (caster instanceof Mob) {
            Mob mob = (Mob)caster;
            return mob.m_5448_();
        }
        HitResult hitResult = this.rayTrace(caster.f_19853_, caster, range, 3.0);
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return MobUtil.getLivingTarget(entityHitResult.m_82443_());
        }
        return null;
    }

    public boolean rightStaff(ItemStack staff) {
        IWand darkWand;
        Item item = staff.m_41720_();
        return item instanceof IWand && (darkWand = (IWand)item).getSpellType() == this.getSpellType();
    }

    public boolean typeStaff(ItemStack staff, SpellType spellType) {
        IWand darkWand;
        Item item = staff.m_41720_();
        return item instanceof IWand && (darkWand = (IWand)item).getSpellType() == spellType;
    }

    @Override
    public void useParticle(Level worldIn, LivingEntity caster, ItemStack stack) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            if (this.getSpellType() == SpellType.FROST) {
                if (caster.f_19797_ % 5 == 0) {
                    ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_175821_, (Entity)caster);
                }
            } else if (this.getSpellType() == SpellType.GEOMANCY) {
                BlockPos blockPos = BlockPos.m_274561_((double)caster.m_20185_(), (double)(caster.m_20186_() - 1.0), (double)caster.m_20189_());
                BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_(blockPos));
                for (int i = 0; i < 8; ++i) {
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, caster.m_20185_(), caster.m_20186_() + 0.25, caster.m_20189_(), 1.0f);
                }
            } else if (this.getSpellType() == SpellType.WIND) {
                if (caster.f_19797_ % 5 == 0) {
                    ColorUtil colorUtil = new ColorUtil(4557960);
                    ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, caster.m_20182_().m_82520_(0.0, 1.0, 0.0)), (Entity)caster, serverLevel, 1);
                }
            } else if (this.getSpellType() == SpellType.STORM) {
                if (caster.f_19797_ % 5 == 0) {
                    ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ModParticleTypes.SPELL_ELECTRIC.get(), (Entity)caster);
                }
            } else if (this.getSpellType() == SpellType.WILD) {
                ColorUtil colorUtil = new ColorUtil(16570871);
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SPELL_SQUARE.get()), caster.m_20185_(), caster.m_20186_() + 2.0, caster.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 0.5);
                serverLevel.m_8767_((ParticleOptions)new FoggyCloudParticleOption(new ColorUtil(13596079), 0.25f, 6), caster.m_20185_(), caster.m_20186_() + 1.5, caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            } else if (this.getSpellType() == SpellType.ABYSS) {
                int range = 1;
                ColorUtil colorUtil = new ColorUtil(ChatFormatting.AQUA);
                ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, caster.m_20182_().m_82520_(0.0, 2.0, 0.0)), (Entity)caster, serverLevel, range);
            } else if (this.getSpellType() == SpellType.VOID) {
                int range = 1;
                ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
                ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, caster.m_20182_().m_82520_(0.0, 2.0, 0.0)), (Entity)caster, serverLevel, range);
                for (int i = 0; i < 2; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, caster.m_20208_(0.5), caster.m_20187_() - 0.25, caster.m_20262_(0.5), 0, (worldIn.m_213780_().m_188500_() - 0.5) * 2.0, -worldIn.m_213780_().m_188500_(), (worldIn.m_213780_().m_188500_() - 0.5) * 2.0, 1.0);
                }
            } else if (this.getSpellType() == SpellType.NETHER) {
                int range = 1;
                ColorUtil colorUtil = new ColorUtil(ChatFormatting.GOLD);
                ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, caster.m_20182_().m_82520_(0.0, 2.0, 0.0)), (Entity)caster, serverLevel, range);
            } else if (this.getSpellType() == SpellType.NECROMANCY) {
                int range = 1;
                ColorUtil colorUtil = new ColorUtil(0xFFFFFF);
                if (stack.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
                    range = 3;
                    colorUtil = new ColorUtil(11009086);
                }
                ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, caster.m_20182_().m_82520_(0.0, 2.0, 0.0)), (Entity)caster, serverLevel, range);
            } else {
                ISpell.super.useParticle(worldIn, caster, stack);
            }
        }
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        return new ArrayList<Enchantment>();
    }

    protected HitResult rayTraceCollide(Level worldIn, LivingEntity caster, int range, double radius) {
        if (this.entityCollideResult(worldIn, caster, range, radius) == null) {
            return this.blockResult(worldIn, caster, range);
        }
        return this.entityCollideResult(worldIn, caster, range, radius);
    }

    protected EntityHitResult entityCollideResult(Level worldIn, LivingEntity caster, int range, double radius) {
        Vec3 srcVec = caster.m_20299_(1.0f);
        Vec3 lookVec = caster.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range);
        AABB axisalignedbb = caster.m_20191_().m_82369_(lookVec.m_82490_((double)range)).m_82377_(radius, radius, radius);
        return ProjectileUtil.m_37304_((Level)worldIn, (Entity)caster, (Vec3)srcVec, (Vec3)destVec, (AABB)axisalignedbb, entity -> entity instanceof LivingEntity && caster.m_142582_(entity) && !entity.m_5833_() && entity.m_6087_());
    }

    public SoundSource getSoundSource() {
        return SoundSource.PLAYERS;
    }

    public float projPitch(RandomSource source) {
        return (source.m_188501_() - source.m_188501_()) * 0.2f + 1.0f;
    }

    public void playSound(ServerLevel serverLevel, Entity entity, SoundEvent soundEvent) {
        this.playSound(serverLevel, entity, soundEvent, 1.0f, 1.0f);
    }

    public void playSound(ServerLevel serverLevel, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, this.getSoundSource(), volume, pitch);
    }

    public void playSound(ServerLevel serverLevel, LivingEntity caster, float volume, float pitch) {
        SoundEvent soundEvent = this.CastingSound(caster);
        if (soundEvent != null) {
            this.playSound(serverLevel, (Entity)caster, soundEvent, volume, pitch);
        }
    }
}

