/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.construct;

import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.golem.IceGolem;
import com.Polarice3.Goety.config.SpellConfig;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class IceGolemMold
implements IMold {
    private static final List<BlockPos> ICE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(1, 0, 0), (Object)new BlockPos(-1, 0, 0));
    private static final List<BlockPos> ICE_LOCATIONS_Z = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(0, 0, -1));
    private static final BlockPos BLUE_ICE = new BlockPos(0, 0, 0);
    private static final BlockPos SNOW = new BlockPos(0, 1, 0);

    private static List<BlockPos> checkIceX(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : ICE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_50354_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkIceZ(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : ICE_LOCATIONS_Z) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_50354_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    public boolean conditionsMet(Level worldIn, LivingEntity entityLiving) {
        int count = 0;
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            for (Entity entity : serverLevel.m_8583_()) {
                IceGolem servant;
                if (!(entity instanceof IceGolem) || (servant = (IceGolem)entity).getTrueOwner() != entityLiving || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count < (Integer)SpellConfig.IceGolemLimit.get();
    }

    public static boolean canSpawn(Level level, BlockPos blockPos) {
        if (IceGolemMold.checkIceX(level, blockPos).isEmpty()) {
            for (BlockPos blockPos1 : ICE_LOCATIONS) {
                BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_50354_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            return level.m_8055_(blockPos.m_121955_((Vec3i)SNOW)).m_60713_(Blocks.f_50127_) && level.m_8055_(blockPos.m_121955_((Vec3i)BLUE_ICE)).m_60713_(Blocks.f_50568_);
        }
        if (IceGolemMold.checkIceZ(level, blockPos).isEmpty()) {
            for (BlockPos blockPos1 : ICE_LOCATIONS_Z) {
                BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_50354_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            return level.m_8055_(blockPos.m_121955_((Vec3i)SNOW)).m_60713_(Blocks.f_50127_) && level.m_8055_(blockPos.m_121955_((Vec3i)BLUE_ICE)).m_60713_(Blocks.f_50568_);
        }
        return false;
    }

    @Override
    public boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_60713_(Blocks.f_50568_)) {
            if (this.conditionsMet(level, (LivingEntity)player)) {
                if (IceGolemMold.canSpawn(level, blockPos)) {
                    IceGolem iceGolem = (IceGolem)((EntityType)ModEntityType.ICE_GOLEM.get()).m_20615_(level);
                    if (iceGolem != null) {
                        iceGolem.setTrueOwner((LivingEntity)player);
                        iceGolem.m_6518_((ServerLevelAccessor)level, level.m_6436_(iceGolem.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                        iceGolem.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_7495_().m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                        if (level.m_7967_((Entity)iceGolem)) {
                            IceGolemMold.removeBlocks(level, blockPos);
                            stack.m_41774_(1);
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)iceGolem);
                            }
                            return true;
                        }
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.block.fail"), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
            }
        }
        return false;
    }

    public static void removeBlocks(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            BlockPos blockPos2;
            BlockPos blockPos1 = blockPos.m_121955_((Vec3i)BLUE_ICE);
            if (level.m_8055_(blockPos1).m_60713_(Blocks.f_50568_)) {
                level.m_46796_(2001, blockPos1, Block.m_49956_((BlockState)level.m_8055_(blockPos1)));
                level.m_46597_(blockPos1, Blocks.f_50016_.m_49966_());
            }
            if (level.m_8055_(blockPos2 = blockPos.m_121955_((Vec3i)SNOW)).m_60713_(Blocks.f_50127_)) {
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

