/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class BulwarkSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BulwarkCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BulwarkDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BulwarkCoolDown.get();
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        return MiscCapHelper.getShields(caster) <= 0;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int amount = (Integer)SpellConfig.BulwarkShieldAmount.get();
        int duration = (Integer)SpellConfig.BulwarkShieldTime.get();
        if (WandUtil.enchantedFocus(caster)) {
            amount += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration *= Math.min(4, WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1);
        }
        amount += spellStat.getPotency();
        if (spellStat.getDuration() > 0) {
            duration = spellStat.getDuration();
        }
        LivingEntity target = this.getTarget(caster);
        if (this.isShifting(caster) && target != null) {
            if (MobUtil.areAllies((Entity)target, (Entity)caster)) {
                MiscCapHelper.setShields(target, amount);
                MiscCapHelper.setShieldTime(target, duration);
            }
        } else {
            MiscCapHelper.setShields(caster, amount);
            MiscCapHelper.setShieldTime(caster, duration);
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SHIELD_UP.get(), 3.0f, caster.m_6100_());
    }
}

