/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ReverseShockwaveParticleOption;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Doppelganger;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SSetPlayerOwnerPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class IllusionSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.IllusionCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.IllusionDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_12054_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.IllusionCoolDown.get();
    }

    @Override
    public ColorUtil particleColors(LivingEntity caster) {
        return new ColorUtil(0.3f, 0.3f, 0.8f);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        for (Entity entity : worldIn.m_8583_()) {
            Doppelganger doppelganger;
            if (!(entity instanceof Doppelganger) || (doppelganger = (Doppelganger)entity).getTrueOwner() != caster || doppelganger.f_19797_ <= 10) continue;
            doppelganger.m_6667_(caster.m_269291_().m_269064_());
        }
        int i0 = 4;
        if (staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
            i0 = 8;
        }
        boolean undead = CuriosFinder.hasNamelessSet(caster) && staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get());
        SimpleParticleType particleOptions = ParticleTypes.f_123759_;
        if (undead) {
            particleOptions = (ParticleOptions)ModParticleTypes.LICH.get();
        }
        for (int i1 = 0; i1 < i0; ++i1) {
            Doppelganger summonedentity = new Doppelganger((EntityType<? extends Doppelganger>)((EntityType)ModEntityType.DOPPELGANGER.get()), (Level)worldIn);
            summonedentity.setTrueOwner(caster);
            if (caster instanceof Player) {
                Player player = (Player)caster;
                ModNetwork.sendTo(player, new SSetPlayerOwnerPacket((Entity)summonedentity));
            }
            Vec3 vec3 = BlockFinder.SummonRadius(caster.m_20183_(), (Entity)summonedentity, (Level)worldIn).m_252807_();
            summonedentity.m_146884_(vec3);
            summonedentity.setUndeadClone(undead);
            summonedentity.setLimitedLife(undead ? MathHelper.secondsToTicks(2.875f) : 1200);
            summonedentity.m_21530_();
            summonedentity.setUpgraded(CuriosFinder.hasIllusionRobe(caster));
            summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(BlockFinder.SummonRadius(caster.m_20183_(), (Entity)summonedentity, (Level)worldIn)), MobSpawnType.MOB_SUMMONED, null, null);
            LivingEntity target = this.getTarget(caster);
            if (target != null) {
                double d2 = target.m_20185_() - summonedentity.m_20185_();
                double d1 = target.m_20189_() - summonedentity.m_20189_();
                summonedentity.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                if (undead) {
                    float f = (float)Mth.m_14136_((double)d1, (double)d2);
                    float f2 = f + (float)i1 * (float)Math.PI * 0.25f + 4.0f;
                    vec3 = new Vec3(target.m_20185_() + (double)Mth.m_14089_((float)f2) * 4.0, target.m_20186_(), target.m_20189_() + (double)Mth.m_14031_((float)f2) * 4.0);
                    summonedentity.m_146884_(vec3);
                }
            }
            MobUtil.moveDownToGround((Entity)summonedentity);
            worldIn.m_7967_((Entity)summonedentity);
            for (int i = 0; i < caster.f_19853_.f_46441_.m_188503_(10) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)particleOptions, summonedentity.m_20185_(), summonedentity.m_20186_(), summonedentity.m_20189_(), (Level)worldIn);
            }
            if (!undead) continue;
            worldIn.m_8767_((ParticleOptions)new ReverseShockwaveParticleOption(new ColorUtil(3597334), 2.0f, 0.5f, 1), summonedentity.m_20185_(), summonedentity.m_20186_() + 0.5, summonedentity.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
        }
        if (CuriosFinder.hasIllusionRobe(caster)) {
            caster.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 1200));
            LivingEntity target = this.getTarget(caster);
            if (target != null) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 400));
            }
        }
        SoundEvent soundEvent = SoundEvents.f_12052_;
        if (undead) {
            soundEvent = (SoundEvent)ModSounds.LICH_TELEPORT_IN.get();
        }
        this.playSound(worldIn, (Entity)caster, soundEvent);
        for (int i = 0; i < caster.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            worldIn.m_8767_((ParticleOptions)particleOptions, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

