/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpikeSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.SpikeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.SpikeDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11868_;
    }

    @Override
    public float castingPitch() {
        return 0.5f;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.SpikeCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ILL;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.BURNING.get());
        if ((Integer)SpellConfig.SpikeGainSouls.get() > 0) {
            list.add((Enchantment)ModEnchantments.SOUL_EATER.get());
        }
        return list;
    }

    @Override
    public ColorUtil particleColors(LivingEntity caster) {
        return new ColorUtil(0.4f, 0.3f, 0.35f);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, radius);
        Vec3 vector3d = rayTraceResult.m_82450_();
        double d0 = Math.min(vector3d.f_82480_, caster.m_20186_());
        double d1 = Math.max(vector3d.f_82480_, caster.m_20186_()) + 1.0;
        float f = (float)Mth.m_14136_((double)(vector3d.f_82481_ - caster.m_20189_()), (double)(vector3d.f_82479_ - caster.m_20185_()));
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            d0 = Math.min(target.m_20186_(), caster.m_20186_());
            d1 = Math.max(target.m_20186_(), caster.m_20186_()) + 1.0;
            f = (float)Mth.m_14136_((double)(target.m_20189_() - caster.m_20189_()), (double)(target.m_20185_() - caster.m_20185_()));
        }
        if (!this.isShifting(caster)) {
            for (int l = 0; l < range; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                WandUtil.spawnSpikes(caster, caster.m_20185_() + (double)Mth.m_14089_((float)f) * d2, caster.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, l);
            }
        } else {
            float f2;
            int k;
            for (int i = 0; i < 5; ++i) {
                float f1 = f + (float)i * (float)Math.PI * 0.4f;
                WandUtil.spawnSpikes(caster, caster.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, caster.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0);
            }
            for (k = 0; k < 8; ++k) {
                f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                WandUtil.spawnSpikes(caster, caster.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, caster.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3);
            }
            if (this.rightStaff(staff)) {
                for (k = 0; k < 11; ++k) {
                    f2 = f + (float)k * (float)Math.PI * 4.0f / 16.0f + 2.5133462f;
                    WandUtil.spawnSpikes(caster, caster.m_20185_() + (double)Mth.m_14089_((float)f2) * 3.5, caster.m_20189_() + (double)Mth.m_14031_((float)f2) * 3.5, d0, d1, f2, 6);
                }
            }
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11862_, 1.0f, 0.5f);
    }
}

