/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells;

import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.EverChargeSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TelekinesisSpell
extends EverChargeSpell {
    public Entity victim = null;

    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setPotency(1);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.TelekinesisCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.TelekinesisChargeUp.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        if (caster.f_20916_ > 0) {
            return false;
        }
        if (this.victim != null) {
            int range = spellStat.getRange();
            if (WandUtil.enchantedFocus(caster)) {
                range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            }
            return !(this.victim.m_20270_((Entity)caster) > (float)range);
        }
        return true;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void stopSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, ItemStack focus, int castTime, SpellStat spellStat) {
        this.victim = null;
        if (caster instanceof Player) {
            Player player = (Player)caster;
            SEHelper.addCooldown(player, focus.m_41720_(), MathHelper.secondsToTicks(5));
            SEHelper.sendSEUpdatePacket(player);
        }
        super.stopSpell(worldIn, caster, staff, focus, castTime, spellStat);
    }

    @Override
    public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        super.startSpell(worldIn, caster, staff, spellStat);
        this.findVictim(worldIn, caster, spellStat);
    }

    public void findVictim(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        double potency = spellStat.getPotency();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (double)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0;
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        Entity target = MobUtil.getSingleTarget((Level)worldIn, caster, range, 3.0, EntitySelector.f_20406_);
        if (caster instanceof Mob) {
            Mob mob = (Mob)caster;
            target = mob.m_5448_();
        }
        if (target != null) {
            LivingEntity livingTarget;
            Entity entity;
            boolean flag = true;
            if (caster.m_20191_().m_82400_(0.5).m_82309_() * potency >= target.m_20191_().m_82309_() && (entity = this.victim) instanceof LivingEntity && ((livingTarget = (LivingEntity)entity).m_21233_() >= (float)((Integer)SpellConfig.TelekinesisMaxHealth.get()).intValue() || MobUtil.hasEntityTypesConfig((List)SpellConfig.TelekinesisBlackList.get(), livingTarget.m_6095_()))) {
                flag = false;
            }
            if (flag) {
                this.victim = target;
            }
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        double potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (double)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster) / 2.0;
        }
        if (this.victim != null) {
            try {
                Entity entity;
                Vec3 vec3 = this.victim.m_20184_();
                Vec3 force = caster.m_20154_().m_82541_().m_82490_((double)Math.max(caster.m_20270_(this.victim), 4.0f)).m_82549_(caster.m_20182_()).m_82546_(this.victim.m_20182_()).m_82490_(potency);
                if (force.f_82480_ > 0.0) {
                    this.victim.m_183634_();
                }
                Vec3 newMotion = force.m_82546_(vec3).m_82490_(0.25).m_82549_(vec3);
                Vec3 delta = newMotion.m_82546_(vec3);
                Vec3 clampedMotion = new Vec3(TelekinesisSpell.signedMin(delta.f_82479_, force.f_82479_ * 4.0), TelekinesisSpell.signedMin(delta.f_82480_, force.f_82480_ * 4.0), TelekinesisSpell.signedMin(delta.f_82481_, force.f_82481_ * 4.0));
                MobUtil.push(this.victim, clampedMotion, 0.25);
                Vec3 old = new Vec3(this.victim.f_19790_, this.victim.f_19791_, this.victim.f_19792_);
                Vec3 travel = this.victim.m_20182_().m_82546_(old);
                if (this.victim.f_19862_ && (entity = this.victim) instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)entity;
                    double d11 = livingTarget.m_20184_().m_165924_();
                    float f1 = (float)(d11 * 10.0 - 3.0);
                    int airborne = (int)travel.m_165925_() / 2;
                    if (f1 >= 1.0f && livingTarget.m_6469_(livingTarget.m_269291_().m_269515_(), 4.0f + (float)(airborne + 1) * 0.5f)) {
                        livingTarget.m_5496_(livingTarget.m_196493_().f_196627_(), 2.0f, 1.0f);
                    }
                }
                if (CuriosFinder.hasCurio(caster, (Item)ModItems.RING_OF_FORCE.get())) {
                    this.victim.m_20301_(Math.max(-20, this.victim.m_20146_() - 10));
                    if (this.victim.m_20146_() <= -20) {
                        this.victim.m_20301_(0);
                        this.victim.m_6469_(ModDamageSource.choke((Entity)caster, (Entity)caster), 2.0f);
                    }
                }
                ServerParticleUtil.addParticlesAroundMiddleSelf(worldIn, (ParticleOptions)ParticleTypes.f_123760_, this.victim);
            }
            catch (NullPointerException exception) {
                caster.m_5810_();
            }
        } else {
            this.findVictim(worldIn, caster, spellStat);
        }
    }

    public static double signedMin(double a, double b) {
        return (double)(a < 0.0 ? -1 : 1) * Math.min(Math.abs(a), Math.abs(b));
    }
}

