/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.BreathingSpell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class FrostBreathSpell
extends BreathingSpell {
    public float damage = ((Double)SpellConfig.FrostBreathDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();

    @Override
    public SpellStat defaultStats() {
        return new SpellStat(0, 1, 8, 0.0, 0, 0.0f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.FrostBreathCost.get();
    }

    @Override
    public int defaultCastUp() {
        return (Integer)SpellConfig.FrostBreathChargeUp.get();
    }

    @Override
    public int shotsNumber() {
        return (Integer)SpellConfig.FrostBreathDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.FrostBreathCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public void useParticle(Level worldIn, LivingEntity caster, ItemStack stack) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (Entity)caster);
        }
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster, SpellStat spellStat) {
        Mob mob;
        if (caster instanceof Mob && (mob = (Mob)caster).m_5448_() != null) {
            int range = spellStat.getRange();
            if (WandUtil.enchantedFocus(caster)) {
                range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            }
            return mob.m_142582_((Entity)mob.m_5448_()) && (double)mob.m_20270_((Entity)mob.m_5448_()) <= (double)range + 4.0;
        }
        return super.conditionsMet(worldIn, caster, spellStat);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            potency += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        float damage = this.damage + potency;
        if (!worldIn.f_46443_) {
            if (CuriosFinder.hasCurio(caster, (Item)ModItems.RING_OF_THE_DRAGON.get())) {
                damage *= 2.0f;
                if (((Boolean)SpellConfig.DragonFrostGriefing.get()).booleanValue()) {
                    float flameRange = (float)range * ((float)Math.PI / 180);
                    for (int i = 0; i < 3; ++i) {
                        Vec3 cast = caster.m_20154_().m_82541_().m_82496_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange).m_82524_(worldIn.f_46441_.m_188501_() * flameRange * 2.0f - flameRange);
                        BlockHitResult hitResult = worldIn.m_45547_(new ClipContext(caster.m_146892_(), caster.m_146892_().m_82549_(cast.m_82490_(10.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
                        if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
                        Vec3 pos = hitResult.m_82450_().m_82546_(cast.m_82490_(0.5));
                        BlockPos blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
                        if ((worldIn.m_8055_(blockPos).m_60795_() || BlockFinder.canBeReplaced((Level)worldIn, blockPos) && worldIn.m_6425_(blockPos).m_76178_()) && worldIn.m_8055_(blockPos.m_7495_()).m_60804_((BlockGetter)worldIn, blockPos.m_7495_())) {
                            worldIn.m_46597_(blockPos, Blocks.f_50125_.m_49966_());
                        }
                        BlockState blockstate = Blocks.f_50449_.m_49966_();
                        if (worldIn.m_8055_(blockPos) != FrostedIceBlock.m_278844_() || !blockstate.m_60710_((LevelReader)worldIn, blockPos) || !worldIn.m_45752_(blockstate, blockPos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)caster, (BlockSnapshot)BlockSnapshot.create((ResourceKey)worldIn.m_46472_(), (LevelAccessor)worldIn, (BlockPos)blockPos), (Direction)Direction.UP)) continue;
                        worldIn.m_46597_(blockPos, blockstate);
                        worldIn.m_186460_(blockPos, Blocks.f_50449_, Mth.m_216271_((RandomSource)caster.m_217043_(), (int)60, (int)120));
                    }
                }
            }
            for (Entity target : this.getBreathTarget(caster, range)) {
                LivingEntity livingEntity = MobUtil.getLivingTarget(target);
                if (livingEntity == null || !livingEntity.m_6469_(ModDamageSource.frostBreath((Entity)caster, (Entity)caster), damage)) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(1) * duration));
            }
        }
        worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)ModSounds.FROST_BREATH.get(), this.getSoundSource(), worldIn.f_46441_.m_188501_() * 0.5f, worldIn.f_46441_.m_188501_() * 0.5f);
    }

    @Override
    public void showWandBreath(LivingEntity entityLiving) {
        int range = 0;
        if (WandUtil.enchantedFocus(entityLiving)) {
            range = WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), entityLiving);
        }
        if (!CuriosFinder.hasCurio(entityLiving, (Item)ModItems.RING_OF_THE_DRAGON.get())) {
            this.breathAttack((ParticleOptions)ParticleTypes.f_123759_, entityLiving, (double)0.3f + (double)range / 10.0, 5.0);
        } else {
            this.dragonBreathAttack((ParticleOptions)ModParticleTypes.FROST.get(), entityLiving, (double)0.3f + (double)range / 10.0);
        }
    }
}

