/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.frost;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.IceSpear;
import com.Polarice3.Goety.common.entities.projectiles.IceSpike;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class IceSpikeSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setVelocity(1.6f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.IceSpikeCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.IceSpikeDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.FROST_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.IceSpikeCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.FROST;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            velocity += (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster) / 3.0f;
        }
        IceSpike iceSpike = new IceSpike(caster, (Level)worldIn);
        if (this.rightStaff(staff)) {
            iceSpike = new IceSpear(caster, (Level)worldIn);
            velocity *= 1.5f;
        }
        iceSpike.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, velocity, 1.0f);
        iceSpike.m_5602_((Entity)caster);
        iceSpike.setExtraDamage(potency);
        worldIn.m_7967_((Entity)iceSpike);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.ICE_SPIKE_CAST.get(), 1.0f, this.projPitch(worldIn.m_213780_()));
    }
}

