/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.ScatterMine;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SoundUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ScatterSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(10).setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ScatterCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.ScatterDuration.get();
    }

    @Override
    public int castDuration(LivingEntity caster, ItemStack staff) {
        if (this.rightStaff(staff)) {
            return MathHelper.secondsToTicks(5.15f);
        }
        return super.castDuration(caster, staff);
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ScatterCoolDown.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void useParticle(Level worldIn, LivingEntity caster, ItemStack stack) {
        if (this.rightStaff(stack)) {
            for (int i = 0; i < 5; ++i) {
                double d0 = worldIn.f_46441_.m_188583_() * 0.02;
                double d1 = worldIn.f_46441_.m_188583_() * 0.02;
                double d2 = worldIn.f_46441_.m_188583_() * 0.02;
                if (!(worldIn instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)worldIn;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_ELECTRIC.get()), caster.m_20208_(0.5), caster.m_20188_() - (double)serverLevel.f_46441_.m_188503_(5), caster.m_20262_(0.5), 0, d0, d1, d2, 0.5);
            }
        }
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        if (this.rightStaff(staff)) {
            int time;
            int potency = spellStat.getPotency();
            double radius = spellStat.getRadius();
            int duration = spellStat.getDuration();
            if (WandUtil.enchantedFocus(caster)) {
                potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
                radius += (double)((float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0f);
                duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            }
            if (castTime % (time = MathHelper.secondsToTicks(4.15f) / 14) == 0 && caster.m_20096_()) {
                BlockPos blockPos = caster.m_20183_();
                blockPos = blockPos.m_7918_(-8 + worldIn.f_46441_.m_188503_(16), 0, -8 + worldIn.f_46441_.m_188503_(16));
                BlockPos blockPos2 = caster.m_20183_().m_7918_(-8 + worldIn.f_46441_.m_188503_(16), 0, -8 + worldIn.f_46441_.m_188503_(16));
                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
                Vec3 vec32 = Vec3.m_82539_((Vec3i)blockPos2);
                ScatterMine scatterMine = new ScatterMine((Level)worldIn, caster, vec3);
                scatterMine.setExtraDamage(potency);
                scatterMine.setExtraRadius((float)radius);
                scatterMine.lifeTicks = MathHelper.secondsToTicks(duration);
                if (!worldIn.m_45976_(ScatterMine.class, new AABB(blockPos)).isEmpty()) {
                    scatterMine.m_6034_(vec32.m_7096_(), vec32.m_7098_(), vec32.m_7094_());
                }
                if (worldIn.m_7967_((Entity)scatterMine) && worldIn.f_46441_.m_188499_()) {
                    SoundUtil.playRedstoneMineLoad(scatterMine);
                }
            }
        }
        super.useSpell(worldIn, caster, staff, castTime, spellStat);
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        if (this.rightStaff(staff)) {
            return;
        }
        int potency = spellStat.getPotency();
        double radius = spellStat.getRadius();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            radius += (double)((float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0f);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        int amount = 3;
        for (int i = 0; i < amount; ++i) {
            BlockPos blockPos = caster.m_20183_();
            blockPos = blockPos.m_7918_(-4 + worldIn.f_46441_.m_188503_(8), 0, -4 + worldIn.f_46441_.m_188503_(8));
            BlockPos blockPos2 = caster.m_20183_().m_7918_(-4 + worldIn.f_46441_.m_188503_(8), 0, -4 + worldIn.f_46441_.m_188503_(8));
            Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
            Vec3 vec31 = Vec3.m_82539_((Vec3i)blockPos2);
            ScatterMine scatterMine = new ScatterMine((Level)worldIn, caster, vec3);
            scatterMine.setIsSpell();
            scatterMine.setExtraDamage(potency);
            scatterMine.setExtraRadius((float)radius);
            scatterMine.lifeTicks = MathHelper.secondsToTicks(duration);
            if (!worldIn.m_45976_(ScatterMine.class, new AABB(blockPos)).isEmpty()) {
                scatterMine.m_6034_(vec31.m_7096_(), vec31.m_7098_(), vec31.m_7094_());
            }
            if (!worldIn.m_7967_((Entity)scatterMine)) continue;
            SoundUtil.playRedstoneMineLoad(scatterMine);
        }
    }
}

