/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.TouchSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.RandomUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class BanishSpell
extends TouchSpell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(64);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BanishCost.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return SoundEvents.f_11757_;
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BanishCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        EntityHitResult result;
        Entity entity;
        HitResult hitResult = caster.m_19907_(caster.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()), 1.0f, false);
        if (hitResult instanceof EntityHitResult && (entity = (result = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21233_() < (float)((Integer)SpellConfig.BanishMaxHealth.get()).intValue() && !MobUtil.hasEntityTypesConfig((List)SpellConfig.BanishBlackList.get(), living.m_6095_())) {
                this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SPELL_FAIL.get(), 1.0f, 1.0f);
                return false;
            }
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)living, (double)caster.m_20185_(), (double)caster.m_20186_(), (double)caster.m_20189_());
            if (event.isCanceled()) {
                return false;
            }
        }
        return super.conditionsMet(worldIn, caster);
    }

    @Override
    public void touchResult(ServerLevel worldIn, LivingEntity caster, LivingEntity target, ItemStack staff, SpellStat spellStat) {
        double d0 = target.m_20185_();
        double d1 = target.m_20186_();
        double d2 = target.m_20189_();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        if (this.rightStaff(staff)) {
            range *= 2;
        }
        for (int i = 0; i < range; ++i) {
            Vec3 vec3;
            double d3 = target.m_20185_() + (target.m_217043_().m_188500_() - 0.5) * (double)range;
            double d4 = Mth.m_14008_((double)(target.m_20186_() + (double)(RandomUtil.nextInt(target.m_217043_(), range) - range / 2)), (double)worldIn.m_141937_(), (double)(worldIn.m_141937_() + worldIn.m_143344_() - 1));
            double d5 = target.m_20189_() + (target.m_217043_().m_188500_() - 0.5) * (double)range;
            if (target.m_20159_()) {
                target.m_8127_();
            }
            if (!(caster.m_20238_(vec3 = new Vec3(d3, d4, d5)) > (double)range / 4.0) || !target.m_20984_(d3, d4, d5, true)) continue;
            worldIn.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)target));
            SoundEvent soundevent = target instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
            worldIn.m_6263_(null, d0, d1, d2, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
            target.m_5496_(soundevent, 1.0f, 1.0f);
            break;
        }
    }
}

