/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.api.magic.ITouchSpell;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.items.magic.RecallFocus;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RecallSpell
extends Spell
implements ITouchSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.RecallCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.RecallDuration.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.RecallCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public SoundEvent loopSound(LivingEntity caster) {
        return SoundEvents.f_12288_;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        if (caster instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)caster;
            if (RecallFocus.isValid(worldIn, WandUtil.findFocus((LivingEntity)player))) {
                return true;
            }
            if (!RecallFocus.hasRecall(WandUtil.findFocus((LivingEntity)player))) {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.focus.noPos"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.focus.PosInvalid"), true);
            }
        }
        return false;
    }

    @Override
    public void useParticle(Level worldIn, LivingEntity caster, ItemStack stack) {
        for (int i = 0; i < 2; ++i) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, caster.m_20208_(0.5), caster.m_20187_() - 0.25, caster.m_20262_(0.5), (worldIn.f_46441_.m_188500_() - 0.5) * 2.0, -worldIn.f_46441_.m_188500_(), (worldIn.f_46441_.m_188500_() - 0.5) * 2.0);
        }
    }

    @Override
    public void touchResult(ServerLevel worldIn, LivingEntity caster, LivingEntity target, ItemStack staff, SpellStat spellStat) {
        ServerPlayer player;
        if (caster instanceof ServerPlayer && RecallFocus.isValid(worldIn, WandUtil.findFocus((LivingEntity)(player = (ServerPlayer)caster))) && MobUtil.getOwner((Entity)target) != null && MobUtil.getOwner((Entity)target) == caster) {
            if (target instanceof IServant) {
                IServant servant = (IServant)target;
                BlockPos blockPos = RecallFocus.getRecallBlockPos(WandUtil.findFocus((LivingEntity)player));
                servant.setWandering(false);
                if (blockPos != null) {
                    servant.setStaying(false);
                    servant.setBoundPos(blockPos);
                } else {
                    servant.setStaying(true);
                    servant.setBoundPos(null);
                }
            }
            RecallFocus.recall(target, WandUtil.findFocus((LivingEntity)player));
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        ServerPlayer player;
        if (caster instanceof ServerPlayer && RecallFocus.isValid(worldIn, WandUtil.findFocus((LivingEntity)(player = (ServerPlayer)caster)))) {
            RecallFocus.recall((LivingEntity)player, WandUtil.findFocus((LivingEntity)player));
        }
    }
}

