/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wild;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.AnimalSummon;
import com.Polarice3.Goety.common.entities.ally.BearServant;
import com.Polarice3.Goety.common.entities.ally.HoglinServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class MaulingSpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.MaulingCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.MaulingDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WILD_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.MaulingCoolDown.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.MaulingSummonDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WILD;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof BearServant;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.MaulingLimit.get();
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        if (!this.isShifting(caster)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i = 2;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                AnimalSummon summonedentity = new BearServant((EntityType<? extends Owned>)((EntityType)ModEntityType.BEAR_SERVANT.get()), (Level)worldIn);
                BlockPos blockPos = BlockFinder.SummonRadius(caster.m_20183_(), (Entity)summonedentity, (Level)worldIn);
                if (this.typeStaff(staff, SpellType.NETHER) || worldIn.m_46472_() == Level.f_46429_) {
                    summonedentity = new HoglinServant((EntityType<? extends Owned>)((EntityType)ModEntityType.HOGLIN_SERVANT.get()), (Level)worldIn);
                } else if (this.typeStaff(staff, SpellType.FROST) || worldIn.m_204166_(blockPos).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD)) {
                    summonedentity = new BearServant((EntityType<? extends Owned>)((EntityType)ModEntityType.POLAR_BEAR_SERVANT.get()), (Level)worldIn);
                } else if (blockPos.m_123342_() <= 64 && !worldIn.m_45527_(blockPos) && summonedentity instanceof BearServant) {
                    AnimalSummon bearServant = summonedentity;
                    ((BearServant)bearServant).setBearCave();
                }
                summonedentity.setTrueOwner(caster);
                summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                MobUtil.moveDownToGround((Entity)summonedentity);
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                summonedentity.m_21530_();
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                this.buffSummon(caster, (LivingEntity)summonedentity, potency);
                this.SummonSap(caster, (LivingEntity)summonedentity);
                this.setTarget(caster, (Mob)summonedentity);
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(caster, (LivingEntity)summonedentity);
            }
            this.SummonDown(caster);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SUMMON_SPELL.get());
        }
    }
}

