/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;

public class LaunchSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.LaunchCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.LaunchDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.WIND.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.LaunchCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        caster.f_19864_ = true;
        caster.m_6853_(false);
        Vec3 vector3d = caster.m_20154_();
        double power = this.rightStaff(staff) ? 2.5 : 1.5;
        double d0 = power + (double)potency / 2.0;
        caster.m_20334_(vector3d.f_82479_ * d0, vector3d.f_82480_ * d0, vector3d.f_82481_ * d0);
        caster.f_19812_ = true;
        caster.f_19789_ = 0.0f;
        this.playSound(worldIn, caster, 2.0f, 1.0f);
    }
}

