/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class WindHornSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(3).setRadius(3.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.TremblingCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.TremblingDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.TremblingCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int radius = (int)spellStat.getRadius();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            radius += WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
        }
        if (this.rightStaff(staff)) {
            radius *= 2;
        }
        ColorUtil colorUtil = new ColorUtil(0xFFFFFF);
        worldIn.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), radius * 2, radius), caster.m_20185_(), caster.m_20186_() + 0.5, caster.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        ServerParticleUtil.windShockwaveParticle(worldIn, colorUtil, radius, 0.0f, -1, caster.m_20182_().m_82520_(0.0, 1.0, 0.0));
        for (LivingEntity livingEntity : worldIn.m_45976_(LivingEntity.class, caster.m_20191_().m_82400_((double)radius))) {
            if (MobUtil.areAllies((Entity)caster, (Entity)livingEntity)) continue;
            double power = 4.0 + (double)potency;
            double d0 = livingEntity.m_20185_() - caster.m_20185_();
            double d1 = livingEntity.m_20189_() - caster.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            MobUtil.push((Entity)livingEntity, d0 / d2 * power, 0.2, d1 / d2 * power);
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, MathHelper.secondsToTicks(duration), potency));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, MathHelper.secondsToTicks(duration), potency));
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.WIND_HORN.get(), 3.0f, 1.0f);
    }
}

