/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network;

import com.Polarice3.Goety.utils.EntityFinder;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EntityUpdatePacket {
    private final UUID LivingEntityUUID;
    private CompoundTag tag;

    public EntityUpdatePacket(UUID uuid, CompoundTag tag) {
        this.LivingEntityUUID = uuid;
        this.tag = tag;
    }

    public static void encode(EntityUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.LivingEntityUUID);
        buffer.m_130079_(packet.tag);
    }

    public static EntityUpdatePacket decode(FriendlyByteBuf buffer) {
        return new EntityUpdatePacket(buffer.m_130259_(), buffer.m_130260_());
    }

    public static void consume(EntityUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (entity = EntityFinder.getEntityByUuiDGlobal(packet.LivingEntityUUID).get()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7378_(packet.tag);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

