/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.world.features.utils;

import com.Polarice3.Goety.common.world.features.utils.ModFeatureLogic;
import com.Polarice3.Goety.common.world.features.utils.VoxelBresenhamIterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraftforge.event.ForgeEventFactory;

public final class ModFeaturePlacers {
    public static final BiFunction<LevelSimulatedReader, BlockPos, Boolean> VALID_TREE_POS = TreeFeature::m_67272_;
    private static final Direction[] directionsExceptDown = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static <T extends Mob> void placeEntity(EntityType<T> entityType, BlockPos pos, ServerLevelAccessor levelAccessor) {
        Mob mob = (Mob)entityType.m_20615_((Level)levelAccessor.m_6018_());
        if (mob == null) {
            return;
        }
        mob.m_21530_();
        mob.m_20035_(pos, 0.0f, 0.0f);
        ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)levelAccessor, (DifficultyInstance)levelAccessor.m_6436_(pos), (MobSpawnType)MobSpawnType.STRUCTURE, null, null);
        levelAccessor.m_47205_((Entity)mob);
        levelAccessor.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    public static void drawBresenhamBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, RandomSource random, BlockPos start, BlockPos end, BlockStateProvider config) {
        for (BlockPos pixel : new VoxelBresenhamIterator(start, end)) {
            ModFeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pixel, config);
        }
    }

    public static void buildRoot(LevelAccessor world, BiConsumer<BlockPos, BlockState> placer, RandomSource rand, BlockPos start, double offset, int b, BlockStateProvider config) {
        BlockPos dest = ModFeatureLogic.translate(start.m_6625_(b + 2), 5.0, 0.3 * (double)b + offset, 0.8);
        for (BlockPos coord : new VoxelBresenhamIterator(start.m_7495_(), dest)) {
            if (ModFeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, placer, rand, coord, config)) continue;
            return;
        }
    }

    public static void drawBresenhamTree(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos from, BlockPos to, BlockStateProvider config, RandomSource random) {
        for (BlockPos pixel : new VoxelBresenhamIterator(from, to)) {
            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, pixel, config, random);
        }
    }

    public static void placeProvidedBlock(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> worldPlacer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos pos, BlockStateProvider config, RandomSource random) {
        if (predicate.apply(world, pos).booleanValue()) {
            worldPlacer.accept(pos, config.m_213972_(random, pos));
        }
    }

    public static void placeLeaf(LevelSimulatedReader world, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos pos, BlockStateProvider config, RandomSource random) {
        if (predicate.apply(world, pos).booleanValue()) {
            setter.m_271838_(pos, config.m_213972_(random, pos));
        }
    }

    public static void placeCircleOdd(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config) {
        float radiusSquared = radius * radius;
        ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 1;
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) <= radiusSquared) {
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, 0, z), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, 0, x), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, 0, -x), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeCircleEven(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config) {
        float radiusSquared = radius * radius;
        ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 0;
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) <= radiusSquared) {
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(1 + x, 0, 1 + z), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, 1 + z), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(1 + x, 0, -z), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeSpheroid(LevelSimulatedReader world, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, float verticalBias, BlockStateProvider config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(0, y, 0), config, random);
                ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(x, 0, z), config, random);
                    ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(-z, 0, x), config, random);
                    ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(x, y2, z), config, random);
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(-x, y2, -z), config, random);
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(-z, y2, x), config, random);
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(z, y2, -x), config, random);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(x, -y2, z), config, random);
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(-x, -y2, -z), config, random);
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(-z, -y2, x), config, random);
                            ModFeaturePlacers.placeLeaf(world, setter, predicate, centerPos.m_7918_(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeSpheroid(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, BlockStateProvider config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, y, 0), config, random);
                ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, 0, z), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, 0, x), config, random);
                    ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + (float)(y2 * y2) * xzRadiusSquared <= superRadiusSquared) {
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, y2, z), config, random);
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, y2, -z), config, random);
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, y2, x), config, random);
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, y2, -x), config, random);
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, -y2, z), config, random);
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, -y2, -z), config, random);
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, -y2, x), config, random);
                            ModFeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static boolean placeIfValidTreePos(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, RandomSource random, BlockPos pos, BlockStateProvider config) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos)) {
            placer.accept(pos, config.m_213972_(random, pos));
            return true;
        }
        return false;
    }

    public static boolean placeIfValidRootPos(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, RandomSource random, BlockPos pos, BlockStateProvider config) {
        if (ModFeatureLogic.canRootGrowIn(world, pos)) {
            placer.accept(pos, config.m_213972_(random, pos));
            return true;
        }
        return false;
    }

    private static void setIfEmpty(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.m_46859_(pos)) {
            world.m_7731_(pos, state, 3);
        }
    }

    public static BlockState transferAllStateKeys(BlockState stateIn, Block blockOut) {
        return ModFeaturePlacers.transferAllStateKeys(stateIn, blockOut.m_49966_());
    }

    public static BlockState transferAllStateKeys(BlockState stateIn, BlockState stateOut) {
        for (Property property : stateOut.m_61147_()) {
            stateOut = ModFeaturePlacers.transferStateKey(stateIn, stateOut, property);
        }
        return stateOut;
    }

    public static <T extends Comparable<T>> BlockState transferStateKey(BlockState stateIn, BlockState stateOut, Property<T> property) {
        if (!stateIn.m_61138_(property) || !stateOut.m_61138_(property)) {
            return stateOut;
        }
        return (BlockState)stateOut.m_61124_(property, stateIn.m_61143_(property));
    }

    public static boolean isAreaSuitable(WorldGenLevel world, BlockPos pos, int width, int height, int depth) {
        return ModFeaturePlacers.isAreaSuitable(world, pos, width, height, depth, false);
    }

    public static boolean isAreaSuitable(WorldGenLevel world, BlockPos pos, int width, int height, int depth, boolean underwaterAllowed) {
        boolean flag = true;
        for (int cx = 0; cx < width; ++cx) {
            for (int cz = 0; cz < depth; ++cz) {
                BlockPos pos_ = pos.m_7918_(cx, 0, cz);
                if (world.m_46805_(pos_)) {
                    BlockState state = world.m_8055_(pos_.m_7495_());
                    if (!state.m_60804_((BlockGetter)world, pos_) || ModFeatureLogic.isBlockNotOk(state)) {
                        if (underwaterAllowed && state.m_278721_()) continue;
                        flag = false;
                    }
                    for (int cy = 0; cy < height; ++cy) {
                        if (world.m_46859_(pos_.m_6630_(cy)) || world.m_8055_(pos_.m_6630_(cy)).m_247087_() || underwaterAllowed && world.m_8055_(pos_.m_6630_(cy)).m_278721_()) continue;
                        flag = false;
                    }
                    continue;
                }
                flag = false;
            }
        }
        return flag;
    }

    public static void drawBlob(LevelAccessor world, BlockPos pos, int rad, BlockState state) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    world.m_7731_(pos.m_7918_(dx, dy, dz), state, 3);
                    world.m_7731_(pos.m_7918_(dx, dy, -dz), state, 3);
                    world.m_7731_(pos.m_7918_(-dx, dy, dz), state, 3);
                    world.m_7731_(pos.m_7918_(-dx, dy, -dz), state, 3);
                    world.m_7731_(pos.m_7918_(dx, -dy, dz), state, 3);
                    world.m_7731_(pos.m_7918_(dx, -dy, -dz), state, 3);
                    world.m_7731_(pos.m_7918_(-dx, -dy, dz), state, 3);
                    world.m_7731_(pos.m_7918_(-dx, -dy, -dz), state, 3);
                }
            }
        }
    }

    public static boolean hasAirAround(LevelAccessor world, BlockPos pos) {
        for (Direction e : directionsExceptDown) {
            if (!world.m_46859_(pos.m_121945_(e))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNearSolid(LevelReader world, BlockPos pos) {
        for (Direction e : Direction.values()) {
            if (!world.m_46805_(pos.m_121945_(e)) || !world.m_8055_(pos.m_121945_(e)).m_280296_()) continue;
            return true;
        }
        return false;
    }
}

