/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class Vec3Util {
    public static final Vec3 xAxis = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 yAxis = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 zAxis = new Vec3(0.0, 0.0, 1.0);
    public static final Vec3 unit = new Vec3(1.0, 1.0, 1.0);

    public static Vec3 north(Vec3 vector3d) {
        return Vec3Util.relative(vector3d, Direction.NORTH);
    }

    public static Vec3 north(Vec3 vector3d, int distance) {
        return Vec3Util.relative(vector3d, Direction.NORTH, distance);
    }

    public static Vec3 south(Vec3 vector3d) {
        return Vec3Util.relative(vector3d, Direction.SOUTH);
    }

    public static Vec3 south(Vec3 vector3d, int distance) {
        return Vec3Util.relative(vector3d, Direction.SOUTH, distance);
    }

    public static Vec3 west(Vec3 vector3d) {
        return Vec3Util.relative(vector3d, Direction.WEST);
    }

    public static Vec3 west(Vec3 vector3d, int distance) {
        return Vec3Util.relative(vector3d, Direction.WEST, distance);
    }

    public static Vec3 east(Vec3 vector3d) {
        return Vec3Util.relative(vector3d, Direction.EAST);
    }

    public static Vec3 east(Vec3 vector3d, int distance) {
        return Vec3Util.relative(vector3d, Direction.EAST, distance);
    }

    public static Vec3 relative(Vec3 vector3d, Direction p_177972_1_) {
        return new Vec3(vector3d.m_7096_() + (double)p_177972_1_.m_122429_(), vector3d.m_7098_() + (double)p_177972_1_.m_122430_(), vector3d.m_7094_() + (double)p_177972_1_.m_122431_());
    }

    public static Vec3 relative(Vec3 vector3d, Direction pDirection, int pDistance) {
        return pDistance == 0 ? vector3d : new Vec3(vector3d.m_7096_() + (double)(pDirection.m_122429_() * pDistance), vector3d.m_7098_() + (double)(pDirection.m_122430_() * pDistance), vector3d.m_7094_() + (double)(pDirection.m_122431_() * pDistance));
    }

    public static Vec3 subtract(Vec3 vec3, double amount) {
        return vec3.m_82492_(amount, amount, amount);
    }

    public static Vec3 add(Vec3 vec3, double amount) {
        return vec3.m_82520_(amount, amount, amount);
    }

    public static Vec3 readVec3(CompoundTag compoundTag) {
        return new Vec3(compoundTag.m_128459_("X"), compoundTag.m_128459_("Y"), compoundTag.m_128459_("Z"));
    }

    public static CompoundTag writeVec3(Vec3 vec3) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128347_("X", vec3.f_82479_);
        compoundtag.m_128347_("Y", vec3.f_82480_);
        compoundtag.m_128347_("Z", vec3.f_82481_);
        return compoundtag;
    }

    public static Vec3 coerceAtLeast(Vec3 vec1, Vec3 vec2) {
        return new Vec3(Math.max(vec1.m_7096_(), vec2.m_7096_()), Math.max(vec1.m_7098_(), vec2.m_7098_()), Math.max(vec1.m_7094_(), vec2.m_7094_()));
    }

    public static Vec3 coerceAtMost(Vec3 vec1, Vec3 vec2) {
        return new Vec3(Math.min(vec1.m_7096_(), vec2.m_7096_()), Math.min(vec1.m_7098_(), vec2.m_7098_()), Math.min(vec1.m_7094_(), vec2.m_7094_()));
    }

    public static Vec3 randVec(Supplier<Double> rand) {
        return new Vec3(rand.get() - 0.5, rand.get() - 0.5, rand.get() - 0.5);
    }

    public static Vec3 randVec(RandomSource random) {
        return Vec3Util.randVec(() -> ((RandomSource)random).m_188500_());
    }
}

