/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModRenderType;
import com.Polarice3.Goety.common.entities.projectiles.AbstractBeam;
import com.Polarice3.Goety.common.entities.projectiles.CorruptedBeam;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class CorruptedBeamRenderer<T extends CorruptedBeam>
extends EntityRenderer<T> {
    private static final ResourceLocation beaconBeamCore = Goety.location("textures/entity/corrupted/beacon_beam_core.png");
    private static final ResourceLocation beaconBeamMain = Goety.location("textures/entity/corrupted/beacon_beam_main.png");
    private static final ResourceLocation beaconBeamGlow = Goety.location("textures/entity/corrupted/beacon_beam_glow.png");

    public CorruptedBeamRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        double distance = ((AbstractBeam)((Object)pEntity)).beamTraceDistance(64.0, 1.0f, false);
        float speedModifier = -0.02f;
        CorruptedBeamRenderer.drawBeams(distance, pEntity, pPartialTicks, speedModifier, pMatrixStack);
    }

    private static void drawBeams(double distance, CorruptedBeam entity, float ticks, float speedModifier, PoseStack pMatrixStack) {
        long gameTime = entity.f_19853_.m_46467_();
        double velocity = (float)gameTime * speedModifier;
        float additiveThickness = entity.getBeamWidth() * 1.75f * CorruptedBeamRenderer.calculateLaserFlickerModifier(gameTime);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        pMatrixStack.m_85836_();
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)CorruptedBeamRenderer.boundDegrees(-entity.m_146908_()), (float)CorruptedBeamRenderer.boundDegrees(-entity.f_19859_))));
        pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)CorruptedBeamRenderer.boundDegrees(entity.m_146909_()), (float)CorruptedBeamRenderer.boundDegrees(entity.f_19860_))));
        PoseStack.Pose matrixstack$entry = pMatrixStack.m_85850_();
        Matrix3f matrixNormal = matrixstack$entry.m_252943_();
        Matrix4f positionMatrix = matrixstack$entry.m_252922_();
        CorruptedBeamRenderer.drawClosingBeam(buffer.m_6299_(ModRenderType.magicBeam(beaconBeamGlow)), positionMatrix, matrixNormal, additiveThickness, distance / 10.0, 0.5, 1.0, ticks, 0.9f);
        CorruptedBeamRenderer.drawBeam(buffer.m_6299_(ModRenderType.magicBeam(beaconBeamMain)), positionMatrix, matrixNormal, entity.getBeamWidth(), distance, velocity, velocity + distance * 1.5, ticks, 0.7f);
        CorruptedBeamRenderer.drawBeam(buffer.m_6299_(ModRenderType.magicBeam(beaconBeamCore)), positionMatrix, matrixNormal, entity.getBeamWidth() * 0.7f, distance, velocity, velocity + distance * 1.5, ticks, 1.0f);
        pMatrixStack.m_85849_();
        buffer.m_109911_();
    }

    private static float boundDegrees(float rotation) {
        return (rotation % 360.0f + 360.0f) % 360.0f;
    }

    private static float calculateLaserFlickerModifier(long gameTime) {
        return 0.9f + 0.1f * Mth.m_14031_((float)((float)gameTime * 0.99f)) * Mth.m_14031_((float)((float)gameTime * 0.3f)) * Mth.m_14031_((float)((float)gameTime * 0.1f));
    }

    private static void drawBeam(VertexConsumer builder, Matrix4f positionMatrix, Matrix3f matrixNormalIn, float thickness, double distance, double v1, double v2, float ticks, float alpha) {
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        matrixNormalIn.transform(vector3f);
        float xMin = -thickness;
        float xMax = thickness;
        float yMin = -thickness - 0.115f;
        float yMax = thickness - 0.115f;
        float zMin = 0.0f;
        float zMax = (float)distance;
        Vector4f vec1 = new Vector4f(xMin, yMin, zMin, 1.0f);
        positionMatrix.transform(vec1);
        Vector4f vec2 = new Vector4f(xMin, yMin, zMax, 1.0f);
        positionMatrix.transform(vec2);
        Vector4f vec3 = new Vector4f(xMin, yMax, zMax, 1.0f);
        positionMatrix.transform(vec3);
        Vector4f vec4 = new Vector4f(xMin, yMax, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
        vec1 = new Vector4f(xMax, yMin, zMin, 1.0f);
        positionMatrix.transform(vec1);
        vec2 = new Vector4f(xMax, yMin, zMax, 1.0f);
        positionMatrix.transform(vec2);
        vec3 = new Vector4f(xMax, yMax, zMax, 1.0f);
        positionMatrix.transform(vec3);
        vec4 = new Vector4f(xMax, yMax, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
        vec1 = new Vector4f(xMin, yMax, zMin, 1.0f);
        positionMatrix.transform(vec1);
        vec2 = new Vector4f(xMin, yMax, zMax, 1.0f);
        positionMatrix.transform(vec2);
        vec3 = new Vector4f(xMax, yMax, zMax, 1.0f);
        positionMatrix.transform(vec3);
        vec4 = new Vector4f(xMax, yMax, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
        vec1 = new Vector4f(xMin, yMin, zMin, 1.0f);
        positionMatrix.transform(vec1);
        vec2 = new Vector4f(xMin, yMin, zMax, 1.0f);
        positionMatrix.transform(vec2);
        vec3 = new Vector4f(xMax, yMin, zMax, 1.0f);
        positionMatrix.transform(vec3);
        vec4 = new Vector4f(xMax, yMin, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
    }

    private static void drawClosingBeam(VertexConsumer builder, Matrix4f positionMatrix, Matrix3f matrixNormalIn, float thickness, double distance, double v1, double v2, float ticks, float alpha) {
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        matrixNormalIn.transform(vector3f);
        float xMin = -thickness;
        float xMax = thickness;
        float yMin = -thickness - 0.115f;
        float yMax = thickness - 0.115f;
        float zMin = 0.0f;
        float zMax = (float)distance;
        Vector4f vec1 = new Vector4f(xMin, yMin, zMin, 1.0f);
        positionMatrix.transform(vec1);
        Vector4f vec2 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec2);
        Vector4f vec3 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec3);
        Vector4f vec4 = new Vector4f(xMin, yMax, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
        vec1 = new Vector4f(xMax, yMin, zMin, 1.0f);
        positionMatrix.transform(vec1);
        vec2 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec2);
        vec3 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec3);
        vec4 = new Vector4f(xMax, yMax, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
        vec1 = new Vector4f(xMin, yMax, zMin, 1.0f);
        positionMatrix.transform(vec1);
        vec2 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec2);
        vec3 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec3);
        vec4 = new Vector4f(xMax, yMax, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
        vec1 = new Vector4f(xMin, yMin, zMin, 1.0f);
        positionMatrix.transform(vec1);
        vec2 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec2);
        vec3 = new Vector4f(0.0f, 0.0f, zMax, 1.0f);
        positionMatrix.transform(vec3);
        vec4 = new Vector4f(xMax, yMin, zMin, 1.0f);
        positionMatrix.transform(vec4);
        CorruptedBeamRenderer.drawQuad(builder, (float)v1, (float)v2, alpha, vector3f, vec1, vec2, vec3, vec4);
    }

    private static void drawQuad(VertexConsumer builder, float v1, float v2, float alpha, Vector3f vector3f, Vector4f vec1, Vector4f vec2, Vector4f vec3, Vector4f vec4) {
        builder.m_5954_(vec4.x(), vec4.y(), vec4.z(), 1.0f, 1.0f, 1.0f, alpha, 0.0f, v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.x(), vector3f.y(), vector3f.z());
        builder.m_5954_(vec3.x(), vec3.y(), vec3.z(), 1.0f, 1.0f, 1.0f, alpha, 0.0f, v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.x(), vector3f.y(), vector3f.z());
        builder.m_5954_(vec2.x(), vec2.y(), vec2.z(), 1.0f, 1.0f, 1.0f, alpha, 1.0f, v2, OverlayTexture.f_118083_, 0xF000F0, vector3f.x(), vector3f.y(), vector3f.z());
        builder.m_5954_(vec1.x(), vec1.y(), vec1.z(), 1.0f, 1.0f, 1.0f, alpha, 1.0f, v1, OverlayTexture.f_118083_, 0xF000F0, vector3f.x(), vector3f.y(), vector3f.z());
    }

    public ResourceLocation getTextureLocation(T p_110775_1_) {
        return beaconBeamCore;
    }
}

