/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.layer.IllusionCapeLayer;
import com.Polarice3.Goety.client.render.layer.NamelessSetLayer;
import com.Polarice3.Goety.client.render.model.LichModeModel;
import com.Polarice3.Goety.common.entities.ally.Doppelganger;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class DoppelgangerRenderer
extends HumanoidMobRenderer<Doppelganger, PlayerModel<Doppelganger>> {
    private final PlayerModel<Doppelganger> normalModel = (PlayerModel)this.m_7200_();
    private final PlayerModel<Doppelganger> slimModel;
    private final PlayerModel<Doppelganger> lichModel;
    private static final ResourceLocation TEXTURE = Goety.location("textures/entity/lich.png");

    public DoppelgangerRenderer(EntityRendererProvider.Context p_174557_, boolean p_174558_) {
        super(p_174557_, (HumanoidModel)new PlayerModel(p_174557_.m_174023_(ModelLayers.f_171162_), p_174558_), 0.5f);
        this.slimModel = new PlayerModel(p_174557_.m_174023_(ModelLayers.f_171166_), true);
        this.lichModel = new LichModeModel<Doppelganger>(p_174557_.m_174023_(ModModelLayer.LICH));
        this.m_115326_(new IllusionCapeLayer((RenderLayerParent<Doppelganger, PlayerModel<Doppelganger>>)this));
        this.m_115326_(new NamelessSetLayer(this, p_174557_.m_174027_()));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(p_174557_.m_174023_(p_174558_ ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new HumanoidModel(p_174557_.m_174023_(p_174558_ ? ModelLayers.f_171168_ : ModelLayers.f_171165_)), p_174557_.m_266367_()));
    }

    public void render(Doppelganger pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.setModelProperties(pEntity);
        this.f_115290_ = LichdomHelper.isInLichMode(pEntity.getTrueOwner()) ? this.lichModel : (pEntity.getModelName().equals("slim") ? this.slimModel : this.normalModel);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    protected void scale(Doppelganger p_117798_, PoseStack p_117799_, float p_117800_) {
        float f = 0.9375f;
        p_117799_.m_85841_(f, f, f);
    }

    public ResourceLocation getTextureLocation(Doppelganger entity) {
        if (LichdomHelper.isInLichMode(entity.getTrueOwner())) {
            return TEXTURE;
        }
        return entity.getSkinTextureLocation();
    }

    public Vec3 getRenderOffset(Doppelganger p_117785_, float p_117786_) {
        return p_117785_.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)p_117785_, p_117786_);
    }

    private void setModelProperties(Doppelganger doppelganger) {
        PlayerModel playermodel = (PlayerModel)this.m_7200_();
        playermodel.m_8009_(true);
        playermodel.f_102809_.f_104207_ = doppelganger.isModelPartShown(PlayerModelPart.HAT);
        playermodel.f_103378_.f_104207_ = doppelganger.isModelPartShown(PlayerModelPart.JACKET);
        playermodel.f_103376_.f_104207_ = doppelganger.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
        playermodel.f_103377_.f_104207_ = doppelganger.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
        playermodel.f_103374_.f_104207_ = doppelganger.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
        playermodel.f_103375_.f_104207_ = doppelganger.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
        playermodel.f_102817_ = doppelganger.m_6047_();
        HumanoidModel.ArmPose bipedmodel$armpose = DoppelgangerRenderer.getArmPose(doppelganger, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose bipedmodel$armpose1 = DoppelgangerRenderer.getArmPose(doppelganger, InteractionHand.OFF_HAND);
        if (bipedmodel$armpose.m_102897_()) {
            HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = doppelganger.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (doppelganger.m_5737_() == HumanoidArm.RIGHT) {
            playermodel.f_102816_ = bipedmodel$armpose;
            playermodel.f_102815_ = bipedmodel$armpose1;
        } else {
            playermodel.f_102816_ = bipedmodel$armpose1;
            playermodel.f_102815_ = bipedmodel$armpose;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(Doppelganger p_241741_0_, InteractionHand p_241741_1_) {
        ItemStack itemstack = p_241741_0_.m_21120_(p_241741_1_);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_241741_0_.m_7655_() == p_241741_1_ && p_241741_0_.m_21212_() > 0) {
            UseAnim useaction = itemstack.m_41780_();
            if (useaction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useaction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAnim.CROSSBOW && p_241741_1_ == p_241741_0_.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!p_241741_0_.f_20911_ && itemstack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void setupRotations(Doppelganger p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.m_20998_(p_117806_);
        if (p_117802_.m_21255_()) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f1 = (float)p_117802_.m_21256_() + p_117806_;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.m_21209_()) {
                p_117803_.m_252781_(Axis.f_252529_.m_252977_(f2 * (-90.0f - p_117802_.m_146909_())));
            }
            Vec3 vec3 = p_117802_.m_20252_(p_117806_);
            Vec3 vec31 = p_117802_.m_20184_();
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                p_117803_.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f3 = p_117802_.m_20069_() || p_117802_.isInFluidType((fluidType, height) -> p_117802_.canSwimInFluidType((FluidType)fluidType)) ? -90.0f - p_117802_.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            p_117803_.m_252781_(Axis.f_252529_.m_252977_(f4));
            if (p_117802_.m_6067_()) {
                p_117803_.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
    }
}

