/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.client.render.ModRenderType;
import com.Polarice3.Goety.common.entities.projectiles.RazorWind;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RazorWindRenderer
extends EntityRenderer<RazorWind> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{Goety.location("textures/entity/projectiles/slash/1.png"), Goety.location("textures/entity/projectiles/slash/2.png"), Goety.location("textures/entity/projectiles/slash/3.png"), Goety.location("textures/entity/projectiles/slash/4.png")};

    public RazorWindRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(RazorWind entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        PoseStack.Pose pose = poseStack.m_85850_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        ++entity.animationTime;
        float oldWith = (float)entity.oldBB.m_82362_();
        float width = entity.m_20205_();
        width = oldWith + (width - oldWith) * Math.min(partialTicks, 1.0f);
        this.drawSlash(pose, entity, bufferSource, light, width, 0);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    private void drawSlash(PoseStack.Pose pose, RazorWind entity, MultiBufferSource bufferSource, int light, float width, int offset) {
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity, offset)));
        VertexConsumer consumer2 = bufferSource.m_6299_(ModRenderType.wraith(this.getTextureLocation(entity, offset)));
        float halfWidth = width * 0.5f;
        ColorUtil colorUtil = new ColorUtil(ChatFormatting.WHITE);
        float alpha = 0.5f;
        consumer.m_252986_(poseMatrix, -halfWidth, -0.1f, -halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, halfWidth, -0.1f, -halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, halfWidth, -0.1f, halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, -halfWidth, -0.1f, halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer2.m_252986_(poseMatrix, -halfWidth, -0.1f, -halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer2.m_252986_(poseMatrix, halfWidth, -0.1f, -halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer2.m_252986_(poseMatrix, halfWidth, -0.1f, halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer2.m_252986_(poseMatrix, -halfWidth, -0.1f, halfWidth).m_85950_(colorUtil.red, colorUtil.green, colorUtil.blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(RazorWind entity) {
        int frame = entity.animationTime / 4 % TEXTURES.length;
        return TEXTURES[frame];
    }

    private ResourceLocation getTextureLocation(RazorWind entity, int offset) {
        int frame = (entity.animationTime / 6 + offset) % TEXTURES.length;
        return TEXTURES[frame];
    }
}

