/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.api.entities.IRM;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.RedstoneMonstrosityModel;
import com.Polarice3.Goety.config.MobsConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class RedstoneMonstrosityRenderer<T extends Mob>
extends MobRenderer<T, RedstoneMonstrosityModel<T>> {
    private static final ResourceLocation TEXTURES = Goety.location("textures/entity/servants/redstone_monstrosity/redstone_monstrosity.png");
    private static final ResourceLocation ACTIVE = Goety.location("textures/entity/servants/redstone_monstrosity/redstone_monstrosity_active.png");
    private static final ResourceLocation GLOW = Goety.location("textures/entity/servants/redstone_monstrosity/redstone_monstrosity_glow.png");

    public RedstoneMonstrosityRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new RedstoneMonstrosityModel(renderManagerIn.m_174023_(ModModelLayer.REDSTONE_MONSTROSITY)), 2.0f);
        this.m_115326_((RenderLayer)new GlowEyesLayer(this));
        this.m_115326_(new ActiveLayer(this));
        this.m_115326_(new NonActiveLayer(this));
        this.m_115326_(new RMBandsLayer(this));
        this.m_115326_(new RMEmissiveLayer(this, GLOW, (entity, partialTicks, ageInTicks) -> !entity.m_21224_() && ((IRM)entity).getBigGlow() > 0.0f ? ((IRM)entity).getBigGlow() : 0.0f));
        this.m_115326_(new RMEmissiveLayer(this, ACTIVE, (entity, partialTicks, ageInTicks) -> !((IRM)entity).isActivating() && !entity.m_21224_() && ((IRM)entity).getBigGlow() <= 0.0f ? ((IRM)entity).getMinorGlow() : 0.0f));
    }

    public void m_7392_(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        if (((IRM)pEntity).getDeathTime() >= 24) {
            pMatrixStack.m_85836_();
            boolean flag = ((Mob)pEntity).f_20916_ > 0;
            float f = Mth.m_14189_((float)pPartialTicks, (float)((Mob)pEntity).f_20884_, (float)((Mob)pEntity).f_20883_);
            float f1 = Mth.m_14189_((float)pPartialTicks, (float)((Mob)pEntity).f_20886_, (float)((Mob)pEntity).f_20885_);
            float f2 = f1 - f;
            float f6 = Mth.m_14179_((float)pPartialTicks, (float)((Mob)pEntity).f_19860_, (float)pEntity.m_146909_());
            float f71 = this.m_6930_((LivingEntity)pEntity, pPartialTicks);
            this.m_7523_((LivingEntity)pEntity, pMatrixStack, f71, f, pPartialTicks);
            pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.m_7546_((LivingEntity)pEntity, pMatrixStack, pPartialTicks);
            pMatrixStack.m_85837_(0.0, (double)-1.501f, 0.0);
            ((RedstoneMonstrosityModel)this.f_115290_).m_6839_((Entity)pEntity, 0.0f, 0.0f, pPartialTicks);
            ((RedstoneMonstrosityModel)this.f_115290_).setupAnim(pEntity, 0.0f, 0.0f, f71, f2, f6);
            float f10 = Mth.m_14036_((float)(1.0f - (float)((((IRM)pEntity).getDeathTime() - 24) * 2) / 100.0f), (float)0.0f, (float)1.0f);
            VertexConsumer ivertexbuilder1 = pBuffer.m_6299_(RenderType.m_110479_((ResourceLocation)this.getTextureLocation(pEntity)));
            ((RedstoneMonstrosityModel)this.f_115290_).m_7695_(pMatrixStack, ivertexbuilder1, pPackedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), f10, f10, f10, 1.0f);
            pMatrixStack.m_85849_();
        }
    }

    @Nullable
    protected RenderType getRenderType(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        if (((IRM)p_230496_1_).getDeathTime() >= 24) {
            return RenderType.m_173235_((ResourceLocation)TEXTURES);
        }
        return super.m_7225_(p_230496_1_, p_230496_2_, p_230496_3_, p_230496_4_);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURES;
    }

    public static class GlowEyesLayer<T extends Mob, M extends RedstoneMonstrosityModel<T>>
    extends EyesLayer<T, M> {
        private static final ResourceLocation EYES = Goety.location("textures/entity/servants/redstone_monstrosity/redstone_monstrosity_eyes.png");

        public GlowEyesLayer(RenderLayerParent<T, M> p_116981_) {
            super(p_116981_);
        }

        public void render(PoseStack p_116983_, MultiBufferSource p_116984_, int p_116985_, T p_116986_, float p_116987_, float p_116988_, float p_116989_, float p_116990_, float p_116991_, float p_116992_) {
            super.m_6494_(p_116983_, p_116984_, p_116985_, p_116986_, p_116987_, p_116988_, p_116989_, p_116990_, p_116991_, p_116992_);
        }

        public RenderType m_5708_() {
            return RenderType.m_110488_((ResourceLocation)EYES);
        }
    }

    public static class ActiveLayer<T extends Mob, M extends RedstoneMonstrosityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation LOCATION = Goety.location("textures/entity/servants/redstone_monstrosity/redstone_monstrosity_lines.png");

        public ActiveLayer(RenderLayerParent<T, M> p_116981_) {
            super(p_116981_);
        }

        public void render(PoseStack p_116983_, MultiBufferSource p_116984_, int p_116985_, T p_116986_, float p_116987_, float p_116988_, float p_116989_, float p_116990_, float p_116991_, float p_116992_) {
            if (!((IRM)p_116986_).isActivating() && !p_116986_.m_21224_()) {
                VertexConsumer vertexconsumer = p_116984_.m_6299_(this.renderType());
                ((RedstoneMonstrosityModel)this.m_117386_()).m_7695_(p_116983_, vertexconsumer, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        public RenderType renderType() {
            return RenderType.m_110458_((ResourceLocation)LOCATION);
        }
    }

    public static class NonActiveLayer<T extends Mob, M extends RedstoneMonstrosityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation NON_ACTIVE = Goety.location("textures/entity/servants/redstone_monstrosity/redstone_monstrosity_non_active.png");

        public NonActiveLayer(RenderLayerParent<T, M> p_116981_) {
            super(p_116981_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T monstrosity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (((IRM)monstrosity).isActivating()) {
                VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)NON_ACTIVE));
                ((RedstoneMonstrosityModel)this.m_117386_()).m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public static class RMBandsLayer<T extends Mob>
    extends RenderLayer<T, RedstoneMonstrosityModel<T>> {
        private static final ResourceLocation TEXTURES = Goety.location("textures/entity/servants/redstone_monstrosity/redstone_monstrosity_bands.png");

        public RMBandsLayer(RenderLayerParent<T, RedstoneMonstrosityModel<T>> p_i50919_1_) {
            super(p_i50919_1_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!((IRM)entitylivingbaseIn).isHostile() && ((Boolean)MobsConfig.RedstoneMonstrosityTexture.get()).booleanValue()) {
                RMBandsLayer.m_117376_((EntityModel)this.m_117386_(), (ResourceLocation)TEXTURES, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public static class RMEmissiveLayer<T extends Mob, M extends RedstoneMonstrosityModel<T>>
    extends RenderLayer<T, M> {
        private final ResourceLocation texture;
        private final AlphaFunction<T> alphaFunction;

        public RMEmissiveLayer(RenderLayerParent<T, M> p_234885_, ResourceLocation p_234886_, AlphaFunction<T> p_234887_) {
            super(p_234885_);
            this.texture = p_234886_;
            this.alphaFunction = p_234887_;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.m_20145_()) {
                VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_234338_((ResourceLocation)this.texture));
                ((RedstoneMonstrosityModel)this.m_117386_()).m_7695_(matrixStackIn, vertexconsumer, packedLightIn, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, this.alphaFunction.apply(entity, partialTicks, ageInTicks));
            }
        }

        public static interface AlphaFunction<T extends Mob> {
            public float apply(T var1, float var2, float var3);
        }
    }
}

