/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.BlackBeastAnimations;
import com.Polarice3.Goety.common.entities.ally.BlackBeast;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Pose;

public class BlackBeastModel<T extends BlackBeast>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart stalker;
    private final ModelPart body;
    private final ModelPart pelvis;
    private final ModelPart upper;
    private final ModelPart torso;
    private final ModelPart neck;
    private final ModelPart head;
    private final List<ModelPart> parts;

    public BlackBeastModel(ModelPart root) {
        this.root = root;
        this.stalker = root.m_171324_("stalker");
        this.body = this.stalker.m_171324_("body");
        this.pelvis = this.body.m_171324_("pelvis");
        this.upper = this.pelvis.m_171324_("upper");
        this.torso = this.upper.m_171324_("torso");
        this.neck = this.torso.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.parts = (List)root.m_171331_().filter(p_170824_ -> !p_170824_.m_171326_()).collect(ImmutableList.toImmutableList());
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition stalker = partdefinition.m_171599_("stalker", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = stalker.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)3.0f));
        PartDefinition pelvis = body.m_171599_("pelvis", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)1.5f));
        PartDefinition cube_r1 = pelvis.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-7.0f, -8.0f, -1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)2.0f, (float)-3.5f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition upper = pelvis.m_171599_("upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition torso = upper.m_171599_("torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)3.0f, (float)-4.5f));
        PartDefinition actual_torso = torso.m_171599_("actual_torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = actual_torso.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-13.0f, -10.0f, -1.0f, 14.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition fur = torso.m_171599_("fur", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-6.0f, (float)-13.4f, (float)1.1f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = fur.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(78, 17).m_171488_(0.0f, -7.0f, -7.0f, 0.0f, 14.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = fur.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(78, 43).m_171488_(-7.0f, -3.0f, 0.0f, 14.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.9853f, (float)2.359f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = fur.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(78, 43).m_171488_(-7.0f, -3.0f, 0.0f, 14.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.9853f, (float)1.359f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition neck = torso.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition cube_r6 = neck.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(74, 49).m_171488_(-6.0f, -2.0f, -1.0f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)-5.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = neck.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(54, 33).m_171488_(-5.0f, -8.0f, -1.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-2.0f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition neck_chain = neck.m_171599_("neck_chain", CubeListBuilder.m_171558_().m_171514_(102, 23).m_171488_(-1.5f, 0.0718f, 0.1762f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.75f, (float)-5.75f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -8.0f, -4.0f, 9.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(34, 1).m_171488_(-2.5f, -5.0f, -11.0f, 5.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-9.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171480_().m_171488_(-2.0f, -5.0f, -0.5f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-7.5f, (float)-0.5f, (float)-0.4363f, (float)0.0f, (float)0.4363f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-1.0f, -5.0f, -0.5f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-7.5f, (float)-0.5f, (float)-0.4363f, (float)0.0f, (float)-0.4363f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(51, 0).m_171488_(-2.0f, -1.0f, -6.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        PartDefinition right_arm = upper.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)-8.0f, (float)-7.0f));
        PartDefinition right_upper = right_arm.m_171599_("right_upper", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171488_(-7.0f, -1.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(74, 49).m_171488_(-7.5f, 4.0f, -3.5f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition arm_chain = right_upper.m_171599_("arm_chain", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.1257f, (float)5.9357f, (float)3.5f));
        PartDefinition cube_r8 = arm_chain.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(102, 23).m_171488_(-1.3743f, -2.9357f, 0.0f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.75f, (float)1.25f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition right_hand = right_upper.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(72, 0).m_171488_(-4.0f, -4.2195f, -14.1338f, 8.0f, 8.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(106, 41).m_171480_().m_171488_(-4.5f, -4.7195f, -6.1338f, 9.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)12.0f, (float)0.5f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition r_thumb = right_hand.m_171599_("r_thumb", CubeListBuilder.m_171558_().m_171514_(71, 9).m_171488_(-0.5f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-0.7195f, (float)-11.6338f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition r_fingers = right_hand.m_171599_("r_fingers", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-2.0f, (float)-0.2195f, (float)-13.6338f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition r_back_finger = r_fingers.m_171599_("r_back_finger", CubeListBuilder.m_171558_().m_171514_(72, 23).m_171488_(0.0f, -1.4695f, -1.1338f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)).m_171514_(86, 23).m_171488_(4.0f, -1.4695f, -1.1338f, 5.0f, 3.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)1.9695f, (float)-0.3662f));
        PartDefinition r_front_finger = r_fingers.m_171599_("r_front_finger", CubeListBuilder.m_171558_().m_171514_(72, 23).m_171488_(0.0f, -1.4695f, -1.1338f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)).m_171514_(86, 23).m_171488_(4.0f, -1.4695f, -1.1338f, 5.0f, 3.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)-2.0305f, (float)-0.3662f));
        PartDefinition left_arm = upper.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)-8.0f, (float)-7.0f));
        PartDefinition left_upper = left_arm.m_171599_("left_upper", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171480_().m_171488_(1.0f, -1.0f, -3.0f, 6.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(74, 49).m_171480_().m_171488_(0.5f, 4.0f, -3.5f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition left_hand = left_upper.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(72, 0).m_171480_().m_171488_(-4.0f, -4.2195f, -14.1338f, 8.0f, 8.0f, 15.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(106, 41).m_171480_().m_171488_(-4.5f, -4.7195f, -6.1338f, 9.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.0f, (float)12.0f, (float)0.5f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition l_thumb = left_hand.m_171599_("l_thumb", CubeListBuilder.m_171558_().m_171514_(71, 9).m_171480_().m_171488_(-4.5f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-0.7195f, (float)-11.6338f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition l_fingers = left_hand.m_171599_("l_fingers", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)3.0f, (float)-0.2195f, (float)-13.6338f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition l_back_finger = l_fingers.m_171599_("l_back_finger", CubeListBuilder.m_171558_().m_171514_(72, 23).m_171480_().m_171488_(-4.0f, -1.4695f, -1.1338f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(86, 23).m_171480_().m_171488_(-9.0f, -1.4695f, -1.1338f, 5.0f, 3.0f, 3.0f, new CubeDeformation(-0.25f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)1.9695f, (float)-0.3662f));
        PartDefinition l_front_finger = l_fingers.m_171599_("l_front_finger", CubeListBuilder.m_171558_().m_171514_(72, 23).m_171480_().m_171488_(-4.0f, -1.4695f, -1.1338f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(86, 23).m_171480_().m_171488_(-9.0f, -1.4695f, -1.1338f, 5.0f, 3.0f, 3.0f, new CubeDeformation(-0.25f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-2.0305f, (float)-0.3662f));
        PartDefinition tail = pelvis.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        PartDefinition upper_tail = tail.m_171599_("upper_tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)1.0f));
        PartDefinition cube_r9 = upper_tail.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(46, 51).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-2.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition lower_tail = tail.m_171599_("lower_tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)5.5f, (float)8.0f));
        PartDefinition cube_r10 = lower_tail.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(62, 52).m_171488_(-1.0f, -0.7321f, -1.2679f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-2.0f, (float)1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = stalker.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-14.0f, (float)0.0f));
        PartDefinition right_thigh = right_leg.m_171599_("right_thigh", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171488_(-3.5f, -3.5f, -2.0f, 6.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition right_shin = right_leg.m_171599_("right_shin", CubeListBuilder.m_171558_().m_171514_(30, 51).m_171488_(-2.0f, -3.0f, -1.0f, 5.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(102, 52).m_171488_(-2.5f, 0.0f, -1.5f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)7.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition right_toe = right_shin.m_171599_("right_toe", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-0.75f));
        PartDefinition cube_r11 = right_toe.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-5.0f, -3.0f, -1.5f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)2.0f, (float)-5.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = stalker.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-14.0f, (float)0.0f));
        PartDefinition left_thigh = left_leg.m_171599_("left_thigh", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171480_().m_171488_(-2.5f, -3.5f, -2.0f, 6.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition left_shin = left_leg.m_171599_("left_shin", CubeListBuilder.m_171558_().m_171514_(30, 51).m_171488_(-3.0f, -3.0f, -1.0f, 5.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(102, 52).m_171488_(-3.5f, 0.0f, -1.5f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)7.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition shin_chain = left_shin.m_171599_("shin_chain", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)2.0f, (float)2.5f));
        PartDefinition cube_r12 = shin_chain.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(102, 23).m_171488_(-1.5f, -3.0f, 0.0f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.75f, (float)1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_toe = left_shin.m_171599_("left_toe", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-0.75f));
        PartDefinition cube_r13 = left_toe.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-5.0f, -3.0f, -1.0f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)2.0f, (float)-5.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!(((BlackBeast)entity).isSummoning() || ((BlackBeast)entity).isMeleeAttacking() || entity.m_21224_())) {
            this.animateHeadLookTarget(entity, netHeadYaw, headPitch);
        }
        this.m_233381_(((BlackBeast)entity).idleAnimationState, BlackBeastAnimations.IDLE, ageInTicks);
        if (((BlackBeast)entity).canAnimateMove()) {
            if (entity.m_20069_()) {
                this.m_267799_(BlackBeastAnimations.SWIM, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            } else if (entity.m_20089_() == Pose.CROUCHING) {
                this.m_267799_(BlackBeastAnimations.CROUCH_WALK, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            } else {
                this.m_267799_(BlackBeastAnimations.WALK, limbSwing, limbSwingAmount, 2.5f, 20.0f);
            }
        }
        this.m_233381_(((BlackBeast)entity).attackAnimationState, ((BlackBeast)entity).leftSwiped ? BlackBeastAnimations.ATTACK : BlackBeastAnimations.ATTACK2, ageInTicks);
        this.m_233381_(((BlackBeast)entity).roarAnimationState, BlackBeastAnimations.ROAR, ageInTicks);
        this.m_233381_(((BlackBeast)entity).sitAnimationState, BlackBeastAnimations.SIT, ageInTicks);
        this.m_233381_(((BlackBeast)entity).toSitAnimationState, BlackBeastAnimations.TO_SIT, ageInTicks);
        this.m_233381_(((BlackBeast)entity).toStandAnimationState, BlackBeastAnimations.TO_STAND, ageInTicks);
        this.m_233381_(((BlackBeast)entity).deathAnimationState, BlackBeastAnimations.DEATH, ageInTicks);
    }

    private void animateHeadLookTarget(T entity, float netHeadYaw, float headPitch) {
        this.head.f_104205_ = ((BlackBeast)entity).getHeadRollAngle(Minecraft.m_91087_().getPartialTick());
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public ModelPart getRandomModelPart(RandomSource p_233439_) {
        return this.parts.get(p_233439_.m_188503_(this.parts.size()));
    }
}

