/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.SnarelingAnimations;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractSnareling;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SnarelingModel<T extends AbstractSnareling>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart snareling;
    private final ModelPart body;
    private final ModelPart upper;
    private final ModelPart mouth;
    private final ModelPart top;
    private final ModelPart bottom;
    private final ModelPart head;
    private final ModelPart right_arm;
    private final ModelPart upper_right;
    private final ModelPart lower_right;
    private final ModelPart left_arm;
    private final ModelPart upper_left;
    private final ModelPart lower_left;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public SnarelingModel(ModelPart root) {
        this.root = root;
        this.snareling = root.m_171324_("snareling");
        this.body = this.snareling.m_171324_("body");
        this.upper = this.body.m_171324_("upper");
        this.mouth = this.upper.m_171324_("mouth");
        this.top = this.mouth.m_171324_("top");
        this.bottom = this.mouth.m_171324_("bottom");
        this.head = this.upper.m_171324_("head");
        this.right_arm = this.body.m_171324_("right_arm");
        this.upper_right = this.right_arm.m_171324_("upper_right");
        this.lower_right = this.right_arm.m_171324_("lower_right");
        this.left_arm = this.body.m_171324_("left_arm");
        this.upper_left = this.left_arm.m_171324_("upper_left");
        this.lower_left = this.left_arm.m_171324_("lower_left");
        this.right_leg = this.snareling.m_171324_("right_leg");
        this.left_leg = this.snareling.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition snareling = partdefinition.m_171599_("snareling", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = snareling.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)1.5f, (float)-24.0f, (float)-3.45f, (float)-0.2182f, (float)0.0f, (float)0.0349f));
        PartDefinition upper = body.m_171599_("upper", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-5.5f, -12.0f, -5.45f, 11.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(38, 14).m_171488_(-5.5f, -12.0f, -5.45f, 11.0f, 12.0f, 8.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)-1.5f, (float)0.0f, (float)3.45f));
        PartDefinition sack = upper.m_171599_("sack", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.5f, -4.5f, 0.5f, 9.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)2.05f));
        PartDefinition mouth = upper.m_171599_("mouth", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)0.0f, (float)-3.45f));
        PartDefinition top = mouth.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(38, 34).m_171488_(-4.5f, -1.5f, 0.0f, 9.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-7.75f, (float)-2.025f));
        PartDefinition bottom = mouth.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(38, 37).m_171488_(-4.5f, -1.5f, 0.0f, 9.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-4.25f, (float)-2.025f));
        PartDefinition head = upper.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -8.0f, -3.5f, 9.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)-0.95f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -0.5f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)-3.6f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-7.0f, (float)-11.0f, (float)2.0f, (float)0.2182f, (float)0.0f, (float)-0.0349f));
        PartDefinition upper_right = right_arm.m_171599_("upper_right", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171488_(-1.0f, -36.0f, -1.0f, 2.0f, 36.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)35.0f, (float)0.0f));
        PartDefinition lower_right = right_arm.m_171599_("lower_right", CubeListBuilder.m_171558_().m_171514_(8, 35).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)34.0f, (float)1.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)4.0f, (float)-11.0f, (float)2.0f, (float)0.192f, (float)0.0f, (float)-0.0436f));
        PartDefinition upper_left = left_arm.m_171599_("upper_left", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171488_(-1.0f, -36.0f, -1.0f, 2.0f, 36.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)35.0f, (float)0.0f));
        PartDefinition lower_left = left_arm.m_171599_("lower_left", CubeListBuilder.m_171558_().m_171514_(8, 35).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)34.0f, (float)1.0f));
        PartDefinition right_leg = snareling.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)-24.0f, (float)-1.45f, (float)-0.3054f, (float)0.3054f, (float)-0.0436f));
        PartDefinition left_leg = snareling.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-24.0f, (float)-1.45f, (float)-0.3054f, (float)-0.3054f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        this.m_233381_(((AbstractSnareling)entity).idleAnimationState, SnarelingAnimations.IDLE, ageInTicks);
        this.m_267799_(SnarelingAnimations.WALK, limbSwing, limbSwingAmount, 1.5f, 2.5f);
        this.m_233381_(((AbstractSnareling)entity).attackAnimationState, SnarelingAnimations.MELEE, ageInTicks);
        this.m_233381_(((AbstractSnareling)entity).shootAnimationState, SnarelingAnimations.SHOOT, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

