/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;

public class ChorusVineBlock
extends Block
implements IForgeShearable {
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.m_137448_());
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public ChorusVineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280170_().m_60910_().m_60977_().m_60978_(0.2f).m_60918_(SoundType.f_271239_).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), ChorusVineBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_57906_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_57906_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_57906_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_57906_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    public VoxelShape m_5940_(BlockState p_57897_, BlockGetter p_57898_, BlockPos p_57899_, CollisionContext p_57900_) {
        return this.shapesCache.get(p_57897_);
    }

    public boolean m_7420_(BlockState p_181239_, BlockGetter p_181240_, BlockPos p_181241_) {
        return true;
    }

    public boolean m_7898_(BlockState p_57861_, LevelReader p_57862_, BlockPos p_57863_) {
        return this.hasFaces(this.getUpdatedState(p_57861_, (BlockGetter)p_57862_, p_57863_));
    }

    private boolean hasFaces(BlockState p_57908_) {
        return this.countFaces(p_57908_) > 0;
    }

    private int countFaces(BlockState p_57910_) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)p_57910_.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter p_57888_, BlockPos p_57889_, Direction p_57890_) {
        if (p_57890_ == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = p_57889_.m_121945_(p_57890_);
        if (ChorusVineBlock.isAcceptableNeighbour(p_57888_, blockpos, p_57890_)) {
            return true;
        }
        if (p_57890_.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(p_57890_);
        BlockState blockstate = p_57888_.m_8055_(p_57889_.m_7495_());
        return blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter p_57854_, BlockPos p_57855_, Direction p_57856_) {
        return MultifaceBlock.m_153829_((BlockGetter)p_57854_, (Direction)p_57856_, (BlockPos)p_57855_, (BlockState)p_57854_.m_8055_(p_57855_));
    }

    private BlockState getUpdatedState(BlockState p_57902_, BlockGetter p_57903_, BlockPos p_57904_) {
        BlockPos blockpos = p_57904_.m_7495_();
        if (((Boolean)p_57902_.m_61143_((Property)UP)).booleanValue()) {
            p_57902_ = (BlockState)p_57902_.m_61124_((Property)UP, (Comparable)Boolean.valueOf(ChorusVineBlock.isAcceptableNeighbour(p_57903_, blockpos, Direction.DOWN)));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = ChorusVineBlock.getPropertyForFace(direction);
            if (!((Boolean)p_57902_.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(p_57903_, p_57904_, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = p_57903_.m_8055_(blockpos);
                }
                flag = blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            }
            p_57902_ = (BlockState)p_57902_.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return p_57902_;
    }

    public BlockState m_7417_(BlockState p_57875_, Direction p_57876_, BlockState p_57877_, LevelAccessor p_57878_, BlockPos p_57879_, BlockPos p_57880_) {
        if (p_57876_ == Direction.UP) {
            return super.m_7417_(p_57875_, p_57876_, p_57877_, p_57878_, p_57879_, p_57880_);
        }
        BlockState blockstate = this.getUpdatedState(p_57875_, (BlockGetter)p_57878_, p_57879_);
        return !this.hasFaces(blockstate) ? Blocks.f_50016_.m_49966_() : blockstate;
    }

    public void m_213898_(BlockState p_222655_, ServerLevel p_222656_, BlockPos p_222657_, RandomSource p_222658_) {
        BlockState blockstate2;
        BlockState blockstate1;
        BlockPos blockpos1;
        BlockState blockstate;
        if (p_222656_.m_46469_().m_46207_(GameRules.f_268705_) && p_222656_.f_46441_.m_188503_(4) == 0 && p_222656_.m_46749_(p_222657_) && p_222657_.m_123342_() > p_222656_.m_141937_() && ((blockstate = p_222656_.m_8055_(blockpos1 = p_222657_.m_7494_())).m_60795_() || blockstate.m_60713_((Block)this)) && (blockstate1 = blockstate.m_60795_() ? this.m_49966_() : blockstate) != (blockstate2 = this.copyRandomFaces(p_222655_, blockstate1, p_222658_)) && this.hasHorizontalConnection(blockstate2)) {
            p_222656_.m_7731_(blockpos1, blockstate2, 2);
        }
    }

    private BlockState copyRandomFaces(BlockState p_222651_, BlockState p_222652_, RandomSource p_222653_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!p_222653_.m_188499_() || !((Boolean)p_222651_.m_61143_((Property)(booleanproperty = ChorusVineBlock.getPropertyForFace(direction)))).booleanValue()) continue;
            p_222652_ = (BlockState)p_222652_.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return p_222652_;
    }

    private boolean hasHorizontalConnection(BlockState p_57912_) {
        return (Boolean)p_57912_.m_61143_((Property)NORTH) != false || (Boolean)p_57912_.m_61143_((Property)EAST) != false || (Boolean)p_57912_.m_61143_((Property)SOUTH) != false || (Boolean)p_57912_.m_61143_((Property)WEST) != false;
    }

    public boolean m_6864_(BlockState p_57858_, BlockPlaceContext p_57859_) {
        BlockState blockstate = p_57859_.m_43725_().m_8055_(p_57859_.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return this.countFaces(blockstate) < PROPERTY_BY_DIRECTION.size();
        }
        return super.m_6864_(p_57858_, p_57859_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_57849_) {
        BlockState blockstate = p_57849_.m_43725_().m_8055_(p_57849_.m_8083_());
        boolean flag = blockstate.m_60713_((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.m_49966_();
        for (Direction direction : p_57849_.m_6232_()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = ChorusVineBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)p_57849_.m_43725_(), p_57849_.m_8083_(), direction)) continue;
            return (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57882_) {
        p_57882_.m_61104_(new Property[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState m_6843_(BlockState p_57868_, Rotation p_57869_) {
        return switch (p_57869_) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_57868_.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57868_.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_57868_.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57868_.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_57868_.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57868_.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57868_.m_61143_((Property)SOUTH)));
            default -> p_57868_;
        };
    }

    public BlockState m_6943_(BlockState p_57865_, Mirror p_57866_) {
        return switch (p_57866_) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)p_57865_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_57865_.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_57865_.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)p_57865_.m_61124_((Property)EAST, (Comparable)((Boolean)p_57865_.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_57865_.m_61143_((Property)EAST)));
            default -> super.m_6943_(p_57865_, p_57866_);
        };
    }

    public static BooleanProperty getPropertyForFace(Direction p_57884_) {
        return PROPERTY_BY_DIRECTION.get(p_57884_);
    }
}

