/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.entities.VoidShrineBlockEntity;
import com.Polarice3.Goety.common.items.ModItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class VoidShrineBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape SHAPE_BASE_2 = Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    public static final VoxelShape SHAPE_PILLAR = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape SHAPE_TOP = Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BASE_2, SHAPE_PILLAR, SHAPE_TOP});
    public static final IntegerProperty CHARGE = BlockStateProperties.f_61389_;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;

    public VoidShrineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56742_).m_60953_(p_50847_ -> VoidShrineBlock.getScaledChargeLevel(p_50847_, 15)).m_60913_(-1.0f, 3600000.0f).m_222994_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CHARGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.FALSE));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21205_();
        if (itemstack.m_150930_((Item)ModItems.VOID_SHARD.get()) && VoidShrineBlock.canBeCharged(state)) {
            VoidShrineBlock.charge((Entity)player, world, pos, state);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof VoidShrineBlockEntity) {
            VoidShrineBlockEntity pedestal = (VoidShrineBlockEntity)blockEntity;
            pedestal.getCapability(ForgeCapabilities.ITEM_HANDLER, hit.m_82434_()).ifPresent(handler -> {
                ItemStack itemStack = handler.getStackInSlot(0);
                if (!(player.m_6144_() || player.m_6047_() || itemStack.m_41619_())) {
                    if (heldItem.m_41619_()) {
                        player.m_21008_(hand, handler.extractItem(0, 64, false));
                    } else {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)handler.extractItem(0, 64, false));
                    }
                    world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pedestal.m_6596_();
                } else if ((Integer)state.m_61143_((Property)CHARGE) < 4) {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.shrine.shard"), true);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity tileentity = pLevel.m_7702_(pPos);
            if (tileentity instanceof VoidShrineBlockEntity) {
                tileentity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> VoidShrineBlock.dropInventoryItems(tileentity.m_58904_(), tileentity.m_58899_(), handler));
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemHandler.getStackInSlot(i));
        }
    }

    private static boolean canBeCharged(BlockState p_55895_) {
        return (Integer)p_55895_.m_61143_((Property)CHARGE) < 4;
    }

    public static void charge(@Nullable Entity p_270997_, Level p_270172_, BlockPos p_270534_, BlockState p_270661_) {
        BlockState blockstate = (BlockState)p_270661_.m_61124_((Property)CHARGE, (Comparable)Integer.valueOf((Integer)p_270661_.m_61143_((Property)CHARGE) + 1));
        p_270172_.m_7731_(p_270534_, blockstate, 3);
        p_270172_.m_220407_(GameEvent.f_157792_, p_270534_, GameEvent.Context.m_223719_((Entity)p_270997_, (BlockState)blockstate));
        p_270172_.m_6263_(null, (double)p_270534_.m_123341_() + 0.5, (double)p_270534_.m_123342_() + 0.5, (double)p_270534_.m_123343_() + 0.5, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55886_) {
        p_55886_.m_61104_(new Property[]{CHARGE, TRIGGERED, OCCUPIED});
    }

    public boolean m_7278_(BlockState p_55860_) {
        return true;
    }

    public static int getScaledChargeLevel(BlockState p_55862_, int p_55863_) {
        return Mth.m_14143_((float)((float)((Integer)p_55862_.m_61143_((Property)CHARGE)).intValue() / 4.0f * (float)p_55863_));
    }

    public int m_6782_(BlockState p_55870_, Level p_55871_, BlockPos p_55872_) {
        return VoidShrineBlock.getScaledChargeLevel(p_55870_, 15);
    }

    public RenderShape m_7514_(BlockState p_49753_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean m_7357_(BlockState p_55865_, BlockGetter p_55866_, BlockPos p_55867_, PathComputationType p_55868_) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new VoidShrineBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return (world, pos, state, blockEntity) -> {
            if (blockEntity instanceof VoidShrineBlockEntity) {
                VoidShrineBlockEntity blockEntity1 = (VoidShrineBlockEntity)blockEntity;
                blockEntity1.tick();
            }
        };
    }
}

