/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.client.particles.PortalShockwaveParticleOption;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModTicketTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class NightBeaconBlockEntity
extends BlockEntity {
    List<BeaconBeamSection> beamSections = Lists.newArrayList();
    private List<BeaconBeamSection> checkingBeamSections = Lists.newArrayList();
    private boolean daylightTrue;
    private boolean isNight;
    private boolean hasPortal;
    private boolean isActive;
    private int lastCheckY;
    public long ticketTime = 0L;

    public NightBeaconBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.NIGHT_BEACON.get(), p_155229_, p_155230_);
    }

    public static void tick(Level p_155108_, BlockPos p_155109_, BlockState p_155110_, NightBeaconBlockEntity p_155111_) {
        BlockPos blockpos;
        if (p_155108_ instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)p_155108_;
            ChunkPos chunkPos = world.m_46745_(p_155109_).m_7697_();
            if (--p_155111_.ticketTime <= 0L) {
                world.m_7726_().m_8387_(ModTicketTypes.BLOCK, chunkPos, 2, (Object)p_155109_);
                p_155111_.ticketTime = ModTicketTypes.BLOCK.m_9469_() - 1L;
            }
        }
        int i = p_155109_.m_123341_();
        int j = p_155109_.m_123342_();
        int k = p_155109_.m_123343_();
        if (p_155111_.lastCheckY < j) {
            blockpos = p_155109_;
            p_155111_.checkingBeamSections = Lists.newArrayList();
            p_155111_.lastCheckY = p_155109_.m_123342_() - 1;
        } else {
            blockpos = new BlockPos(i, p_155111_.lastCheckY + 1, k);
        }
        BeaconBeamSection beaconblockentity$beaconbeamsection = p_155111_.checkingBeamSections.isEmpty() ? null : p_155111_.checkingBeamSections.get(p_155111_.checkingBeamSections.size() - 1);
        int l = p_155108_.m_6924_(Heightmap.Types.WORLD_SURFACE, i, k);
        for (int i1 = 0; i1 < 10 && blockpos.m_123342_() <= l; ++i1) {
            BlockState blockstate = p_155108_.m_8055_(blockpos);
            float[] afloat = blockstate.getBeaconColorMultiplier((LevelReader)p_155108_, blockpos, p_155109_);
            if (afloat != null) {
                if (p_155111_.checkingBeamSections.size() <= 1) {
                    beaconblockentity$beaconbeamsection = new BeaconBeamSection();
                    p_155111_.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                } else if (beaconblockentity$beaconbeamsection != null) {
                    beaconblockentity$beaconbeamsection.increaseHeight();
                }
            } else {
                if (beaconblockentity$beaconbeamsection == null || blockstate.m_60739_((BlockGetter)p_155108_, blockpos) >= 15 && !blockstate.m_60713_(Blocks.f_50752_)) {
                    p_155111_.checkingBeamSections.clear();
                    p_155111_.lastCheckY = l;
                    break;
                }
                beaconblockentity$beaconbeamsection.increaseHeight();
            }
            blockpos = blockpos.m_7494_();
            ++p_155111_.lastCheckY;
        }
        if (p_155108_.m_46467_() % 20L == 0L && !p_155111_.beamSections.isEmpty()) {
            p_155111_.hasPortal = NightBeaconBlockEntity.hasPortal(p_155108_, p_155109_);
        }
        if (p_155108_.m_46467_() % 80L == 0L && p_155111_.isActive && !p_155111_.beamSections.isEmpty()) {
            NightBeaconBlockEntity.playSound(p_155108_, p_155109_, SoundEvents.f_11737_);
        }
        if (p_155108_.m_7654_() != null && p_155111_.isActive && !p_155111_.beamSections.isEmpty()) {
            for (ServerLevel serverLevel : p_155108_.m_7654_().m_129785_()) {
                long currentDay = serverLevel.m_46468_() / 24000L;
                if (currentDay % 8L != 0L) {
                    ++currentDay;
                }
                serverLevel.m_8615_(MathHelper.setDayNumberAndTime(currentDay, 18000L));
                for (ServerPlayer player : serverLevel.m_6907_()) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSetTimePacket(serverLevel.m_46467_(), serverLevel.m_46468_(), serverLevel.m_46469_().m_46207_(GameRules.f_46140_)));
                }
            }
        }
        if (p_155111_.lastCheckY >= l) {
            p_155111_.lastCheckY = p_155108_.m_141937_() - 1;
            p_155111_.beamSections = p_155111_.checkingBeamSections;
        }
        if (!p_155108_.f_46443_ && p_155108_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)p_155108_;
            if (!(p_155111_.isActive || serverLevel.m_6042_().m_63967_() || p_155111_.getBeamSections().isEmpty())) {
                NightBeaconBlockEntity.playSound(p_155108_, p_155109_, SoundEvents.f_11736_);
                serverLevel.m_8767_((ParticleOptions)new PortalShockwaveParticleOption(), (double)((float)i + 0.5f), (double)j, (double)((float)k + 0.5f), 0, 0.0, 0.0, 0.0, 0.0);
                p_155111_.isActive = true;
            } else if (p_155111_.isActive && p_155111_.getBeamSections().isEmpty()) {
                NightBeaconBlockEntity.playSound(p_155108_, p_155109_, SoundEvents.f_11738_);
                p_155111_.isActive = false;
            }
        }
    }

    private static boolean hasPortal(Level level, BlockPos blockPos) {
        return level.m_8055_(blockPos.m_7495_().m_7495_()).m_60713_(Blocks.f_50142_) && (Boolean)MainConfig.EnableNightBeacon.get() != false;
    }

    public void setDayLight(boolean daylightTrue) {
        this.daylightTrue = daylightTrue;
    }

    public void m_7651_() {
        if (this.f_58857_ != null) {
            NightBeaconBlockEntity.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11738_);
            if (((Boolean)MainConfig.EnableNightBeacon.get()).booleanValue() && this.f_58857_.m_7654_() != null && this.isActive && !this.beamSections.isEmpty()) {
                for (ServerLevel serverLevel : this.f_58857_.m_7654_().m_129785_()) {
                    long currentDay = serverLevel.m_46468_() / 24000L;
                    serverLevel.m_8615_(MathHelper.setDayNumberAndTime(currentDay, 23000L));
                    for (ServerPlayer player : serverLevel.m_6907_()) {
                        player.f_8906_.m_9829_((Packet)new ClientboundSetTimePacket(serverLevel.m_46467_(), serverLevel.m_46468_(), serverLevel.m_46469_().m_46207_(GameRules.f_46140_)));
                    }
                }
            }
        }
        super.m_7651_();
    }

    public static void playSound(Level p_155104_, BlockPos p_155105_, SoundEvent p_155106_) {
        p_155104_.m_5594_((Player)null, p_155105_, p_155106_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public List<BeaconBeamSection> getBeamSections() {
        return !this.hasPortal ? ImmutableList.of() : this.beamSections;
    }

    public void m_142466_(CompoundTag p_155113_) {
        super.m_142466_(p_155113_);
        this.daylightTrue = p_155113_.m_128471_("daylightTrue");
        this.isNight = p_155113_.m_128471_("isNight");
        this.hasPortal = p_155113_.m_128471_("hasPortal");
        this.isActive = p_155113_.m_128471_("isActive");
    }

    protected void m_183515_(CompoundTag p_187463_) {
        super.m_183515_(p_187463_);
        p_187463_.m_128379_("daylightTrue", this.daylightTrue);
        p_187463_.m_128379_("isNight", this.isNight);
        p_187463_.m_128379_("hasPortal", this.hasPortal);
        p_187463_.m_128379_("isActive", this.isActive);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
        super.onDataPacket(net, pkt);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public void m_142339_(Level p_155091_) {
        super.m_142339_(p_155091_);
        this.lastCheckY = p_155091_.m_141937_() - 1;
    }

    public static class BeaconBeamSection {
        private int height = 1;

        protected void increaseHeight() {
            ++this.height;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

