/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.OminousIdolBlock;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.OwnedBlockEntity;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.items.block.OminousIdolBlockItem;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.ModTicketTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class OminousIdolBlockEntity
extends OwnedBlockEntity {
    public static String ILLAGER_LIST = OminousIdolBlockItem.ILLAGER_LIST;
    public static String CLIENT_ID_LIST = "client_id_list";
    public List<RaiderServant> illagers = new ArrayList<RaiderServant>();
    public List<UUID> uuids = new ArrayList<UUID>();
    public List<Integer> ids = new ArrayList<Integer>();
    public int clientCount = 0;
    private CursedCageBlockEntity cursedCageTile;
    public long ticketTime = 0L;
    public boolean isEmpty = false;

    public OminousIdolBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.OMINOUS_IDOL.get(), p_155229_, p_155230_);
    }

    public void tick() {
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                if (!this.uuids.isEmpty()) {
                    ChunkPos chunkPos = world.m_46745_(this.f_58858_).m_7697_();
                    if (--this.ticketTime <= 0L) {
                        world.m_7726_().m_8387_(ModTicketTypes.BLOCK, chunkPos, 2, (Object)this.f_58858_);
                        this.ticketTime = ModTicketTypes.BLOCK.m_9469_() - 1L;
                    }
                    this.uuids.removeIf(uuid -> {
                        LivingEntity entity = EntityFinder.getLivingEntityByUuiD(uuid);
                        if (!(entity instanceof RaiderServant)) {
                            return true;
                        }
                        RaiderServant illagerServant = (RaiderServant)entity;
                        if (!illagerServant.m_6084_() || illagerServant.getIdol() != null && illagerServant.getIdol() != this) {
                            this.illagers.remove(illagerServant);
                            this.markUpdated();
                            return true;
                        }
                        return false;
                    });
                    for (UUID uuid2 : this.uuids) {
                        RaiderServant illagerServant;
                        LivingEntity entity;
                        if (uuid2 == null || !((entity = EntityFinder.getLivingEntityByUuiD(uuid2)) instanceof RaiderServant) || this.illagers.contains(illagerServant = (RaiderServant)entity)) continue;
                        this.illagers.add(illagerServant);
                    }
                    if (!this.getIllagers().isEmpty()) {
                        for (RaiderServant raider : this.getIllagers()) {
                            if (raider.m_6084_() && raider.getIdol() == this && !this.ids.contains(raider.m_19879_())) {
                                this.ids.add(raider.m_19879_());
                                this.markUpdated();
                            }
                            if (BlockFinder.samePos(raider.getRevivePos(), this.m_58899_())) continue;
                            raider.setRevivePos(this.m_58899_());
                            raider.setReviveDim(this.f_58857_.m_46472_());
                        }
                    }
                }
                if (!this.ids.isEmpty()) {
                    this.isEmpty = false;
                    if (this.ids.removeIf(integer -> {
                        Entity entity = this.f_58857_.m_6815_(integer.intValue());
                        if (entity instanceof RaiderServant) {
                            RaiderServant raider = (RaiderServant)entity;
                            return !raider.m_6084_();
                        }
                        return true;
                    })) {
                        this.markUpdated();
                    }
                } else if (!this.isEmpty) {
                    this.markUpdated();
                    this.isEmpty = true;
                }
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)OminousIdolBlock.POWERED, (Comparable)Boolean.valueOf(this.checkCage() && !this.getIllagers().isEmpty())), 3);
            }
            this.clientCount = this.ids.size();
        }
    }

    public List<RaiderServant> getIllagers() {
        return this.illagers;
    }

    public void addIllager(RaiderServant raider) {
        if (!this.uuids.contains(raider.m_20148_())) {
            this.uuids.add(raider.m_20148_());
        }
    }

    public void removeIllager(RaiderServant raider) {
        this.uuids.remove(raider.m_20148_());
    }

    public List<UUID> getUuids() {
        return this.uuids;
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    public int getClientCount() {
        return this.clientCount;
    }

    private boolean checkCage() {
        BlockEntity tileentity;
        BlockPos pos;
        BlockState blockState;
        if (this.f_58857_ != null && (blockState = this.f_58857_.m_8055_(pos = this.m_58899_().m_7495_())).m_60713_((Block)ModBlocks.CURSED_CAGE_BLOCK.get()) && (tileentity = this.f_58857_.m_7702_(pos)) instanceof CursedCageBlockEntity) {
            this.cursedCageTile = (CursedCageBlockEntity)tileentity;
            return !this.cursedCageTile.getItem().m_41619_();
        }
        return false;
    }

    public int getSoulEnergy() {
        if (this.f_58857_ != null && this.cursedCageTile != null) {
            return this.cursedCageTile.getSouls();
        }
        return 0;
    }

    public void siphonSoulEnergy(int souls) {
        if (this.f_58857_ != null && this.cursedCageTile != null) {
            this.cursedCageTile.decreaseSouls(souls);
        }
    }

    @Override
    public void readNetwork(CompoundTag tag) {
        int i;
        ListTag list;
        super.readNetwork(tag);
        if (tag.m_128441_(ILLAGER_LIST)) {
            list = tag.m_128437_(ILLAGER_LIST, 8);
            for (i = 0; i < list.size(); ++i) {
                UUID uuid = UUID.fromString(list.m_128778_(i));
                if (this.uuids.contains(uuid)) continue;
                this.uuids.add(uuid);
            }
        }
        if (!this.ids.isEmpty()) {
            this.ids.clear();
        }
        if (tag.m_128441_(CLIENT_ID_LIST)) {
            list = tag.m_128437_(CLIENT_ID_LIST, 3);
            for (i = 0; i < list.size(); ++i) {
                if (!this.ids.isEmpty() && this.ids.contains(list.m_128763_(i))) continue;
                this.ids.add(list.m_128763_(i));
            }
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag tag) {
        ListTag nbttaglist;
        int i;
        super.writeNetwork(tag);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        if (tag.m_128441_(ILLAGER_LIST)) {
            for (i = 0; i < tag.m_128437_(ILLAGER_LIST, 8).size(); ++i) {
                list.add(tag.m_128437_(ILLAGER_LIST, 8).m_128778_(i));
            }
        }
        if (!this.uuids.isEmpty()) {
            for (UUID uuid : this.uuids) {
                if (list.contains(uuid.toString())) continue;
                nbttaglist = new ListTag();
                if (tag.m_128441_(ILLAGER_LIST)) {
                    nbttaglist = tag.m_128437_(ILLAGER_LIST, 8);
                }
                nbttaglist.add((Object)StringTag.m_129297_((String)uuid.toString()));
                tag.m_128365_(ILLAGER_LIST, (Tag)nbttaglist);
            }
        }
        if (tag.m_128441_(CLIENT_ID_LIST)) {
            for (i = 0; i < tag.m_128437_(CLIENT_ID_LIST, 3).size(); ++i) {
                list2.add(tag.m_128437_(CLIENT_ID_LIST, 3).m_128763_(i));
            }
        }
        if (!this.ids.isEmpty()) {
            for (Integer integer : this.ids) {
                if (list2.contains(integer)) continue;
                nbttaglist = new ListTag();
                if (tag.m_128441_(CLIENT_ID_LIST)) {
                    nbttaglist = tag.m_128437_(CLIENT_ID_LIST, 3);
                }
                nbttaglist.add((Object)IntTag.m_128679_((int)integer));
                tag.m_128365_(CLIENT_ID_LIST, (Tag)nbttaglist);
            }
        }
        return tag;
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }
}

