/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.IEnchantedBlock;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.SculkGrowerBlock;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.config.MainConfig;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class SculkGrowerBlockEntity
extends ModBlockEntity
implements IEnchantedBlock {
    private CursedCageBlockEntity cursedCageTile;
    private int growCharges = -1;
    private int decayTimer = 100;
    private final List<BlockPos> growablePlantPos = Lists.newArrayList();
    private final List<BlockPos> totalPlantPos = Lists.newArrayList();
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public SculkGrowerBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SCULK_GROWER.get(), p_155229_, p_155230_);
    }

    @Override
    public Object2IntMap<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.checkCage()) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkGrowerBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkGrowerBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.scanTotalPlants();
            if (this.f_58857_.m_46467_() % 5L == 0L) {
                this.findPlants();
            }
            if (this.growCharges <= 0) {
                if (!this.growablePlantPos.isEmpty() && this.checkCage() && this.takeSouls()) {
                    this.growCharges = (Integer)MainConfig.SculkGrowerCharge.get();
                }
            } else {
                this.growPlants();
            }
            if (this.totalPlantPos.isEmpty() || this.decayTimer <= 0) {
                this.decayCharges();
            }
        }
    }

    public void commonTick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.growCharges <= 0) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkGrowerBlock.CHARGED, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkGrowerBlock.CHARGED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    public void decayCharges() {
        Level level;
        if (this.f_58857_ != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.growCharges > 0 && this.f_58857_.m_46467_() % 10L == 0L) {
                --this.growCharges;
                double d0 = 0.5625;
                float f5 = 0.15f + 0.02f * serverLevel.f_46441_.m_188501_();
                float f = 0.4f + 0.3f * serverLevel.f_46441_.m_188501_();
                ModNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SPlayWorldSoundPacket(this.m_58899_(), SoundEvents.f_215734_, f5, f));
                for (Direction direction : Direction.values()) {
                    BlockPos blockpos = this.m_58899_().m_121945_(direction);
                    if (serverLevel.m_8055_(blockpos).m_60804_((BlockGetter)serverLevel, blockpos)) continue;
                    Direction.Axis direction$axis = direction.m_122434_();
                    double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)serverLevel.f_46441_.m_188501_();
                    double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)serverLevel.f_46441_.m_188501_();
                    double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)serverLevel.f_46441_.m_188501_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235900_, (double)this.m_58899_().m_123341_() + d1, (double)this.m_58899_().m_123342_() + d2, (double)this.m_58899_().m_123343_() + d3, 2, 0.2, 0.0, 0.2, 0.0);
                }
            }
        }
    }

    public void scanTotalPlants() {
        if (this.f_58857_ != null) {
            this.totalPlantPos.clear();
            int distance = 4 + this.enchantments.getOrDefault(ModEnchantments.RADIUS.get(), 0);
            int y = distance / 2;
            for (int i = -distance; i <= distance; ++i) {
                for (int j = -y; j <= y; ++j) {
                    for (int k = -distance; k <= distance; ++k) {
                        BlockState blockState;
                        BlockPos blockPos = this.m_58899_().m_7918_(i, j, k);
                        if (!this.f_58857_.m_46805_(blockPos) || (blockState = this.f_58857_.m_8055_(blockPos)).m_60795_() || !this.isCrops(blockPos) || this.totalPlantPos.contains(blockPos)) continue;
                        this.totalPlantPos.add(blockPos);
                    }
                }
            }
        }
    }

    public void findPlants() {
        Level level;
        if (this.f_58857_ != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.growablePlantPos.clear();
            int distance = 5 + this.enchantments.getOrDefault(ModEnchantments.RADIUS.get(), 0);
            int x = serverLevel.f_46441_.m_188503_(distance) * (serverLevel.f_46441_.m_188499_() ? -1 : 1);
            int y = distance / 2;
            int z = serverLevel.f_46441_.m_188503_(distance) * (serverLevel.f_46441_.m_188499_() ? -1 : 1);
            for (int i = -y; i < y; ++i) {
                BlockPos blockPos = this.m_58899_().m_7918_(x, i, z);
                if (!this.f_58857_.m_46805_(blockPos) || !this.isCrops(blockPos)) continue;
                this.growablePlantPos.add(blockPos);
            }
        }
    }

    public void growPlants() {
        Level level;
        if (this.f_58857_ != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.growablePlantPos.isEmpty()) {
                int random;
                BlockPos blockPos;
                BlockState blockState;
                int potency = 1 + this.enchantments.getOrDefault(ModEnchantments.POTENCY.get(), 0);
                if (!((Boolean)MainConfig.SculkGrowerPotency.get()).booleanValue()) {
                    potency = 1;
                }
                if (!(blockState = serverLevel.m_8055_(blockPos = this.growablePlantPos.get(random = serverLevel.f_46441_.m_188503_(this.growablePlantPos.size())))).m_60795_()) {
                    --this.growCharges;
                    serverLevel.m_8767_((ParticleOptions)new SculkChargeParticleOptions(0.0f), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
                    float f5 = 0.15f + 0.02f * serverLevel.f_46441_.m_188501_();
                    float f = 0.4f + 0.3f * serverLevel.f_46441_.m_188501_();
                    ModNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SPlayWorldSoundPacket(blockPos, SoundEvents.f_215734_, f5, f));
                    for (int i = 0; i < potency; ++i) {
                        blockState.m_222972_(serverLevel, blockPos, serverLevel.f_46441_);
                    }
                    this.decayTimer = 100;
                }
            } else if (this.decayTimer > 0) {
                --this.decayTimer;
            }
        }
    }

    private boolean isCrops(BlockPos blockPos) {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState blockState = this.f_58857_.m_8055_(blockPos);
        Block cropBlock = blockState.m_60734_();
        return cropBlock != Blocks.f_50440_ && !(cropBlock instanceof DoublePlantBlock) && cropBlock instanceof BonemealableBlock && ((BonemealableBlock)cropBlock).m_7370_((LevelReader)this.f_58857_, blockPos, blockState, this.f_58857_.f_46443_);
    }

    private boolean takeSouls() {
        if (this.f_58857_ == null) {
            return false;
        }
        int potency = 1 + this.enchantments.getOrDefault(ModEnchantments.POTENCY.get(), 0);
        if (!((Boolean)MainConfig.SculkGrowerPotency.get()).booleanValue()) {
            potency = 1;
        }
        int cost = (Integer)MainConfig.SculkGrowerCost.get() * potency;
        if (this.getCursedCageTile().getSouls() > cost) {
            this.getCursedCageTile().decreaseSouls(cost);
            this.getCursedCageTile().generateManyParticles();
            return true;
        }
        return false;
    }

    private boolean checkCage() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockPos pos = this.m_58899_().m_7494_();
        BlockState blockState = this.f_58857_.m_8055_(pos);
        if (blockState.m_60713_((Block)ModBlocks.CURSED_CAGE_BLOCK.get())) {
            BlockEntity tileentity = this.f_58857_.m_7702_(pos);
            if (tileentity instanceof CursedCageBlockEntity) {
                this.cursedCageTile = (CursedCageBlockEntity)tileentity;
                return !this.cursedCageTile.getItem().m_41619_();
            }
            return false;
        }
        return false;
    }

    public int getGrowCharges() {
        return this.growCharges;
    }

    @Override
    public void readNetwork(CompoundTag compoundNBT) {
        this.growCharges = compoundNBT.m_128451_("GrowCharges");
        this.decayTimer = compoundNBT.m_128451_("DecayTimer");
        this.loadEnchants(compoundNBT);
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag pCompound) {
        pCompound.m_128405_("GrowCharges", this.growCharges);
        pCompound.m_128405_("DecayTimer", this.decayTimer);
        this.saveEnchants(pCompound, ((Block)ModBlocks.SCULK_GROWER.get()).m_5456_());
        return pCompound;
    }

    public CursedCageBlockEntity getCursedCageTile() {
        return this.cursedCageTile;
    }
}

