/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities.void_spawner;

import com.Polarice3.Goety.client.particles.MagicAshSmokeParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawner;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawnerConfig;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawnerData;
import com.Polarice3.Goety.init.ModSounds;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.phys.Vec3;

public enum VoidSpawnerState implements StringRepresentable
{
    INACTIVE("inactive", 0, ParticleEmission.NONE, -1.0, false),
    WAITING_FOR_PLAYERS("waiting_for_players", 4, ParticleEmission.SMALL_FLAMES, 200.0, true),
    ACTIVE("active", 8, ParticleEmission.FLAMES_AND_SMOKE, 1000.0, true),
    WAITING_FOR_REWARD_EJECTION("waiting_for_reward_ejection", 8, ParticleEmission.SMALL_FLAMES, -1.0, false),
    EJECTING_REWARD("ejecting_reward", 8, ParticleEmission.SMALL_FLAMES, -1.0, false),
    COOLDOWN("cooldown", 0, ParticleEmission.SMOKE_INSIDE_AND_TOP_FACE, -1.0, false);

    private static final float DELAY_BEFORE_EJECT_AFTER_KILLING_LAST_MOB = 40.0f;
    private static final int TIME_BETWEEN_EACH_EJECTION;
    private final String name;
    private final int lightLevel;
    private final double spinningMobSpeed;
    private final ParticleEmission particleEmission;
    private final boolean isCapableOfSpawning;

    private VoidSpawnerState(String string2, int j, ParticleEmission particleEmission, double d, boolean bl) {
        this.name = string2;
        this.lightLevel = j;
        this.particleEmission = particleEmission;
        this.spinningMobSpeed = d;
        this.isCapableOfSpawning = bl;
    }

    VoidSpawnerState tickAndGetNext(BlockPos blockPos, VoidSpawner spawner, ServerLevel serverLevel) {
        VoidSpawnerData data = spawner.getData();
        VoidSpawnerConfig config = spawner.getConfig();
        return switch (this) {
            case INACTIVE -> data.getOrCreateDisplayEntity(spawner, (Level)serverLevel, WAITING_FOR_PLAYERS) == null ? this : WAITING_FOR_PLAYERS;
            case WAITING_FOR_PLAYERS -> {
                if (!data.hasMobToSpawn()) {
                    yield INACTIVE;
                }
                data.tryDetectPlayers(serverLevel, blockPos, spawner);
                yield data.detectedPlayers.isEmpty() ? this : ACTIVE;
            }
            case ACTIVE -> {
                if (!data.hasMobToSpawn()) {
                    yield INACTIVE;
                }
                int i = data.countAdditionalPlayers(blockPos);
                data.tryDetectPlayers(serverLevel, blockPos, spawner);
                if (data.hasFinishedSpawningAllMobs(config, i)) {
                    if (data.haveAllCurrentMobsDied()) {
                        data.cooldownEndsAt = serverLevel.m_46467_() + (long)config.targetCooldownLength();
                        data.totalMobsSpawned = 0;
                        data.nextMobSpawnsAt = 0L;
                        yield WAITING_FOR_REWARD_EJECTION;
                    }
                } else if (data.isReadyToSpawnNextMob(serverLevel, config, i)) {
                    spawner.spawnMob(serverLevel, blockPos).ifPresent(uuid -> {
                        data.currentMobs.add((UUID)uuid);
                        ++data.totalMobsSpawned;
                        data.nextMobSpawnsAt = serverLevel.m_46467_() + (long)config.ticksBetweenSpawn();
                        data.spawnPotentials.m_216829_(serverLevel.m_213780_()).ifPresent(data1 -> {
                            data.nextSpawnData = Optional.of((SpawnData)data1.m_146310_());
                            spawner.markUpdated();
                        });
                    });
                }
                yield this;
            }
            case WAITING_FOR_REWARD_EJECTION -> {
                if (data.isReadyToOpenShutter(serverLevel, config, 40.0f)) {
                    serverLevel.m_247517_(null, blockPos, (SoundEvent)ModSounds.VOID_SPAWNER_OPEN_SHUTTER.get(), SoundSource.BLOCKS);
                    yield EJECTING_REWARD;
                }
                yield this;
            }
            case EJECTING_REWARD -> {
                if (!data.isReadyToEjectItems(serverLevel, config, TIME_BETWEEN_EACH_EJECTION)) {
                    yield this;
                }
                if (data.detectedPlayers.isEmpty()) {
                    serverLevel.m_247517_(null, blockPos, (SoundEvent)ModSounds.VOID_SPAWNER_CLOSE_SHUTTER.get(), SoundSource.BLOCKS);
                    data.ejectingLootTable = Optional.empty();
                    yield COOLDOWN;
                }
                if (data.ejectingLootTable.isEmpty()) {
                    data.ejectingLootTable = config.lootTablesToEject().m_216820_(serverLevel.m_213780_());
                }
                data.ejectingLootTable.ifPresent(location -> spawner.ejectReward(serverLevel, blockPos, (ResourceLocation)location));
                data.detectedPlayers.remove(data.detectedPlayers.iterator().next());
                yield this;
            }
            case COOLDOWN -> {
                if (data.isCooldownFinished(serverLevel)) {
                    data.cooldownEndsAt = 0L;
                    yield WAITING_FOR_PLAYERS;
                }
                yield this;
            }
            default -> INACTIVE;
        };
    }

    public int lightLevel() {
        return this.lightLevel;
    }

    public double spinningMobSpeed() {
        return this.spinningMobSpeed;
    }

    public boolean hasSpinningMob() {
        return this.spinningMobSpeed >= 0.0;
    }

    public boolean isCapableOfSpawning() {
        return this.isCapableOfSpawning;
    }

    public void emitParticles(Level level, BlockPos blockPos) {
        this.particleEmission.emit(level, level.m_213780_(), blockPos);
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        TIME_BETWEEN_EACH_EJECTION = Mth.m_14143_((float)30.0f);
    }

    static interface ParticleEmission {
        public static final ParticleEmission NONE = (level, randomSource, blockPos) -> {};
        public static final ParticleEmission SMALL_FLAMES = (level, randomSource, blockPos) -> {
            if (randomSource.m_188503_(2) == 0) {
                Vec3 vec3 = blockPos.m_252807_().m_272010_(randomSource, 0.9f);
                ParticleEmission.addParticle((ParticleOptions)ModParticleTypes.SMALL_END_FIRE.get(), vec3, level);
            }
        };
        public static final ParticleEmission FLAMES_AND_SMOKE = (level, randomSource, blockPos) -> {
            Vec3 vec3 = blockPos.m_252807_().m_272010_(randomSource, 1.0f);
            ParticleEmission.addParticle(new MagicAshSmokeParticle.Option(3802679, 6886773), vec3, level);
            ParticleEmission.addParticle((ParticleOptions)ModParticleTypes.END_FIRE.get(), vec3, level);
            ParticleEmission.addParticle((ParticleOptions)ModParticleTypes.END_FIRE_DROP.get(), vec3, level);
        };
        public static final ParticleEmission SMOKE_INSIDE_AND_TOP_FACE = (level, randomSource, blockPos) -> {
            Vec3 vec3 = blockPos.m_252807_().m_272010_(randomSource, 0.9f);
            if (randomSource.m_188503_(3) == 0) {
                ParticleEmission.addParticle(new MagicAshSmokeParticle.Option(3802679, 6886773), vec3, level);
            }
            if (level.m_46467_() % 20L == 0L) {
                Vec3 vec32 = blockPos.m_252807_().m_82520_(0.0, 0.5, 0.0);
                int i = level.m_213780_().m_188503_(4) + 20;
                for (int j = 0; j < i; ++j) {
                    ParticleEmission.addParticle(new MagicAshSmokeParticle.Option(3802679, 6886773), vec32, level);
                }
            }
        };

        private static void addParticle(ParticleOptions particleOptions, Vec3 vec3, Level level) {
            level.m_7106_(particleOptions, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0.0, 0.0, 0.0);
        }

        public void emit(Level var1, RandomSource var2, BlockPos var3);
    }

    static class SpinningMob {
        private static final double NONE = -1.0;
        private static final double SLOW = 200.0;
        private static final double FAST = 1000.0;

        private SpinningMob() {
        }
    }

    static class LightLevel {
        private static final int UNLIT = 0;
        private static final int HALF_LIT = 4;
        private static final int LIT = 8;

        private LightLevel() {
        }
    }
}

