/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.crafting;

import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class PulverizeRecipe
implements Recipe<Container> {
    public static Serializer SERIALIZER = new Serializer();
    protected final ResourceLocation id;
    public final Ingredient ingredient;
    protected final ItemStack itemResult;
    protected final Block blockResult;

    public PulverizeRecipe(ResourceLocation pId, Ingredient pIngredient, ItemStack pResult, Block pBlock) {
        this.id = pId;
        this.ingredient = pIngredient;
        this.itemResult = pResult;
        this.blockResult = pBlock;
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        return this.ingredient.test(pInv.m_8020_(0));
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.itemResult.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.itemResult;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public Block getBlockResult() {
        return this.blockResult;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeSerializer.PULVERIZE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<PulverizeRecipe> {
        public PulverizeRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            ItemStack itemstack = ItemStack.f_41583_;
            if (pJson.has("item_result")) {
                if (pJson.get("item_result").isJsonObject()) {
                    itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"item_result"));
                } else {
                    String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"item_result");
                    ResourceLocation resourcelocation = new ResourceLocation(s1);
                    itemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resourcelocation));
                }
            }
            Block block = Blocks.f_50627_;
            if (pJson.has("block_result")) {
                String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"block_result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                block = (Block)ForgeRegistries.BLOCKS.getValue(resourcelocation);
            }
            return new PulverizeRecipe(pRecipeId, ingredient, itemstack, block);
        }

        public PulverizeRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.m_130267_();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(pBuffer.m_130281_());
            return new PulverizeRecipe(pRecipeId, ingredient, itemstack, block);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PulverizeRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.itemResult);
            ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)pRecipe.blockResult);
            if (resourceLocation != null) {
                pBuffer.m_130085_(resourceLocation);
            }
        }
    }
}

