/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.crafting;

import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.crafting.ModShapelessRecipe;
import com.Polarice3.Goety.common.ritual.ModRitualFactory;
import com.Polarice3.Goety.common.ritual.ModRituals;
import com.Polarice3.Goety.common.ritual.Ritual;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualRecipe
extends ModShapelessRecipe {
    public static Serializer SERIALIZER = new Serializer();
    private final ResourceLocation ritualType;
    private final Ritual ritual;
    private final String craftType;
    private final int soulCost;
    private final Ingredient activationItem;
    private final TagKey<EntityType<?>> entityToSacrifice;
    private final TagKey<EntityType<?>> entityToConvert;
    private final EntityType<?> entityToSummon;
    private final EntityType<?> entityToConvertInto;
    private final Enchantment enchantment;
    private final int xpLevelCost;
    private final int duration;
    private final int summonLife;
    private final float durationPerIngredient;
    private final String entityToSacrificeDisplayName;
    private final String entityToConvertDisplayName;
    private final String research;

    public RitualRecipe(ResourceLocation id, String group, String pCraftType, ResourceLocation ritualType, ItemStack result, EntityType<?> entityToSummon, EntityType<?> entityToConvertInto, Ingredient activationItem, NonNullList<Ingredient> input, int duration, int summonLife, int pSoulCost, TagKey<EntityType<?>> entityToSacrifice, String entityToSacrificeDisplayName, TagKey<EntityType<?>> entityToConvert, String entityToConvertDisplayName, Enchantment enchantment, int xpLevelCost, String research) {
        super(id, group, CraftingBookCategory.MISC, result, input);
        this.craftType = pCraftType;
        this.soulCost = pSoulCost;
        this.entityToSummon = entityToSummon;
        this.entityToConvertInto = entityToConvertInto;
        this.ritualType = ritualType;
        this.ritual = ((ModRitualFactory)ModRituals.REGISTRY.get().getValue(this.ritualType)).create(this);
        this.activationItem = activationItem;
        this.duration = duration;
        this.summonLife = summonLife;
        this.durationPerIngredient = (float)this.duration / (float)(this.m_7527_().size() + 1);
        this.entityToSacrifice = entityToSacrifice;
        this.entityToSacrificeDisplayName = entityToSacrificeDisplayName;
        this.entityToConvert = entityToConvert;
        this.entityToConvertDisplayName = entityToConvertDisplayName;
        this.enchantment = enchantment;
        this.xpLevelCost = xpLevelCost;
        this.research = research;
    }

    public String getCraftType() {
        return this.craftType;
    }

    public int getSoulCost() {
        return this.soulCost;
    }

    public Ingredient getActivationItem() {
        return this.activationItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getDurationPerIngredient() {
        return this.durationPerIngredient;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean matches(Level world, BlockPos darkAltarPos, Player player, ItemStack activationItem) {
        return this.ritual.identify(world, darkAltarPos, player, activationItem);
    }

    @Override
    public boolean matches(@Nonnull CraftingContainer inventory, @Nonnull Level world) {
        return false;
    }

    @Override
    public ItemStack assemble(CraftingContainer inventoryCrafting, RegistryAccess pAccess) {
        return null;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeSerializer.RITUAL_TYPE.get();
    }

    public TagKey<EntityType<?>> getEntityToSacrifice() {
        return this.entityToSacrifice;
    }

    public boolean requiresSacrifice() {
        return this.entityToSacrifice != null;
    }

    public EntityType<?> getEntityToSummon() {
        return this.entityToSummon;
    }

    public EntityType<?> getEntityToConvertInto() {
        return this.entityToConvertInto;
    }

    public TagKey<EntityType<?>> getEntityToConvert() {
        return this.entityToConvert;
    }

    public boolean isConversion() {
        return this.entityToConvert != null && this.entityToConvertInto != null;
    }

    public boolean isSummoning() {
        return this.entityToSummon != null;
    }

    public ResourceLocation getRitualType() {
        return this.ritualType;
    }

    public Ritual getRitual() {
        return this.ritual;
    }

    public String getEntityToSacrificeDisplayName() {
        return this.entityToSacrificeDisplayName;
    }

    public String getEntityToConvertDisplayName() {
        return this.entityToConvertDisplayName;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getXPLevelCost() {
        return this.xpLevelCost;
    }

    public String getResearch() {
        return this.research;
    }

    public int getSummonLife() {
        return this.summonLife;
    }

    public static class Serializer
    implements RecipeSerializer<RitualRecipe> {
        private static final ModShapelessRecipe.Serializer serializer = new ModShapelessRecipe.Serializer();

        public RitualRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            String craftType = GsonHelper.m_13851_((JsonObject)json, (String)"craftType", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ResourceLocation ritualType = new ResourceLocation(json.get("ritual_type").getAsString());
            EntityType entityToSummon = null;
            if (json.has("entity_to_summon")) {
                entityToSummon = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"entity_to_summon")));
            }
            JsonArray activationItemElement = GsonHelper.m_13885_((JsonObject)json, (String)"activation_item") ? GsonHelper.m_13933_((JsonObject)json, (String)"activation_item") : GsonHelper.m_13930_((JsonObject)json, (String)"activation_item");
            Ingredient activationItem = Ingredient.m_43917_((JsonElement)activationItemElement);
            int duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)30);
            int summonLife = GsonHelper.m_13824_((JsonObject)json, (String)"summonLife", (int)-1);
            int soulCost = GsonHelper.m_13824_((JsonObject)json, (String)"soulCost", (int)0);
            TagKey entityToSacrifice = null;
            String entityToSacrificeDisplayName = "";
            if (json.has("entity_to_sacrifice")) {
                ResourceLocation tagRL = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json.getAsJsonObject("entity_to_sacrifice"), (String)"tag"));
                entityToSacrifice = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagRL);
                entityToSacrificeDisplayName = json.getAsJsonObject("entity_to_sacrifice").get("display_name").getAsString();
            }
            EntityType entityToConvertInto = null;
            TagKey entityToConvert = null;
            String entityToConvertDisplayName = "";
            String research = "";
            Enchantment enchantment = null;
            int xpLevelCost = 0;
            if (json.has("entity_to_convert")) {
                ResourceLocation tagRL = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json.getAsJsonObject("entity_to_convert"), (String)"tag"));
                entityToConvert = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagRL);
                entityToConvertDisplayName = json.getAsJsonObject("entity_to_convert").get("display_name").getAsString();
            }
            if (json.has("entity_to_convert_into")) {
                entityToConvertInto = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"entity_to_convert_into")));
            }
            if (json.has("enchantment")) {
                enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"enchantment")));
                xpLevelCost = GsonHelper.m_13824_((JsonObject)json, (String)"xpLevelCost", (int)0);
            }
            if (json.has("research")) {
                research = GsonHelper.m_13851_((JsonObject)json, (String)"research", (String)"");
            }
            return new RitualRecipe(recipeId, group, craftType, ritualType, result, entityToSummon, entityToConvertInto, activationItem, ingredients, duration, summonLife, soulCost, entityToSacrifice, entityToSacrificeDisplayName, entityToConvert, entityToConvertDisplayName, enchantment, xpLevelCost, research);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public RitualRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ModShapelessRecipe recipe = serializer.fromNetwork(recipeId, buffer);
            if (recipe == null) {
                return null;
            }
            String craftType = buffer.m_130136_(Short.MAX_VALUE);
            ResourceLocation ritualType = buffer.m_130281_();
            EntityType entityToSummon = null;
            if (buffer.readBoolean()) {
                entityToSummon = (EntityType)buffer.readRegistryId();
            }
            int duration = buffer.m_130242_();
            int summonLife = buffer.m_130242_();
            int soulCost = buffer.m_130242_();
            Ingredient activationItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            TagKey entityToSacrifice = null;
            String entityToSacrificeDisplayName = "";
            if (buffer.readBoolean()) {
                ResourceLocation tagRL = buffer.m_130281_();
                entityToSacrifice = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagRL);
                entityToSacrificeDisplayName = buffer.m_130277_();
            }
            EntityType entityToConvertInto = null;
            TagKey entityToConvert = null;
            String entityToConvertDisplayName = "";
            if (buffer.readBoolean()) {
                ResourceLocation tagRL = buffer.m_130281_();
                entityToConvert = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagRL);
                entityToConvertDisplayName = buffer.m_130277_();
            }
            if (buffer.readBoolean()) {
                entityToConvertInto = (EntityType)buffer.readRegistryId();
            }
            Enchantment enchantment = null;
            int xpLevelCost = 0;
            if (buffer.readBoolean()) {
                enchantment = (Enchantment)buffer.readRegistryId();
                xpLevelCost = buffer.m_130242_();
            }
            String research = "";
            if (buffer.readBoolean()) {
                research = buffer.m_130136_(Short.MAX_VALUE);
            }
            return new RitualRecipe(recipe.m_6423_(), recipe.m_6076_(), craftType, ritualType, recipe.m_8043_(null), entityToSummon, entityToConvertInto, activationItem, recipe.m_7527_(), duration, summonLife, soulCost, entityToSacrifice, entityToSacrificeDisplayName, entityToConvert, entityToConvertDisplayName, enchantment, xpLevelCost, research);
        }

        public void toNetwork(FriendlyByteBuf buffer, RitualRecipe recipe) {
            serializer.toNetwork(buffer, recipe);
            buffer.m_130070_(recipe.craftType);
            buffer.m_130085_(recipe.ritualType);
            buffer.writeBoolean(recipe.entityToSummon != null);
            if (recipe.entityToSummon != null) {
                buffer.writeRegistryId(ForgeRegistries.ENTITY_TYPES, recipe.entityToSummon);
            }
            buffer.m_130130_(recipe.duration);
            buffer.m_130130_(recipe.summonLife);
            buffer.m_130130_(recipe.soulCost);
            recipe.activationItem.m_43923_(buffer);
            buffer.writeBoolean(recipe.entityToSacrifice != null);
            if (recipe.entityToSacrifice != null) {
                buffer.m_130085_(recipe.entityToSacrifice.f_203868_());
                buffer.m_130070_(recipe.entityToSacrificeDisplayName);
            }
            buffer.writeBoolean(recipe.entityToConvert != null);
            if (recipe.entityToConvert != null) {
                buffer.m_130085_(recipe.entityToConvert.f_203868_());
                buffer.m_130070_(recipe.entityToConvertDisplayName);
            }
            buffer.writeBoolean(recipe.entityToConvertInto != null);
            if (recipe.entityToConvertInto != null) {
                buffer.writeRegistryId(ForgeRegistries.ENTITY_TYPES, recipe.entityToConvertInto);
            }
            buffer.writeBoolean(recipe.enchantment != null);
            if (recipe.enchantment != null) {
                buffer.writeRegistryId(ForgeRegistries.ENCHANTMENTS, (Object)recipe.enchantment);
                buffer.m_130130_(recipe.xpLevelCost);
            }
            buffer.writeBoolean(recipe.research != null);
            if (recipe.research != null) {
                buffer.m_130070_(recipe.research);
            }
        }
    }
}

