/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.effects.brew.block;

import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.config.BrewConfig;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class DroughtBlockEffect
extends BrewEffect {
    public DroughtBlockEffect() {
        super("drought", (int)((Integer)BrewConfig.DroughtCost.get()), MobEffectCategory.NEUTRAL, 10325817);
    }

    @Override
    public boolean canLinger() {
        return true;
    }

    @Override
    public void applyBlockEffect(Level pLevel, BlockPos pPos, LivingEntity pSource, int pAmplifier, int pAreaOfEffect) {
        if (this.removeWaterBreadthFirstSearch(pLevel, pPos, pAreaOfEffect)) {
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)Blocks.f_49990_.m_49966_()));
        }
    }

    private boolean removeWaterBreadthFirstSearch(Level p_56808_, BlockPos p_56809_, int pAreaOfEffect) {
        BlockState spongeState = p_56808_.m_8055_(p_56809_);
        Direction[] ALL_DIRECTIONS = Direction.values();
        return BlockPos.m_276833_((BlockPos)p_56809_, (int)(6 * (pAreaOfEffect + 1)), (int)(65 * (pAreaOfEffect + 1)), (p_277519_, p_277492_) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                p_277492_.accept(p_277519_.m_121945_(direction));
            }
        }, p_279054_ -> {
            BucketPickup bucketpickup;
            if (p_279054_.equals((Object)p_56809_)) {
                return true;
            }
            BlockState blockstate = p_56808_.m_8055_(p_279054_);
            FluidState fluidstate = p_56808_.m_6425_(p_279054_);
            if (!spongeState.canBeHydrated((BlockGetter)p_56808_, p_56809_, fluidstate, p_279054_)) {
                return false;
            }
            Block block = blockstate.m_60734_();
            if (block instanceof BucketPickup && !(bucketpickup = (BucketPickup)block).m_142598_((LevelAccessor)p_56808_, p_279054_, blockstate).m_41619_()) {
                return true;
            }
            if (blockstate.m_60734_() instanceof LiquidBlock) {
                p_56808_.m_7731_(p_279054_, Blocks.f_50016_.m_49966_(), 3);
            } else {
                if (!(blockstate.m_60713_(Blocks.f_50575_) || blockstate.m_60713_(Blocks.f_50576_) || blockstate.m_60713_(Blocks.f_50037_) || blockstate.m_60713_(Blocks.f_50038_))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.m_155947_() ? p_56808_.m_7702_(p_279054_) : null;
                Block.m_49892_((BlockState)blockstate, (LevelAccessor)p_56808_, (BlockPos)p_279054_, (BlockEntity)blockentity);
                p_56808_.m_7731_(p_279054_, Blocks.f_50016_.m_49966_(), 3);
            }
            return true;
        }) > 1;
    }

    @Override
    public void applyEntityEffect(LivingEntity pTarget, @Nullable Entity pSource, int pAmplifier) {
        if (pTarget.m_6336_() == MobType.f_21644_) {
            pTarget.m_6469_(pTarget.m_269291_().m_269483_(), (float)pAmplifier + 5.0f);
        }
    }
}

