/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class Summoned
extends Owned
implements IServant {
    protected static final EntityDataAccessor<Byte> SUMMONED_FLAGS = SynchedEntityData.m_135353_(Summoned.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> UPGRADE_FLAGS = SynchedEntityData.m_135353_(Summoned.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public LivingEntity commandPosEntity;
    public BlockPos commandPos;
    public BlockPos boundPos;
    public String boundDim = Level.f_46428_.m_135782_().toString();
    public int commandTick;
    public int killChance;
    public int noHealTime;
    public long ticketTime = 0L;

    public Summoned(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.targetRetaliateGoal();
        this.followGoal();
        this.targetSelectGoal();
    }

    public void followGoal() {
        this.f_21345_.m_25352_(5, new FollowOwnerGoal<Summoned>(this, 1.0, 10.0f, 2.0f));
    }

    public void targetRetaliateGoal() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void targetSelectGoal() {
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this));
    }

    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob);
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, flag);
    }

    public void m_6043_() {
        if (this.isHostile()) {
            super.m_6043_();
        }
    }

    public ItemStack m_6298_(ItemStack pShootable) {
        if (pShootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.servantTick();
    }

    @Override
    public long getTicketTime() {
        return this.ticketTime;
    }

    @Override
    public void setTicketTime(long ticketTime) {
        this.ticketTime = ticketTime;
    }

    @Override
    public long decreaseTicketTime() {
        return --this.ticketTime;
    }

    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    public boolean servantSunBurn() {
        return this.isSunSensitive();
    }

    @Override
    public boolean burnSunTick() {
        return this.m_21527_();
    }

    public void m_6710_(@Nullable LivingEntity p_21544_) {
        if (this.isGuardingArea()) {
            if (p_21544_ != null) {
                if (p_21544_.m_20238_(this.vec3BoundPos()) <= (double)Mth.m_144944_((int)GUARDING_RANGE)) {
                    this.normalSetTarget(p_21544_);
                }
            } else {
                this.normalSetTarget(null);
            }
        } else {
            this.normalSetTarget(p_21544_);
        }
    }

    public void normalSetTarget(@Nullable LivingEntity p_21544_) {
        super.m_6710_(p_21544_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.summonParticles(pLevel.m_6018_(), pReason);
        if (this.getTrueOwner() != null) {
            this.spawnUpgraded();
        }
        this.setWandering(this.getTrueOwner() == null);
        this.setStaying(false);
        this.setBoundPos(null);
        return pSpawnData;
    }

    public void summonParticles(ServerLevel pLevel, MobSpawnType pReason) {
        if (pReason == MobSpawnType.MOB_SUMMONED && this.getTrueOwner() != null) {
            for (int i = 0; i < pLevel.f_46441_.m_188503_(10) + 10; ++i) {
                pLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SUMMON.get()), this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 1.0);
            }
            if (this.m_6336_() == MobType.f_21641_) {
                pLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SOUL_EXPLODE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 2.0, 0.0, 1.0);
            }
        }
    }

    public boolean canSpawnArmor() {
        return this.getTrueOwner() != null && this.getSpawnType() != MobSpawnType.CONVERSION && CuriosFinder.hasCurio(this.getTrueOwner(), (Item)ModItems.RING_OF_THE_FORGE.get());
    }

    protected void m_213945_(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (this.canSpawnArmor()) {
            this.populateDefaultArmor(p_217055_, p_217056_);
        } else {
            super.m_213945_(p_217055_, p_217056_);
        }
        this.populateDefaultWeapons(p_217055_, p_217056_);
    }

    public void populateDefaultArmor(RandomSource randomSource, DifficultyInstance difficulty) {
        if (this.canSpawnArmor()) {
            this.spawnArmor(randomSource);
        }
    }

    public void spawnArmor(RandomSource randomSource) {
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            Item item;
            ItemStack itemstack;
            if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            int i = randomSource.m_188503_(2);
            float baseChance = 0.095f;
            if (this.getTrueOwner() != null) {
                baseChance += (float)this.getTrueOwner().m_21133_(Attributes.f_22286_) * 0.05f;
            }
            baseChance = Math.min(baseChance, 0.5f);
            if (randomSource.m_188501_() < baseChance) {
                ++i;
            }
            if (randomSource.m_188501_() < baseChance) {
                ++i;
            }
            if (randomSource.m_188501_() < baseChance) {
                ++i;
            }
            if (!(itemstack = this.m_6844_(equipmentslot)).m_41619_() || (item = Summoned.m_21412_((EquipmentSlot)equipmentslot, (int)i)) == null) continue;
            this.m_8061_(equipmentslot, new ItemStack((ItemLike)item));
            this.m_21409_(equipmentslot, 0.0f);
        }
    }

    public void populateDefaultWeapons(RandomSource randomSource, DifficultyInstance difficulty) {
    }

    public void m_6667_(DamageSource pCause) {
        if (!this.f_19853_.f_46443_ && this.m_8077_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getTrueOwner() instanceof ServerPlayer) {
            this.getTrueOwner().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(pCause);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Summoned summoned;
        Entity entity;
        if (((Boolean)MobsConfig.ServantsMasterImmune.get()).booleanValue() && (entity = source.m_7639_()) instanceof Summoned && !(summoned = (Summoned)entity).isHostile() && !this.isHostile() && this.getTrueOwner() != null && summoned.getTrueOwner() == this.getTrueOwner()) {
            return false;
        }
        boolean flag = super.m_6469_(source, amount);
        if (flag) {
            this.setNoHealTime(MathHelper.secondsToTicks((Integer)MobsConfig.ServantHealHalt.get()));
        }
        return flag;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            if (this.m_6336_() == MobType.f_21641_) {
                float f = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
                if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                    entityIn.m_20254_(2 * (int)f);
                }
            }
            if (!this.m_21205_().m_41619_() && this.m_21205_().m_41763_()) {
                ItemHelper.hurtAndBreak(this.m_21205_(), 1, this);
            }
        }
        return flag;
    }

    protected void m_6472_(DamageSource pDamageSource, float pDamage) {
        if (!(pDamage <= 0.0f)) {
            if ((pDamage /= 4.0f) < 1.0f) {
                pDamage = 1.0f;
            }
            for (EquipmentSlot equipmentSlotType : EquipmentSlot.values()) {
                if (equipmentSlotType.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.m_6844_(equipmentSlotType);
                if (pDamageSource.m_269533_(DamageTypeTags.f_268745_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
                itemstack.m_41622_((int)pDamage, (LivingEntity)this, p_214023_1_ -> p_214023_1_.m_21166_(equipmentSlotType));
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONED_FLAGS, (Object)0);
        this.f_19804_.m_135372_(UPGRADE_FLAGS, (Object)0);
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(SUMMONED_FLAGS);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(SUMMONED_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(SUMMONED_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    @Override
    public boolean isWandering() {
        return this.getFlag(1);
    }

    @Override
    public void setWandering(boolean wandering) {
        this.setFlags(1, wandering);
    }

    @Override
    public boolean isStaying() {
        return this.getFlag(2) && !this.isCommanded() && this.m_6688_() == null;
    }

    @Override
    public void setStaying(boolean staying) {
        this.setFlags(2, staying);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readServantData(compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.saveServantData(compound);
    }

    @Override
    public boolean canUpdateMove() {
        return this.m_6336_() == MobType.f_21641_ || this.m_6336_() == ModMobType.NATURAL;
    }

    @Override
    public boolean isUpgraded() {
        return ((Byte)this.f_19804_.m_135370_(UPGRADE_FLAGS) & 4) != 0;
    }

    @Override
    public void setUpgraded(boolean upgraded) {
        byte b0 = (Byte)this.f_19804_.m_135370_(UPGRADE_FLAGS);
        if (upgraded) {
            this.f_19804_.m_135381_(UPGRADE_FLAGS, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(UPGRADE_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public void upgrade() {
        this.setUpgraded(true);
    }

    public void downgrade() {
        this.setUpgraded(false);
    }

    @Override
    public void setCommandPos(BlockPos blockPos, boolean removeEntity) {
        if (removeEntity) {
            this.commandPosEntity = null;
        }
        this.commandPos = blockPos;
        this.setCommandTick(MathHelper.secondsToTicks(10));
    }

    @Override
    public BlockPos getCommandPos() {
        return this.commandPos;
    }

    @Override
    public void setCommandPosEntity(@Nullable LivingEntity living) {
        this.commandPosEntity = living;
        if (living != null) {
            this.setCommandPos(living.m_20183_(), false);
        }
    }

    @Override
    @Nullable
    public LivingEntity getCommandPosEntity() {
        return this.commandPosEntity;
    }

    @Override
    public int getCommandTick() {
        return this.commandTick;
    }

    @Override
    public void setCommandTick(int commandTick) {
        this.commandTick = commandTick;
    }

    @Override
    public boolean isCommanded() {
        return this.commandPos != null;
    }

    @Override
    public BlockPos getBoundPos() {
        return this.boundPos;
    }

    @Override
    public void setBoundPos(BlockPos blockPos) {
        this.boundPos = blockPos;
        this.setBoundDim(this.f_19853_.m_46472_());
    }

    @Override
    public String getBoundDim() {
        return this.boundDim;
    }

    @Override
    public void setBoundDim(String string) {
        this.boundDim = string;
    }

    public void dropEquipment(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (this.m_21519_(equipmentSlot) > 0.0f) {
            this.m_19983_(stack);
        }
    }

    public boolean isMoving() {
        return !(this.f_267362_.m_267731_() < 0.01f);
    }

    @Override
    public int getNoHealTime() {
        return this.noHealTime;
    }

    @Override
    public void setNoHealTime(int time) {
        this.noHealTime = time;
    }

    @Override
    public int getKillChance() {
        return this.killChance;
    }

    @Override
    public void setKillChance(int killChance) {
        this.killChance = killChance;
    }

    public void warnKill(Player player) {
        this.killChance = 60;
        player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.tryKill", (Object[])new Object[]{this.m_5446_()}), true);
    }

    @Override
    public void tryKill(Player player) {
        this.m_6469_(ModDamageSource.getDamageSource(this.f_19853_, ModDamageSource.DISMISSED, new EntityType[0]), Float.MAX_VALUE);
    }

    @Override
    public void m_7334_(Entity p_21294_) {
        if (!this.f_19853_.f_46443_ && !this.isStaying()) {
            super.m_7334_(p_21294_);
        }
    }

    @Override
    protected void m_7324_(Entity p_20971_) {
        if (!this.f_19853_.f_46443_ && !this.isStaying()) {
            super.m_7324_(p_20971_);
        }
    }

    @Override
    public boolean m_7337_(Entity p_20303_) {
        if (!this.isStaying()) {
            return super.m_7337_(p_20303_);
        }
        return false;
    }

    public DamageSource getServantAttack() {
        return MobUtil.getServantAttack(this);
    }

    public static class FollowOwnerGoal<T extends Mob>
    extends Goal {
        public final T summonedEntity;
        public LivingEntity owner;
        public final LevelReader level;
        public final double followSpeed;
        public final PathNavigation navigation;
        public int timeToRecalcPath;
        public final float stopDistance;
        public final float startDistance;
        public float oldWaterCost;

        public FollowOwnerGoal(T summonedEntity, double speed, float startDistance, float stopDistance) {
            this.summonedEntity = summonedEntity;
            this.level = ((Mob)summonedEntity).f_19853_;
            this.followSpeed = speed;
            this.navigation = summonedEntity.m_21573_();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(summonedEntity.m_21573_() instanceof GroundPathNavigation) && !(summonedEntity.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity livingentity = ((IOwned)this.summonedEntity).getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.summonedEntity.m_20280_((Entity)livingentity) < (double)Mth.m_14207_((float)this.startDistance)) {
                return false;
            }
            if (!((IServant)this.summonedEntity).isFollowing() || ((IServant)this.summonedEntity).isCommanded()) {
                return false;
            }
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            return !(this.summonedEntity.m_20280_((Entity)this.owner) <= (double)Mth.m_14207_((float)this.stopDistance));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.summonedEntity.m_21439_(BlockPathTypes.WATER);
            this.summonedEntity.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.summonedEntity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            if (this.owner != null) {
                this.summonedEntity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.summonedEntity.m_8132_());
                if (this.summonedEntity.m_275832_() != null) {
                    this.navigation.m_5624_((Entity)this.owner, this.followSpeed + 0.25);
                    Entity entity = this.summonedEntity.m_275832_();
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21573_().m_5624_((Entity)this.owner, this.followSpeed + 0.25);
                    }
                } else if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = 10;
                    if (!this.summonedEntity.m_21523_() && !this.summonedEntity.m_20159_()) {
                        boolean flag;
                        double range = this.owner instanceof Mob ? 32.0 : 16.0;
                        boolean bl = flag = this.summonedEntity.m_20280_((Entity)this.owner) >= Mth.m_144952_((double)range);
                        flag = this.owner instanceof Mob ? (flag |= !this.summonedEntity.m_142582_((Entity)this.owner) && this.summonedEntity.m_20280_((Entity)this.owner) >= Mth.m_144952_((double)8.0)) : (flag &= this.canTeleport());
                        if (flag) {
                            this.tryToTeleportNearEntity();
                        } else {
                            this.navigation.m_5624_((Entity)this.owner, this.followSpeed);
                        }
                    }
                }
            }
        }

        protected boolean canTeleport() {
            return (Boolean)MobsConfig.ServantTeleport.get();
        }

        protected void tryToTeleportNearEntity() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomNumber(-3, 3);
                int k = this.getRandomNumber(-1, 1);
                int l = this.getRandomNumber(-3, 3);
                boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }

        protected boolean tryToTeleportToLocation(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
                return false;
            }
            this.summonedEntity.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.summonedEntity.m_146908_(), this.summonedEntity.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        protected boolean isTeleportFriendlyBlock(BlockPos pos) {
            BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (pathnodetype != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(pos.m_7495_());
            if (blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pos.m_121996_((Vec3i)this.summonedEntity.m_20183_());
            return this.level.m_45756_(this.summonedEntity, this.summonedEntity.m_20191_().m_82338_(blockpos));
        }

        protected int getRandomNumber(int min, int max) {
            return this.summonedEntity.m_217043_().m_188503_(max - min + 1) + min;
        }
    }

    public static class NaturalAttackGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        protected Summoned summoned;

        public NaturalAttackGoal(Summoned summoned, Class<T> tClass) {
            this(summoned, tClass, 10, true, null);
        }

        public NaturalAttackGoal(Summoned summoned, Class<T> tClass, boolean pMustSee) {
            this(summoned, tClass, 10, pMustSee, null);
        }

        public NaturalAttackGoal(Summoned summoned, Class<T> tClass, boolean pMustSee, @Nullable Predicate<LivingEntity> predicate) {
            this(summoned, tClass, 10, pMustSee, predicate);
        }

        public NaturalAttackGoal(Summoned summoned, Class<T> tClass, int time, boolean pMustSee, @Nullable Predicate<LivingEntity> predicate) {
            this(summoned, tClass, time, pMustSee, false, predicate);
        }

        public NaturalAttackGoal(Summoned summoned, Class<T> tClass, int time, boolean pMustSee, boolean pMustReach, Predicate<LivingEntity> predicate) {
            super((Mob)summoned, tClass, time, pMustSee, pMustReach, predicate);
            this.summoned = summoned;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.summoned.isNatural() && this.summoned.getTrueOwner() == null && this.f_26050_ != null;
        }
    }

    public static class GoToWaterGoal
    extends Goal {
        private final Summoned mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public GoToWaterGoal(Summoned p_i48910_1_, double p_i48910_2_) {
            this.mob = p_i48910_1_;
            this.speedModifier = p_i48910_2_;
            this.level = p_i48910_1_.f_19853_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.getTrueOwner() != null ? !this.mob.getTrueOwner().m_20069_() : !this.level.m_46461_()) {
                return false;
            }
            if (this.mob.m_20069_()) {
                return false;
            }
            Vec3 vector3d = this.getWaterPos();
            if (vector3d == null) {
                return false;
            }
            this.wantedX = vector3d.f_82479_;
            this.wantedY = vector3d.f_82480_;
            this.wantedZ = vector3d.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            RandomSource random = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(random.m_188503_(20) - 10, 2 - random.m_188503_(8), random.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    public static class ReturnToGuardPos<T extends PathfinderMob>
    extends MoveToBlockGoal {
        protected final T servant;
        public int range;

        public ReturnToGuardPos(T servant, double speed, int range) {
            super(servant, speed, range);
            this.servant = servant;
            this.range = range;
        }

        public boolean m_8036_() {
            if (((IServant)this.servant).isGuardingArea() && super.m_8036_()) {
                return this.servant.m_20238_(((IServant)this.servant).vec3BoundPos()) > (double)Mth.m_144944_((int)this.range);
            }
            return false;
        }

        protected boolean m_25626_() {
            if (((IServant)this.servant).isGuardingArea()) {
                this.f_25602_ = ((IServant)this.servant).getBoundPos();
                return this.f_25602_ != null;
            }
            return false;
        }

        protected boolean m_6465_(LevelReader p_25619_, BlockPos p_25620_) {
            if (((IServant)this.servant).isGuardingArea()) {
                return BlockFinder.samePos(((IServant)this.servant).getBoundPos(), p_25620_);
            }
            return false;
        }
    }

    public static class HoverWanderGoal<T extends PathfinderMob>
    extends WanderGoal<T> {
        public HoverWanderGoal(T entity, double speedModifier) {
            super(entity, speedModifier);
        }

        @Override
        @Nullable
        protected Vec3 m_7037_() {
            if (((IServant)this.summonedEntity).isGuardingArea()) {
                return super.m_7037_();
            }
            Vec3 vec3 = this.summonedEntity.m_20252_(0.0f);
            int i = 8;
            Vec3 vec31 = HoverRandomPos.m_148465_((PathfinderMob)this.summonedEntity, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec31 != null ? vec31 : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.summonedEntity, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }

    public class WaterWanderGoal<T extends PathfinderMob>
    extends RandomStrollGoal {
        private final T summonedEntity;
        final /* synthetic */ Summoned this$0;

        public WaterWanderGoal(T entity) {
            this(this$0, (PathfinderMob)entity, 1.0);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public WaterWanderGoal(T speedModifier, double d) {
            this((Summoned)this$0, (PathfinderMob)entity, (double)speedModifier, 120);
            void entity;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public WaterWanderGoal(T t, double interval, int n) {
            void entity;
            this.this$0 = (Summoned)this$0;
            super((PathfinderMob)entity, (double)speedModifier, (int)interval, false);
            this.summonedEntity = entity;
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (((IServant)this.summonedEntity).isGuardingArea()) {
                return this.randomBoundPos();
            }
            return super.m_7037_();
        }

        public Vec3 randomBoundPos() {
            Vec3 vec3 = null;
            int range = IServant.GUARDING_RANGE / 2;
            for (int i = 0; i < 10; ++i) {
                BlockPos blockPos = ((IServant)this.summonedEntity).getBoundPos().m_7918_(this.summonedEntity.m_217043_().m_216332_(-range, range), this.summonedEntity.m_217043_().m_216332_(-range, range), this.summonedEntity.m_217043_().m_216332_(-range, range));
                if (this.summonedEntity.m_21573_() instanceof WaterBoundPathNavigation) {
                    if (!GoalUtils.m_148445_(this.summonedEntity, (BlockPos)blockPos)) continue;
                    vec3 = Vec3.m_82539_((Vec3i)blockPos);
                    break;
                }
                BlockPos blockPos1 = LandRandomPos.m_148518_(this.summonedEntity, (BlockPos)blockPos);
                if (blockPos1 == null) continue;
                vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                break;
            }
            return vec3;
        }

        public boolean m_8036_() {
            if (super.m_8036_()) {
                return !this.this$0.isStaying() && !this.this$0.isCommanded() || this.this$0.getTrueOwner() == null;
            }
            return false;
        }
    }

    public static class WanderGoal<T extends PathfinderMob>
    extends RandomStrollGoal {
        public final T summonedEntity;
        protected final float probability;

        public WanderGoal(T entity, double speedModifier) {
            this(entity, speedModifier, 0.001f);
        }

        public WanderGoal(T entity, double speedModifier, float probability) {
            this(entity, speedModifier, 120, probability);
        }

        public WanderGoal(T entity, double speedModifier, int interval, float probability) {
            super(entity, speedModifier, interval, false);
            this.summonedEntity = entity;
            this.probability = probability;
        }

        public boolean m_8036_() {
            if (super.m_8036_()) {
                return (!((IServant)this.summonedEntity).isStaying() && !((IServant)this.summonedEntity).isCommanded() || ((IOwned)this.summonedEntity).getTrueOwner() == null) && !(this.summonedEntity.m_21573_() instanceof WaterBoundPathNavigation);
            }
            return false;
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (((IServant)this.summonedEntity).isGuardingArea()) {
                return this.randomBoundPos();
            }
            if (this.f_25725_.m_20072_()) {
                Vec3 vec3 = this.landRandomPos(15, 7);
                return vec3 == null ? this.defaultRandomPos() : vec3;
            }
            return this.f_25725_.m_217043_().m_188501_() >= this.probability ? this.landRandomPos(10, 7) : this.defaultRandomPos();
        }

        public Vec3 defaultRandomPos() {
            return super.m_7037_();
        }

        @Nullable
        public Vec3 landRandomPos(int xz, int y) {
            if (((IOwned)this.summonedEntity).getTrueOwner() != null && ((IServant)this.summonedEntity).isFollowing()) {
                Vec3 vec3 = null;
                for (int i = 0; i < 10; ++i) {
                    BlockPos blockPos = ((IOwned)this.summonedEntity).getTrueOwner().m_20183_().m_7918_(this.summonedEntity.m_217043_().m_216332_(-xz, xz), this.summonedEntity.m_217043_().m_216332_(-y, y), this.summonedEntity.m_217043_().m_216332_(-xz, xz));
                    BlockPos blockPos1 = LandRandomPos.m_148518_(this.summonedEntity, (BlockPos)blockPos);
                    if (blockPos1 == null) continue;
                    vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                    break;
                }
                return vec3;
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)xz, (int)y);
        }

        public Vec3 randomBoundPos() {
            Vec3 vec3 = null;
            int range = IServant.GUARDING_RANGE / 2;
            for (int i = 0; i < 10; ++i) {
                BlockPos blockPos = ((IServant)this.summonedEntity).getBoundPos().m_7918_(this.summonedEntity.m_217043_().m_216332_(-range, range), this.summonedEntity.m_217043_().m_216332_(-range, range), this.summonedEntity.m_217043_().m_216332_(-range, range));
                BlockPos blockPos1 = LandRandomPos.m_148518_(this.summonedEntity, (BlockPos)blockPos);
                if (blockPos1 == null) continue;
                vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                break;
            }
            return vec3;
        }
    }

    public static class FollowOwnerWaterGoal
    extends Goal {
        protected final Summoned summonedEntity;
        private LivingEntity owner;
        private final LevelReader level;
        private final double followSpeed;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private final PathNavigation navigation;
        private final float maxDist;
        private final float minDist;

        public FollowOwnerWaterGoal(Summoned summonedEntity, double speed, float minDist, float maxDist) {
            this.summonedEntity = summonedEntity;
            this.level = summonedEntity.f_19853_;
            this.followSpeed = speed;
            this.navigation = summonedEntity.m_21573_();
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.summonedEntity.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.summonedEntity.m_20280_((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            if (!this.summonedEntity.isFollowing()) {
                return false;
            }
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            this.owner = livingentity;
            if (!livingentity.m_6084_()) {
                return false;
            }
            this.path = this.summonedEntity.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            return !(this.summonedEntity.m_20280_((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
        }

        public void m_8056_() {
            this.summonedEntity.m_21573_().m_26536_(this.path, this.followSpeed);
            this.ticksUntilNextPathRecalculation = 0;
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
        }

        public void m_8037_() {
            this.summonedEntity.m_21563_().m_24960_((Entity)this.owner, 30.0f, 30.0f);
            double d0 = this.summonedEntity.m_20275_(this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || this.owner.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.summonedEntity.m_217043_().m_188501_() < 0.05f)) {
                boolean flag;
                this.pathedTargetX = this.owner.m_20185_();
                this.pathedTargetY = this.owner.m_20186_();
                this.pathedTargetZ = this.owner.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.summonedEntity.m_217043_().m_188503_(7);
                double range = this.owner instanceof Mob ? 32.0 : 16.0;
                boolean bl = flag = d0 > Mth.m_144952_((double)range);
                flag = this.owner instanceof Mob ? (flag |= !this.summonedEntity.m_142582_((Entity)this.owner) && d0 >= Mth.m_144952_((double)8.0)) : (flag &= ((Boolean)MobsConfig.ServantTeleport.get()).booleanValue());
                if (flag) {
                    this.tryToTeleportNearEntity();
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.summonedEntity.m_21573_().m_5624_((Entity)this.owner, this.followSpeed)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        private void tryToTeleportNearEntity() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomNumber(-3, 3);
                int k = this.getRandomNumber(-1, 1);
                int l = this.getRandomNumber(-3, 3);
                boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }

        private boolean tryToTeleportToLocation(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
                return false;
            }
            this.summonedEntity.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.summonedEntity.m_146908_(), this.summonedEntity.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean isTeleportFriendlyBlock(BlockPos pos) {
            BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (pathnodetype != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(pos.m_7495_());
            if (blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pos.m_121996_((Vec3i)this.summonedEntity.m_20183_());
            return this.level.m_45756_((Entity)this.summonedEntity, this.summonedEntity.m_20191_().m_82338_(blockpos));
        }

        private int getRandomNumber(int min, int max) {
            return this.summonedEntity.m_217043_().m_188503_(max - min + 1) + min;
        }
    }
}

