/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.entities.ICharger;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.ChargeGoal;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.client.CSetDeltaMovement;
import com.Polarice3.Goety.common.network.client.CTramplerPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class AllyTrampler
extends RaiderServant
implements ICharger,
IAutoRideable,
PlayerRideableJumping {
    private static final EntityDataAccessor<Boolean> DATA_STANDING_ID = SynchedEntityData.m_135353_(AllyTrampler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING = SynchedEntityData.m_135353_(AllyTrampler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DASH = SynchedEntityData.m_135353_(AllyTrampler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AUTO_MODE = SynchedEntityData.m_135353_(AllyTrampler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float clientSideStandAnimationO;
    private float clientSideStandAnimation;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected float playerJumpPendingScale;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;
    private int dashCooldown = 0;
    public int running = 0;

    public AllyTrampler(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new TramplerChargeGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TramplerMeleeAttackGoal());
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, new RaiderServant.RaiderWanderGoal<AllyTrampler>(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.TramplerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.TramplerArmor.get()).doubleValue()).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.TramplerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.TramplerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.TramplerArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.TramplerDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STANDING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_CHARGING, (Object)false);
        this.f_19804_.m_135372_(AUTO_MODE, (Object)false);
        this.f_19804_.m_135372_(DASH, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_33353_) {
        super.m_7380_(p_33353_);
        p_33353_.m_128379_("AutoMode", this.isAutonomous());
    }

    @Override
    public void m_7378_(CompoundTag p_33344_) {
        super.m_7378_(p_33344_);
        if (p_33344_.m_128441_("AutoMode")) {
            this.setAutonomous(p_33344_.m_128471_("AutoMode"));
        }
    }

    protected float m_6108_() {
        return 0.98f;
    }

    @Override
    public void setAutonomous(boolean autonomous) {
        this.f_19804_.m_135381_(AUTO_MODE, (Object)autonomous);
        if (autonomous) {
            this.m_216990_(SoundEvents.f_11686_);
            if (!this.isWandering()) {
                this.setWandering(true);
                this.setStaying(false);
            }
        }
    }

    @Override
    public boolean isAutonomous() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_MODE);
    }

    public int m_8085_() {
        return 45;
    }

    public double m_6048_() {
        return 1.2000000000000002;
    }

    public void m_19956_(Entity rider, Entity.MoveFunction p_19958_) {
        super.m_19956_(rider, p_19958_);
        if (this.standAnimO > 0.0f) {
            float f3 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.standAnimO;
            float f2 = 0.15f * this.standAnimO;
            rider.m_6034_(this.m_20185_() + (double)(f1 * f3), this.m_20186_() + this.m_6048_() + rider.m_6049_() + (double)f2, this.m_20189_() - (double)(f1 * f));
        }
        if (rider instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)rider;
            living.f_20883_ = this.f_20883_;
        }
    }

    public int m_8100_() {
        return 400;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.TRAMPLER_AMBIENT.get();
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.TRAMPLER_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.TRAMPLER_DEATH.get();
    }

    protected void m_7355_(BlockPos p_30584_, BlockState p_30585_) {
        if (!p_30585_.m_278721_()) {
            BlockState blockstate = this.m_9236_().m_8055_(p_30584_.m_7494_());
            SoundType soundtype = p_30585_.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            }
            if (this.m_20160_() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopSoundCounter <= 5) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (this.isWoodSoundType(soundtype)) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    private boolean isWoodSoundType(SoundType p_278280_) {
        return p_278280_ == SoundType.f_56736_ || p_278280_ == SoundType.f_244244_ || p_278280_ == SoundType.f_56763_ || p_278280_ == SoundType.f_271497_ || p_278280_ == SoundType.f_243772_;
    }

    protected void playGallopSound(SoundType p_30560_) {
        this.m_5496_(SoundEvents.f_11977_, p_30560_.m_56773_() * 0.15f, p_30560_.m_56774_());
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (!this.m_21525_()) {
            Entity entity = this.m_146895_();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (((Boolean)MobsConfig.ServantRideAutonomous.get()).booleanValue()) {
                    return null;
                }
                return mob;
            }
            if (entity instanceof LivingEntity && !this.isAutonomous()) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    @Override
    public void m_8119_() {
        block14: {
            block12: {
                block13: {
                    super.m_8119_();
                    if (this.isHostile() && this.f_19797_ % 20 == 0) {
                        this.m_21406_((EntityType)ModEntityType.TRAMPLER.get(), false);
                    }
                    if (this.isDashing() && this.dashCooldown < 180 && (this.m_20096_() || this.m_20069_() || this.m_20159_())) {
                        this.setDashing(false);
                        if (this.f_19853_.f_46443_) {
                            ModNetwork.sendToServer(new CTramplerPacket(this.m_19879_(), 2));
                        } else {
                            this.f_19853_.m_7605_((Entity)this, (byte)5);
                        }
                    }
                    if (this.dashCooldown > 0) {
                        --this.dashCooldown;
                    }
                    if (!this.f_19853_.f_46443_) break block12;
                    if (this.running > 0 && this.f_19797_ % 2 == 0) {
                        this.running = 0;
                    }
                    if (this.clientSideStandAnimation != this.clientSideStandAnimationO) {
                        this.m_6210_();
                    }
                    this.clientSideStandAnimationO = this.clientSideStandAnimation;
                    this.standAnimO = this.standAnim;
                    this.mouthAnimO = this.mouthAnim;
                    if (!this.isStanding()) break block13;
                    this.clientSideStandAnimation = Mth.m_14036_((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f);
                    this.standAnim += (1.0f - this.standAnim) * 0.4f + 0.05f;
                    if (this.standAnim > 1.0f) {
                        this.standAnim = 1.0f;
                    }
                    this.mouthAnim += (1.0f - this.mouthAnim) * 0.7f + 0.05f;
                    if (!(this.mouthAnim > 1.0f)) break block14;
                    this.mouthAnim = 1.0f;
                    break block14;
                }
                this.clientSideStandAnimation = Mth.m_14036_((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
                this.standAnim += (0.8f * this.standAnim * this.standAnim * this.standAnim - this.standAnim) * 0.6f - 0.05f;
                if (this.standAnim < 0.0f) {
                    this.standAnim = 0.0f;
                }
                this.mouthAnim += (0.0f - this.mouthAnim) * 0.7f - 0.05f;
                if (!(this.mouthAnim < 0.0f)) break block14;
                this.mouthAnim = 0.0f;
                break block14;
            }
            if (this.running > 0 && this.f_19797_ % 2 == 0) {
                this.running = 0;
            }
            if (this.isDashing()) {
                LivingEntity livingEntity;
                Iterator iterator = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(2.0), selector -> !MobUtil.areAllies((Entity)this, (Entity)selector) && EntitySelector.f_20406_.test(selector)).iterator();
                while (iterator.hasNext() && !this.m_7327_((Entity)(livingEntity = (LivingEntity)iterator.next()))) {
                }
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            AttributeInstance instance = this.m_21051_(Attributes.f_22279_);
            if (instance != null) {
                double d0 = this.m_5448_() != null || this.m_146895_() instanceof Player ? 0.45 : 0.35;
                double d1 = instance.m_22115_();
                instance.m_22100_(Mth.m_14139_((double)0.1, (double)d1, (double)d0));
            }
            if (this.isCharging() || this.isDashing()) {
                this.f_267362_.m_267771_(this.f_267362_.m_267731_() + 0.8f);
            }
            if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                boolean flag = false;
                AABB aabb = this.m_20191_().m_82400_(0.2);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (!(block instanceof CropBlock)) continue;
                    flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
                }
                if (!flag && this.m_20096_()) {
                    this.m_6135_();
                }
            }
        }
    }

    public EntityDimensions m_6972_(Pose p_29531_) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.m_6972_(p_29531_).m_20390_(1.0f, f1);
        }
        return super.m_6972_(p_29531_);
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STANDING_ID);
    }

    public void setStanding(boolean p_29568_) {
        this.f_19804_.m_135381_(DATA_STANDING_ID, (Object)p_29568_);
    }

    public float getStandingAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.clientSideStandAnimationO, (float)this.clientSideStandAnimation) / 6.0f;
    }

    public float getMouthAnim(float p_30534_) {
        return Mth.m_14179_((float)p_30534_, (float)this.mouthAnimO, (float)this.mouthAnim);
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.TRAMPLER_CELEBRATE.get();
    }

    @Override
    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (this.m_20160_() && p_37849_.m_7639_() != null && this.m_6688_() != null && p_37849_.m_7639_() == this.m_6688_()) {
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    @Override
    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING);
    }

    @Override
    public void setCharging(boolean flag) {
        this.f_19804_.m_135381_(DATA_CHARGING, (Object)flag);
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.isCharging() || this.isDashing()) {
            this.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.STUNNED.get(), 100, 0, false, false));
            p_33361_.f_19864_ = true;
        }
    }

    protected void doPlayerRide(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.m_6084_()) return;
        LivingEntity rider = this.m_6688_();
        if (this.m_20160_() && !this.isStanding() && !this.isCharging() && rider instanceof Player) {
            Player player = (Player)rider;
            if (!this.isAutonomous()) {
                this.m_146922_(rider.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(rider.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float speed = this.m_245547_(player);
                if (this.running > 0) {
                    speed = 0.0f;
                }
                float f = rider.f_20900_ * speed;
                float f1 = rider.f_20902_ * speed;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.m_6336_() != MobType.f_21641_ && (this.m_20069_() && this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) > this.m_20204_() || this.m_20077_() || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType) && height > this.m_20204_()))) {
                    Vec3 vector3d = this.m_20184_();
                    this.m_20334_(vector3d.f_82479_, 0.04f, vector3d.f_82481_);
                    this.f_19812_ = true;
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * 0.04f), 0.0, (double)(0.4f * f3 * 0.04f)));
                    }
                }
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                this.f_20903_ = 0;
                this.m_267651_(false);
                return;
            }
        }
        super.m_7023_(pTravelVector);
    }

    @Override
    public boolean canUpdateMove() {
        return !(this.m_6688_() instanceof Mob);
    }

    public void m_7888_(int p_21696_) {
        if (p_21696_ < 0) {
            p_21696_ = 0;
        } else {
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + 0.8f);
        }
        this.playerJumpPendingScale = p_21696_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_21696_ / 90.0f;
    }

    public boolean m_264410_() {
        return true;
    }

    protected void m_274498_(Player p_278233_, Vec3 p_275693_) {
        super.m_274498_(p_278233_, p_275693_);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)p_278233_);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (p_278233_.m_7578_()) {
            if (this.dashCooldown <= 0 && p_278233_ instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)p_278233_;
                if (localPlayer.f_108618_.f_108572_) {
                    this.f_267362_.m_267771_(this.f_267362_.m_267731_() + 0.8f);
                    ++this.running;
                    ModNetwork.sendToServer(new CTramplerPacket(this.m_19879_(), 0));
                }
            }
            if (p_275693_.f_82481_ <= 0.0) {
                this.gallopSoundCounter = 0;
            }
            if (this.m_20096_()) {
                if (this.playerJumpPendingScale > 0.0f) {
                    this.executeRidersJump(this.playerJumpPendingScale, p_275693_);
                }
                this.playerJumpPendingScale = 0.0f;
            }
        }
    }

    protected float m_245547_(Player p_278241_) {
        float f = p_278241_.m_20142_() ? 0.1f : 0.0f;
        return (float)this.m_21133_(Attributes.f_22279_) + f;
    }

    protected Vec2 getRiddenRotation(LivingEntity p_275502_) {
        return new Vec2(p_275502_.m_146909_() * 0.5f, p_275502_.m_146908_());
    }

    protected Vec3 m_274312_(Player p_278278_, Vec3 p_275506_) {
        if (this.m_20096_() && this.playerJumpPendingScale == 0.0f || this.running > 0) {
            return Vec3.f_82478_;
        }
        float f = p_278278_.f_20900_ * 0.5f;
        float f1 = p_278278_.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected void executeRidersJump(float p_251967_, Vec3 p_275627_) {
        Vec3 vec3 = this.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)(22.2222f * p_251967_) * this.m_21133_(Attributes.f_22279_) * (double)this.m_6041_());
        Vec3 vec31 = this.m_20184_().m_82549_(vec3);
        this.dashCooldown = 200;
        this.setDashing(true);
        if (this.f_19853_.f_46443_) {
            ModNetwork.sendToServer(new CTramplerPacket(this.m_19879_(), 1));
            ModNetwork.sendToServer(new CSetDeltaMovement(this.m_19879_(), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_));
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.m_246865_(vec3);
        }
        this.f_19812_ = true;
    }

    public boolean isDashing() {
        return (Boolean)this.f_19804_.m_135370_(DASH);
    }

    public void setDashing(boolean p_251380_) {
        this.f_19804_.m_135381_(DASH, (Object)p_251380_);
    }

    public boolean m_7132_() {
        return !this.isCharging() && !this.isStanding();
    }

    public void m_7199_(int p_21695_) {
        this.setDashing(true);
        if (this.f_19853_.f_46443_) {
            ModNetwork.sendToServer(new CTramplerPacket(this.m_19879_(), 1));
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        }
    }

    public void m_8012_() {
    }

    public int m_245614_() {
        return this.dashCooldown;
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.setDashing(true);
        } else if (p_21375_ == 5) {
            this.setDashing(false);
        }
        super.m_7822_(p_21375_);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!pPlayer.f_19853_.f_46443_ && pPlayer == this.getTrueOwner()) {
            if (!pPlayer.m_6047_()) {
                if (this.m_146895_() != null && this.m_146895_() != pPlayer) {
                    this.m_146895_().m_8127_();
                    return InteractionResult.SUCCESS;
                }
                if (!(pPlayer.m_21120_(pHand).m_41720_() instanceof IWand)) {
                    this.doPlayerRide(pPlayer);
                    return InteractionResult.SUCCESS;
                }
            } else if (this.isFood(pPlayer.m_21120_(pHand)) && this.m_21223_() < this.m_21233_()) {
                FoodProperties foodProperties = pPlayer.m_21205_().getFoodProperties((LivingEntity)this);
                if (foodProperties != null) {
                    this.m_5634_(foodProperties.m_38744_());
                    if (!pPlayer.m_150110_().f_35937_) {
                        pPlayer.m_21205_().m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), 0.5f);
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean isFood(ItemStack p_30440_) {
        Item item = p_30440_.m_41720_();
        FoodProperties foodProperties = p_30440_.getFoodProperties((LivingEntity)this);
        return item.m_41472_() && foodProperties != null && foodProperties.m_38746_();
    }

    public static class TramplerChargeGoal
    extends ChargeGoal {
        public TramplerChargeGoal(PathfinderMob mob) {
            super(mob, 1.2f, 4.0, 32.0, 5, 200);
        }

        @Override
        public boolean m_8036_() {
            AllyTrampler trampler;
            PathfinderMob pathfinderMob = this.charger;
            if (pathfinderMob instanceof AllyTrampler && (trampler = (AllyTrampler)pathfinderMob).m_6688_() instanceof Player) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public double getAttackReachSqr(LivingEntity target) {
            return 6.0f + target.m_20205_();
        }
    }

    class TramplerMeleeAttackGoal
    extends MeleeAttackGoal {
        public TramplerMeleeAttackGoal() {
            super((PathfinderMob)AllyTrampler.this, 1.25, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !AllyTrampler.this.isCharging();
        }

        protected void m_6739_(LivingEntity p_29589_, double p_29590_) {
            double d0 = this.m_6639_(p_29589_);
            if (p_29590_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_29589_);
                AllyTrampler.this.setStanding(false);
            } else if (p_29590_ <= d0 * 2.0) {
                if (this.m_25564_()) {
                    AllyTrampler.this.setStanding(false);
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    AllyTrampler.this.setStanding(true);
                }
            } else {
                this.m_25563_();
                AllyTrampler.this.setStanding(false);
            }
        }

        public void m_8041_() {
            AllyTrampler.this.setStanding(false);
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity p_29587_) {
            return 4.0f + p_29587_.m_20205_();
        }
    }
}

