/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.illager.SpellcasterIllagerServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Neollager
extends AbstractIllagerServant {
    protected static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(Neollager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_MAGIC = SynchedEntityData.m_135353_(Neollager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int age;
    protected int forcedAge;
    protected int forcedAgeTimer;

    public Neollager(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new LoomGoal(this));
        this.f_21345_.m_25352_(2, new AvoidTargetGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 0.6, 1.0));
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<Neollager>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.NeollagerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.NeollagerArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.NeollagerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.NeollagerArmor.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BABY_ID, (Object)false);
        this.f_19804_.m_135372_(IS_MAGIC, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Magic")) {
            this.setMagic(compound.m_128471_("Magic"));
        }
        if (compound.m_128441_("Age")) {
            this.setAge(compound.m_128451_("Age"));
        }
        if (compound.m_128441_("ForcedAge")) {
            this.forcedAge = compound.m_128451_("ForcedAge");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Magic", this.isMagic());
        compound.m_128405_("Age", this.getAge());
        compound.m_128405_("ForcedAge", this.forcedAge);
    }

    public void m_7350_(EntityDataAccessor<?> p_146754_) {
        if (DATA_BABY_ID.equals(p_146754_)) {
            this.m_6210_();
        }
        super.m_7350_(p_146754_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_7975_(DamageSource p_35498_) {
        return SoundEvents.f_12310_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    @Override
    public boolean canBeLeader() {
        return false;
    }

    @Override
    public boolean canJoinPatrol() {
        return false;
    }

    public int getAge() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_BABY_ID) != false ? -1 : 1;
        }
        return this.age;
    }

    public void ageUp(int seconds, boolean particles) {
        int i = this.getAge();
        if ((i += seconds * 20) > 0) {
            i = 0;
        }
        int j = i - i;
        this.setAge(i);
        if (particles) {
            this.forcedAge += j;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int seconds) {
        this.ageUp(seconds, false);
    }

    public void setAge(int age) {
        int i = this.getAge();
        this.age = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.f_19804_.m_135381_(DATA_BABY_ID, (Object)(age < 0 ? 1 : 0));
            this.ageBoundaryReached();
        }
    }

    public boolean m_6162_() {
        return this.getAge() < 0;
    }

    public void m_6863_(boolean p_146756_) {
        this.setAge(p_146756_ ? -24000 : 0);
    }

    public void setMagic(boolean magic) {
        this.f_19804_.m_135381_(IS_MAGIC, (Object)magic);
    }

    public boolean isMagic() {
        return (Boolean)this.f_19804_.m_135370_(IS_MAGIC);
    }

    @Override
    public boolean canTrain(Level level, BlockPos blockPos, EntityType<? extends Mob> entityType) {
        Mob mob = (Mob)entityType.m_20615_(this.f_19853_);
        if (super.canTrain(level, blockPos, entityType)) {
            if (mob instanceof SpellcasterIllagerServant) {
                return this.isMagic();
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData data = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pLevel.m_6018_().m_213780_().m_188501_() <= 0.15f) {
            this.setMagic(true);
        }
        return data;
    }

    @Override
    public void convertNewEquipment(Entity entity) {
        Villager villager;
        VillagerProfession profession;
        if (entity instanceof Villager && ((profession = (villager = (Villager)entity).m_7141_().m_35571_()) == VillagerProfession.f_35589_ || profession == VillagerProfession.f_35594_)) {
            this.setMagic(true);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.m_6084_()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
    }

    protected void ageBoundaryReached() {
        Boat boat;
        Entity entity;
        if (!this.m_6162_() && this.m_20159_() && (entity = this.m_20202_()) instanceof Boat && !(boat = (Boat)entity).m_271938_((Entity)this)) {
            this.m_8127_();
        }
    }

    @Override
    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> p_21407_, boolean p_21408_) {
        T convert = super.m_21406_(p_21407_, p_21408_);
        if (convert instanceof AbstractIllagerServant) {
            AbstractIllagerServant servant = (AbstractIllagerServant)convert;
            if (((Boolean)MobsConfig.IllagerServantTrainArmor.get()).booleanValue() && ((Boolean)MobsConfig.RaiderServantWearArmor.get()).booleanValue() && this.getTrueOwner() != null && CuriosFinder.hasCurio(this.getTrueOwner(), (Item)ModItems.RING_OF_THE_FORGE.get())) {
                servant.spawnArmor(this.getTrueOwner().m_217043_());
            }
        }
        return convert;
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (!this.m_6162_() && itemstack.m_204117_(ItemTags.f_13191_) && this.m_21205_().m_41619_()) {
                if (this.getLeaderBannerInstance().m_41619_()) {
                    this.m_5496_(SoundEvents.f_12307_, 1.0f, 0.75f);
                    this.f_19853_.m_7605_((Entity)this, (byte)9);
                    return InteractionResult.FAIL;
                }
                if (!ItemHelper.sameBanner(itemstack, this.getBannerPatternInstance()) && !this.f_19853_.f_46443_) {
                    this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (pPlayer.m_21205_().m_41619_() && pPlayer.m_6144_() && this.m_21205_().m_204117_(ItemTags.f_13191_)) {
                ItemStack helmet = this.m_6844_(EquipmentSlot.MAINHAND);
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.dropEquipment(EquipmentSlot.MAINHAND, helmet);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public static class LoomGoal
    extends Goal {
        public Neollager illager;
        @Nullable
        public BlockPos loom;
        @Nullable
        public Path path;
        public int workTick;

        public LoomGoal(Neollager illager) {
            this.illager = illager;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.illager.m_21205_().m_204117_(ItemTags.f_13191_) && !this.illager.getLeaderBannerInstance().m_41619_()) {
                Path path;
                this.loom = this.findLoom();
                if (this.loom != null && (path = this.illager.m_21573_().m_7864_(this.loom, 1)) != null && path.m_77403_()) {
                    this.path = path;
                    return this.illager.m_5448_() == null && this.path != null && this.path.m_77403_();
                }
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.loom != null && this.path != null && this.path.m_77403_()) {
                return this.illager.f_19853_.m_8055_(this.loom).m_60713_(Blocks.f_50617_) && super.m_8045_();
            }
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            this.loom = null;
            this.path = null;
            this.workTick = 0;
        }

        public void m_8037_() {
            if (this.loom == null) {
                this.m_8041_();
                return;
            }
            if (this.illager.m_20238_(Vec3.m_82539_((Vec3i)this.loom)) > (double)Mth.m_144944_((int)2)) {
                this.illager.m_21573_().m_26519_((double)this.loom.m_123341_(), (double)this.loom.m_123342_(), (double)this.loom.m_123343_(), 0.5);
            } else {
                this.illager.m_21573_().m_26573_();
                this.illager.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82539_((Vec3i)this.loom));
                ++this.workTick;
                if (this.workTick > 100) {
                    this.illager.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    ItemEntity itementity = new ItemEntity(this.illager.f_19853_, (double)((float)this.loom.m_123341_() + 0.5f), (double)((float)this.loom.m_123342_() + 1.0f), (double)((float)this.loom.m_123343_() + 0.5f), this.illager.getLeaderBannerInstance());
                    itementity.m_32060_();
                    this.illager.m_216990_(SoundEvents.f_12492_);
                    this.illager.f_19853_.m_7967_((Entity)itementity);
                    Level level = this.illager.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, (Entity)this.illager);
                    }
                }
            }
        }

        public BlockPos findLoom() {
            ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
            for (int i = -8; i <= 8; ++i) {
                for (int j = -8; j <= 8; ++j) {
                    for (int k = -8; k <= 8; ++k) {
                        BlockPos blockPos12 = this.illager.m_20183_().m_7918_(i, j, k);
                        BlockState blockState = this.illager.f_19853_.m_8055_(blockPos12);
                        if (!blockState.m_60713_(Blocks.f_50617_)) continue;
                        blockPosList.add(blockPos12);
                    }
                }
            }
            if (!blockPosList.isEmpty()) {
                blockPosList.sort(Comparator.comparingDouble(blockPos1 -> this.illager.m_20238_(Vec3.m_82512_((Vec3i)blockPos1))));
                if (blockPosList.stream().findFirst().isPresent()) {
                    return (BlockPos)blockPosList.stream().findFirst().get();
                }
            }
            return null;
        }
    }
}

