/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public abstract class SpellcasterIllagerServant
extends AbstractIllagerServant {
    private static final EntityDataAccessor<Byte> DATA_SPELL_CASTING_ID = SynchedEntityData.m_135353_(SpellcasterIllagerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int spellCastingTickCount;
    private IllagerServantSpell currentSpell = IllagerServantSpell.NONE;

    public SpellcasterIllagerServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SPELL_CASTING_ID, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.spellCastingTickCount = compound.m_128451_("SpellTicks");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SpellTicks", this.spellCastingTickCount);
    }

    @Override
    public AbstractIllagerServant.IllagerServantArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllagerServant.IllagerServantArmPose.SPELLCASTING;
        }
        return this.isCelebrating() ? AbstractIllagerServant.IllagerServantArmPose.CELEBRATING : AbstractIllagerServant.IllagerServantArmPose.CROSSED;
    }

    public boolean isCastingSpell() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(DATA_SPELL_CASTING_ID) > 0;
        }
        return this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(IllagerServantSpell p_33728_) {
        this.currentSpell = p_33728_;
        this.f_19804_.m_135381_(DATA_SPELL_CASTING_ID, (Object)((byte)p_33728_.id));
    }

    protected IllagerServantSpell getCurrentSpell() {
        return !this.f_19853_.f_46443_ ? this.currentSpell : IllagerServantSpell.byId(((Byte)this.f_19804_.m_135370_(DATA_SPELL_CASTING_ID)).byteValue());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.spellParticles();
    }

    public void spellParticles() {
        IllagerServantSpell spell;
        if (this.f_19853_.f_46443_ && this.isCastingSpell() && (spell = this.getCurrentSpell()) != IllagerServantSpell.NONE) {
            double d0 = spell.spellColor[0];
            double d1 = spell.spellColor[1];
            double d2 = spell.spellColor[2];
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected abstract SoundEvent getCastingSoundEvent();

    public static enum IllagerServantSpell {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2),
        RAVAGING(6, 0.3764705882352941, 0.37254901960784315, 0.35294117647058826);

        private static final IntFunction<IllagerServantSpell> BY_ID;
        final int id;
        final double[] spellColor;

        private IllagerServantSpell(int p_33754_, double p_33755_, double p_33756_, double p_33757_) {
            this.id = p_33754_;
            this.spellColor = new double[]{p_33755_, p_33756_, p_33757_};
        }

        public static IllagerServantSpell byId(int p_33759_) {
            return BY_ID.apply(p_33759_);
        }

        static {
            BY_ID = ByIdMap.m_262839_(p_263091_ -> p_263091_.id, (Object[])IllagerServantSpell.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    protected abstract class SpellcasterUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected SpellcasterUseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = SpellcasterIllagerServant.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (SpellcasterIllagerServant.this.isCastingSpell()) {
                    return false;
                }
                return SpellcasterIllagerServant.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = SpellcasterIllagerServant.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            this.attackWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            SpellcasterIllagerServant.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = SpellcasterIllagerServant.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                SpellcasterIllagerServant.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
            SpellcasterIllagerServant.this.setIsCastingSpell(this.getSpell());
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                SpellcasterIllagerServant.this.m_5496_(SpellcasterIllagerServant.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract IllagerServantSpell getSpell();
    }

    protected class SpellcasterCastingSpellGoal
    extends Goal {
        public SpellcasterCastingSpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SpellcasterIllagerServant.this.getSpellCastingTime() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            SpellcasterIllagerServant.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            SpellcasterIllagerServant.this.setIsCastingSpell(IllagerServantSpell.NONE);
        }

        public void m_8037_() {
            if (SpellcasterIllagerServant.this.m_5448_() != null) {
                SpellcasterIllagerServant.this.m_21563_().m_24960_((Entity)SpellcasterIllagerServant.this.m_5448_(), (float)SpellcasterIllagerServant.this.m_8085_(), (float)SpellcasterIllagerServant.this.m_8132_());
            }
        }
    }
}

