/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead;

import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.neutral.SummonedFlying;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class PhantomServant
extends SummonedFlying {
    public static final float FLAP_DEGREES_PER_TICK = 7.448451f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(PhantomServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    Vec3 moveTargetPoint = Vec3.f_82478_;
    BlockPos anchorPoint = BlockPos.f_121853_;
    AttackPhase attackPhase = AttackPhase.CIRCLE;

    public PhantomServant(EntityType<? extends SummonedFlying> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new PhantomMoveControl((Mob)this);
        this.f_21365_ = new PhantomLookControl((Mob)this);
    }

    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    protected BodyRotationControl m_7560_() {
        return new PhantomBodyRotationControl((Mob)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PhantomAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new PhantomSweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new PhantomCircleAroundAnchorGoal());
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(1, (Goal)new PhantomFollowOwnerGoal());
    }

    @Override
    public void targetSelectGoal() {
        this.f_21346_.m_25352_(1, (Goal)new PhantomAttackPlayerTargetGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.PhantomServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.PhantomServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.PhantomServantInitialDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.PhantomServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.PhantomServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.PhantomServantInitialDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
    }

    public void setPhantomSize(int p_33109_) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)p_33109_, (int)0, (int)64));
    }

    private void updatePhantomSizeInfo() {
        this.m_6210_();
        AttributeInstance instance = this.m_21051_(Attributes.f_22281_);
        if (instance != null) {
            double attack = (Double)AttributesConfig.PhantomServantSizeDamage.get();
            instance.m_22100_(attack + (double)this.getPhantomSize());
        }
    }

    public int getPhantomSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    protected float m_6431_(Pose p_33136_, EntityDimensions p_33137_) {
        return p_33137_.f_20378_ * 0.35f;
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (ID_SIZE.equals(p_33134_)) {
            this.updatePhantomSizeInfo();
        }
        super.m_7350_(p_33134_);
    }

    @Override
    public boolean canStay() {
        return false;
    }

    public boolean m_20145_() {
        if (this.isUpgraded() && ((Boolean)MobsConfig.PhantomServantTranslucent.get()).booleanValue()) {
            return true;
        }
        return super.m_20145_();
    }

    @Override
    public boolean m_20177_(Player p_20178_) {
        if (this.isUpgraded() && ((Boolean)MobsConfig.PhantomServantTranslucent.get()).booleanValue()) {
            return false;
        }
        return super.m_20177_(p_20178_);
    }

    public int getUniqueFlapTickOffset() {
        return this.m_19879_() * 3;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isUpgraded()) {
            this.f_19794_ = true;
        }
        if (this.f_19853_.f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            int i = this.getPhantomSize();
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33126_, DifficultyInstance p_33127_, MobSpawnType p_33128_, @Nullable SpawnGroupData p_33129_, @Nullable CompoundTag p_33130_) {
        this.anchorPoint = this.m_20183_().m_6630_(5);
        this.setPhantomSize(0);
        return super.m_6518_(p_33126_, p_33127_, p_33128_, p_33129_, p_33130_);
    }

    @Override
    public void m_6710_(@Nullable LivingEntity p_21544_) {
        this.normalSetTarget(p_21544_);
    }

    @Override
    public void m_7378_(CompoundTag p_33132_) {
        super.m_7378_(p_33132_);
        if (p_33132_.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(p_33132_.m_128451_("AX"), p_33132_.m_128451_("AY"), p_33132_.m_128451_("AZ"));
        }
        this.setPhantomSize(p_33132_.m_128451_("Size"));
    }

    @Override
    public void m_7380_(CompoundTag p_33141_) {
        super.m_7380_(p_33141_);
        p_33141_.m_128405_("AX", this.anchorPoint.m_123341_());
        p_33141_.m_128405_("AY", this.anchorPoint.m_123342_());
        p_33141_.m_128405_("AZ", this.anchorPoint.m_123343_());
        p_33141_.m_128405_("Size", this.getPhantomSize());
    }

    public boolean m_6783_(double p_33107_) {
        return true;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12227_;
    }

    protected SoundEvent m_7975_(DamageSource p_33152_) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6549_(EntityType<?> p_33111_) {
        return true;
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        int i = this.getPhantomSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        float f = (entitydimensions.f_20377_ + 0.2f * (float)i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public double m_6048_() {
        return this.m_20192_();
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class PhantomMoveControl
    extends MoveControl {
        private float speed;

        public PhantomMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void m_8126_() {
            if (PhantomServant.this.f_19862_) {
                PhantomServant.this.m_146922_(PhantomServant.this.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = PhantomServant.this.moveTargetPoint.f_82479_ - PhantomServant.this.m_20185_();
            double d1 = PhantomServant.this.moveTargetPoint.f_82480_ - PhantomServant.this.m_20186_();
            double d2 = PhantomServant.this.moveTargetPoint.f_82481_ - PhantomServant.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = PhantomServant.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(PhantomServant.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                PhantomServant.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                PhantomServant.this.f_20883_ = PhantomServant.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)PhantomServant.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                PhantomServant.this.m_146926_(f4);
                float f5 = PhantomServant.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = PhantomServant.this.m_20184_();
                PhantomServant.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    static class PhantomLookControl
    extends LookControl {
        public PhantomLookControl(Mob p_33235_) {
            super(p_33235_);
        }

        public void m_8128_() {
        }
    }

    class PhantomBodyRotationControl
    extends BodyRotationControl {
        public PhantomBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void m_8121_() {
            PhantomServant.this.f_20885_ = PhantomServant.this.f_20883_;
            PhantomServant.this.f_20883_ = PhantomServant.this.m_146908_();
        }
    }

    class PhantomAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        PhantomAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = PhantomServant.this.m_5448_();
            return livingentity != null;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            PhantomServant.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            PhantomServant.this.anchorPoint = PhantomServant.this.isGuardingArea() ? PhantomServant.this.getBoundPos() : PhantomServant.this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, PhantomServant.this.anchorPoint).m_6630_(10 + PhantomServant.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (PhantomServant.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    PhantomServant.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + PhantomServant.this.f_19796_.m_188503_(4)) * 20);
                    PhantomServant.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + PhantomServant.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            if (PhantomServant.this.m_5448_() != null) {
                boolean flag = true;
                if (PhantomServant.this.isGuardingArea() && PhantomServant.this.getBoundPos() != null && PhantomServant.this.m_5448_().m_20238_(PhantomServant.this.vec3BoundPos()) > (double)Mth.m_144944_((int)IServant.GUARDING_RANGE)) {
                    PhantomServant.this.anchorPoint = PhantomServant.this.getBoundPos();
                    flag = false;
                }
                if (flag) {
                    PhantomServant.this.anchorPoint = PhantomServant.this.m_5448_().m_20183_().m_6630_(20 + PhantomServant.this.f_19796_.m_188503_(20));
                    if (PhantomServant.this.anchorPoint.m_123342_() < PhantomServant.this.f_19853_.m_5736_()) {
                        PhantomServant.this.anchorPoint = new BlockPos(PhantomServant.this.anchorPoint.m_123341_(), PhantomServant.this.f_19853_.m_5736_() + 1, PhantomServant.this.anchorPoint.m_123343_());
                    }
                }
            }
        }
    }

    class PhantomSweepAttackGoal
    extends PhantomMoveTargetGoal {
        private static final int CAT_SEARCH_TICK_DELAY = 20;
        private boolean isScaredOfCat;
        private int catSearchTick;

        PhantomSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return PhantomServant.this.m_5448_() != null && PhantomServant.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = PhantomServant.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!EntitySelector.f_20406_.test(livingentity)) {
                return false;
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (PhantomServant.this.f_19797_ > this.catSearchTick) {
                this.catSearchTick = PhantomServant.this.f_19797_ + 20;
                List list = PhantomServant.this.f_19853_.m_6443_(Cat.class, PhantomServant.this.m_20191_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8041_() {
            PhantomServant.this.m_6710_(null);
            PhantomServant.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = PhantomServant.this.m_5448_();
            if (livingentity != null) {
                PhantomServant.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (PhantomServant.this.m_20191_().m_82400_((double)0.2f).m_82381_(livingentity.m_20191_())) {
                    PhantomServant.this.m_7327_((Entity)livingentity);
                    PhantomServant.this.attackPhase = AttackPhase.CIRCLE;
                    if (!PhantomServant.this.m_20067_()) {
                        PhantomServant.this.f_19853_.m_46796_(1039, PhantomServant.this.m_20183_(), 0);
                    }
                } else if (PhantomServant.this.f_19862_ || PhantomServant.this.f_20916_ > 0) {
                    PhantomServant.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class PhantomCircleAroundAnchorGoal
    extends PhantomMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        PhantomCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return PhantomServant.this.m_5448_() == null || PhantomServant.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + PhantomServant.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + PhantomServant.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = PhantomServant.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (PhantomServant.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + PhantomServant.this.f_19796_.m_188501_() * 9.0f;
            }
            if (PhantomServant.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (PhantomServant.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = PhantomServant.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (PhantomServant.this.moveTargetPoint.f_82480_ < PhantomServant.this.m_20186_() && !PhantomServant.this.f_19853_.m_46859_(PhantomServant.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (PhantomServant.this.moveTargetPoint.f_82480_ > PhantomServant.this.m_20186_() && !PhantomServant.this.f_19853_.m_46859_(PhantomServant.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (PhantomServant.this.isGuardingArea() && PhantomServant.this.getBoundPos() != null) {
                PhantomServant.this.anchorPoint = PhantomServant.this.getBoundPos();
            } else if (BlockPos.f_121853_.equals((Object)PhantomServant.this.anchorPoint)) {
                PhantomServant.this.anchorPoint = PhantomServant.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            PhantomServant.this.moveTargetPoint = Vec3.m_82528_((Vec3i)PhantomServant.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class PhantomFollowOwnerGoal
    extends Goal {
        PhantomFollowOwnerGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = PhantomServant.this.getTrueOwner();
            return livingentity != null && PhantomServant.this.isFollowing() && PhantomServant.this.m_5448_() == null && PhantomServant.this.attackPhase != AttackPhase.SWOOP;
        }

        public void m_8056_() {
            PhantomServant.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveOwner();
        }

        public void m_8041_() {
            PhantomServant.this.anchorPoint = PhantomServant.this.isGuardingArea() ? PhantomServant.this.getBoundPos() : PhantomServant.this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, PhantomServant.this.anchorPoint).m_6630_(10 + PhantomServant.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (PhantomServant.this.attackPhase == AttackPhase.CIRCLE) {
                this.setAnchorAboveOwner();
            }
        }

        private void setAnchorAboveOwner() {
            PhantomServant.this.anchorPoint = PhantomServant.this.getTrueOwner().m_20183_().m_6630_(10 + PhantomServant.this.f_19796_.m_188503_(10));
        }
    }

    class PhantomAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting;
        private int nextScanTick;

        PhantomAttackPlayerTargetGoal() {
            this.attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0).m_26888_(SummonTargetGoal.predicate((LivingEntity)PhantomServant.this));
            this.nextScanTick = PhantomAttackPlayerTargetGoal.m_186073_((int)20);
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
            } else {
                this.nextScanTick = PhantomAttackPlayerTargetGoal.m_186073_((int)60);
                List list = PhantomServant.this.f_19853_.m_45971_(LivingEntity.class, this.attackTargeting, (LivingEntity)PhantomServant.this, PhantomServant.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
                if (!list.isEmpty()) {
                    list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                    for (LivingEntity livingEntity : list) {
                        if (MobUtil.areAllies((Entity)PhantomServant.this, (Entity)livingEntity)) continue;
                        PhantomServant.this.m_6710_(livingEntity);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = PhantomServant.this.m_5448_();
            return livingentity != null && livingentity.m_6084_();
        }
    }

    abstract class PhantomMoveTargetGoal
    extends Goal {
        public PhantomMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return PhantomServant.this.moveTargetPoint.m_82531_(PhantomServant.this.m_20185_(), PhantomServant.this.m_20186_(), PhantomServant.this.m_20189_()) < 4.0;
        }
    }
}

