/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.zombie;

import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FrozenZombieServant
extends ZombieServant
implements RangedAttackMob {
    public int throwCooldown;

    public FrozenZombieServant(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new ThrowSnowballGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.FrozenZombieServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.FrozenZombieServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.FrozenZombieServantArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.FrozenZombieServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.FrozenZombieServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.FrozenZombieServantDamage.get());
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("throwCooldown", this.throwCooldown);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.throwCooldown = pCompound.m_128451_("throwCooldown");
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.FROZEN_ZOMBIE_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.FROZEN_ZOMBIE_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.FROZEN_ZOMBIE_DEATH.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.throwCooldown > 0) {
            --this.throwCooldown;
        }
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        Snowball snowball = new Snowball(this.f_19853_, (LivingEntity)this);
        Vec3 vec3 = p_33317_.m_20184_();
        double d0 = p_33317_.m_20185_() + vec3.f_82479_ - this.m_20185_();
        double d1 = p_33317_.m_20186_() + vec3.f_82480_ - this.m_20188_();
        double d2 = p_33317_.m_20189_() + vec3.f_82481_ - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        snowball.m_146926_(snowball.m_146909_() - -20.0f);
        snowball.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
        this.m_5496_(SoundEvents.f_12473_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)snowball);
        this.throwCooldown = MathHelper.secondsToTicks(3);
    }

    static class ThrowSnowballGoal
    extends Goal {
        public FrozenZombieServant zombie;
        public int start;

        public ThrowSnowballGoal(FrozenZombieServant zombie) {
            this.zombie = zombie;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity living = this.zombie.m_5448_();
            if (living != null) {
                return living.m_20270_((Entity)this.zombie) >= 6.0f && living.m_20270_((Entity)this.zombie) <= 16.0f && this.zombie.throwCooldown <= 0;
            }
            return false;
        }

        public void m_8056_() {
            this.start = 10;
            if (this.zombie.m_21205_().m_41619_()) {
                this.zombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42452_));
            } else if (this.zombie.m_21206_().m_41619_()) {
                this.zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42452_));
            }
            super.m_8056_();
        }

        public void m_8041_() {
            this.start = 0;
            if (this.zombie.m_21205_().m_150930_(Items.f_42452_)) {
                this.zombie.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            } else if (this.zombie.m_21206_().m_150930_(Items.f_42452_)) {
                this.zombie.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            super.m_8041_();
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity living = this.zombie.m_5448_();
            if (living != null) {
                if (this.start <= 0) {
                    this.zombie.m_6504_(living, 0.0f);
                } else {
                    --this.start;
                    this.zombie.f_21365_.m_148051_((Entity)living);
                    this.zombie.f_21344_.m_26573_();
                }
            }
        }
    }
}

