/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.servants;

import com.Polarice3.Goety.common.entities.neutral.SummonedFlying;
import com.Polarice3.Goety.common.entities.projectiles.HellBlast;
import com.Polarice3.Goety.common.entities.projectiles.Lavaball;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Malghast
extends SummonedFlying {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(Malghast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Malghast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float explosionPower = 1.0f;
    public float fireBallDamage;
    private int oldSwell;
    private int swell;
    private int stun;

    public Malghast(EntityType<? extends SummonedFlying> type, Level p_i48578_2_) {
        super(type, p_i48578_2_);
        this.f_21342_ = new MoveHelperController(this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.addFlyingGoal();
        this.addFireballGoal();
    }

    @Override
    public void followGoal() {
    }

    public void addFlyingGoal() {
        this.f_21345_.m_25352_(5, (Goal)new FlyingGoal(this));
    }

    public void addFireballGoal() {
        this.f_21345_.m_25352_(7, (Goal)new FireballAttackGoal(this));
    }

    public MobType m_6336_() {
        return ModMobType.NETHER;
    }

    @Override
    public void m_8119_() {
        if (this.m_6084_()) {
            int maxSwell;
            this.oldSwell = this.swell;
            if (this.isCharging()) {
                this.setSwellDir(1);
                this.stun = 40;
            } else {
                this.setSwellDir(-1);
                if (this.stun > 0) {
                    --this.stun;
                }
            }
            int i = this.getSwellDir();
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= (maxSwell = 20)) {
                this.swell = maxSwell;
            }
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.isStaying()) {
            this.m_21566_().m_24988_(0.0f, 0.0f);
        }
    }

    public float getSwelling(float pPartialTicks) {
        return ((float)this.oldSwell + (float)(this.swell - this.oldSwell) * pPartialTicks) / 20.0f;
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean pAttacking) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)pAttacking);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int pState) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)pState);
    }

    public float getExplosionPower() {
        return this.explosionPower;
    }

    public void setExplosionPower(float damage) {
        this.explosionPower = damage;
    }

    public float getFireBallDamage() {
        return this.fireBallDamage;
    }

    public void setFireBallDamage(float damage) {
        this.fireBallDamage = damage;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 1.3f;
    }

    private static boolean isReflectedFireball(DamageSource p_238408_) {
        return p_238408_.m_7640_() instanceof LargeFireball && p_238408_.m_7639_() instanceof Player;
    }

    public boolean m_6673_(DamageSource p_238289_) {
        return !Malghast.isReflectedFireball(p_238289_) && super.m_6673_(p_238289_);
    }

    @Override
    public boolean m_6469_(DamageSource p_32730_, float p_32731_) {
        if (Malghast.isReflectedFireball(p_32730_)) {
            super.m_6469_(p_32730_, 1000.0f);
            return true;
        }
        return !this.m_6673_(p_32730_) && super.m_6469_(p_32730_, p_32731_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.MalghastHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.MalghastHealth.get());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11919_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11921_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public float m_6100_() {
        return 0.75f;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ExplosionPower", this.explosionPower);
        pCompound.m_128350_("FireballDamage", this.getFireBallDamage());
        pCompound.m_128405_("Stun", this.stun);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ExplosionPower", 99)) {
            this.explosionPower = pCompound.m_128457_("ExplosionPower");
        }
        if (pCompound.m_128441_("FireballDamage")) {
            this.setFireBallDamage(pCompound.m_128457_("FireballDamage"));
        }
        this.stun = pCompound.m_128451_("Stun");
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setGhastSpawn();
        return pSpawnData;
    }

    public void setGhastSpawn() {
        if (this.isNatural()) {
            this.setHostile(true);
        }
        if (this.getTrueOwner() == null) {
            this.setBoundPos(this.m_20183_());
            this.setWandering(false);
            this.setStaying(false);
        }
    }

    @Override
    public void lifeSpanDamage() {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
            }
        }
        this.m_5496_((SoundEvent)ModSounds.GHAST_DISAPPEAR.get(), this.m_6121_(), this.m_6100_());
        this.m_146870_();
    }

    @Override
    public void tryKill(Player player) {
        this.lifeSpanDamage();
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    protected ResourceLocation m_7582_() {
        if (this.isNatural()) {
            return EntityType.f_20453_.m_20677_();
        }
        return super.m_7582_();
    }

    static class MoveHelperController
    extends MoveControl {
        private final Malghast ghast;
        private int floatDuration;

        public MoveHelperController(Malghast p_i45838_1_) {
            super((Mob)p_i45838_1_);
            this.ghast = p_i45838_1_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.m_217043_().m_188503_(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.ghast.m_20185_(), this.f_24976_ - this.ghast.m_20186_(), this.f_24977_ - this.ghast.m_20189_());
                double d0 = vector3d.m_82553_();
                vector3d = vector3d.m_82541_();
                if (this.ghast.stun <= 0) {
                    if (this.canReach(vector3d, Mth.m_14165_((double)d0))) {
                        this.ghast.m_20256_(this.ghast.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                    } else {
                        this.f_24981_ = MoveControl.Operation.WAIT;
                    }
                } else {
                    this.ghast.m_20256_(Vec3.f_82478_);
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.ghast.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.ghast.f_19853_.m_45756_((Entity)this.ghast, axisalignedbb = axisalignedbb.m_82383_(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final Malghast ghast;

        public LookAroundGoal(Malghast p_i45839_1_) {
            this.ghast = p_i45839_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.ghast.m_5448_() == null) {
                Vec3 vector3d = this.ghast.m_20184_();
                this.ghast.m_146922_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
            } else {
                LivingEntity livingentity = this.ghast.m_5448_();
                double d1 = livingentity.m_20185_() - this.ghast.m_20185_();
                double d2 = livingentity.m_20189_() - this.ghast.m_20189_();
                this.ghast.m_21563_().m_24960_((Entity)livingentity, 10.0f, (float)this.ghast.m_8132_());
                this.ghast.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
            }
            this.ghast.f_20883_ = this.ghast.m_146908_();
        }
    }

    static class FlyingGoal
    extends Goal {
        private final Malghast ghast;

        public FlyingGoal(Malghast p_i45836_1_) {
            this.ghast = p_i45836_1_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl moveControl = this.ghast.m_21566_();
            if (this.ghast.isCommanded() || this.ghast.isStaying()) {
                return false;
            }
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.ghast.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.ghast.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.ghast.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.ghast.m_217043_();
            float distance = 16.0f;
            BlockPos blockPos = null;
            if (this.ghast.getBoundPos() != null) {
                BlockPos blockPos1;
                blockPos = this.ghast.getBoundPos();
                if (this.ghast.m_5448_() != null && this.ghast.isWithinGuard(blockPos1 = this.ghast.m_5448_().m_20183_().m_6630_(4))) {
                    blockPos = blockPos1;
                }
            } else if (this.ghast.getTrueOwner() != null && this.ghast.isFollowing()) {
                blockPos = this.ghast.getTrueOwner().m_20183_().m_6630_(4);
            } else if (this.ghast.m_5448_() != null) {
                blockPos = this.ghast.m_5448_().m_20183_().m_6630_(4);
            }
            if (blockPos != null) {
                if (this.ghast.m_20238_(Vec3.m_82512_((Vec3i)blockPos)) < (double)Mth.m_14207_((float)distance)) {
                    Vec3 vector3d = Vec3.m_82512_((Vec3i)blockPos).m_82546_(this.ghast.m_20182_()).m_82541_();
                    double X = this.ghast.m_20185_() + vector3d.f_82479_ * (double)distance + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                    double Y = this.ghast.m_20186_() + vector3d.f_82480_ * (double)distance + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                    double Z = this.ghast.m_20189_() + vector3d.f_82481_ * (double)distance + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                    this.ghast.m_21566_().m_6849_(X, Y, Z, 0.25);
                } else {
                    this.ghast.m_21566_().m_6849_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.25);
                }
            } else {
                double d0 = this.ghast.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                double d1 = this.ghast.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                double d2 = this.ghast.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * distance);
                this.ghast.m_21566_().m_6849_(d0, d1, d2, 0.25);
            }
        }
    }

    static class FireballAttackGoal
    extends Goal {
        private final Malghast ghast;
        public int chargeTime;
        public boolean shotTimes;

        public FireballAttackGoal(Malghast p_i45837_1_) {
            this.ghast = p_i45837_1_;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
            this.shotTimes = true;
        }

        public void m_8041_() {
            this.ghast.setCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ghast.m_5448_();
            float d0 = 64.0f;
            if (livingentity != null && livingentity.m_20280_((Entity)this.ghast) < (double)Mth.m_14207_((float)d0) && this.ghast.m_142582_((Entity)livingentity)) {
                Level world = this.ghast.f_19853_;
                ++this.chargeTime;
                if (this.chargeTime == 10) {
                    boolean bl = this.shotTimes = this.ghast.f_19796_.m_188501_() >= 0.25f;
                    if (!this.ghast.m_20067_()) {
                        if (this.shotTimes) {
                            this.ghast.m_5496_(SoundEvents.f_11924_, 5.0f, (this.ghast.f_19796_.m_188501_() - this.ghast.f_19796_.m_188501_()) * 0.2f + this.ghast.m_6100_());
                        } else {
                            this.ghast.m_5496_(SoundEvents.f_11922_, 5.0f, (this.ghast.f_19796_.m_188501_() - this.ghast.f_19796_.m_188501_()) * 0.2f + this.ghast.m_6100_());
                        }
                    }
                }
                if (this.chargeTime == 20) {
                    Object fireballentity;
                    double d1 = 2.0;
                    Vec3 vector3d = this.ghast.m_20252_(1.0f);
                    double d2 = livingentity.m_20185_() - (this.ghast.m_20185_() + vector3d.f_82479_ * d1);
                    double d3 = livingentity.m_20227_(0.5) - this.ghast.m_20227_(0.5);
                    double d4 = livingentity.m_20189_() - (this.ghast.m_20189_() + vector3d.f_82481_ * d1);
                    if (!this.ghast.m_20067_()) {
                        if (this.shotTimes) {
                            this.ghast.m_5496_((SoundEvent)ModSounds.HELL_BLAST_SHOOT.get(), 5.0f, (this.ghast.f_19796_.m_188501_() - this.ghast.f_19796_.m_188501_()) * 0.2f + 1.0f);
                        } else {
                            this.ghast.m_5496_(SoundEvents.f_11923_, 5.0f, (this.ghast.f_19796_.m_188501_() - this.ghast.f_19796_.m_188501_()) * 0.2f + 1.0f);
                        }
                    }
                    int power = (int)(this.ghast.getExplosionPower() + this.ghast.f_19853_.m_6436_(this.ghast.m_20183_()).m_19057_());
                    int charge = -40;
                    if (this.shotTimes) {
                        fireballentity = new HellBlast((LivingEntity)this.ghast, d2, d3, d4, world);
                        charge = -20;
                    } else {
                        fireballentity = new Lavaball(world, (LivingEntity)this.ghast, d2, d3, d4);
                        if (fireballentity instanceof Lavaball) {
                            Lavaball lavaball = (Lavaball)((Object)fireballentity);
                            lavaball.setExplosionPower(power);
                        }
                    }
                    double y = this.ghast.m_20186_() <= livingentity.m_20188_() ? this.ghast.m_20227_(0.5) : this.ghast.m_20186_();
                    fireballentity.m_6034_(this.ghast.m_20185_() + vector3d.f_82479_ * d1, y, fireballentity.m_20189_() + vector3d.f_82481_ * d1);
                    world.m_7967_((Entity)fireballentity);
                    this.ghast.m_147240_(1.0, livingentity.m_20185_() - this.ghast.m_20185_(), livingentity.m_20189_() - this.ghast.m_20189_());
                    this.chargeTime = charge;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.ghast.setCharging(this.chargeTime > 10);
        }
    }
}

